/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.healing;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PassiveHealEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.healing.PassiveHealingTicker;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;

public class WalkingPassiveHealingTicker
implements PassiveHealingTicker {
    @Override
    public void tick(ServerPlayer player, PlayerPartyStorage party) {
        ++party.transientData.passiveHealTick;
        if (party.transientData.passiveHealTick >= 20 && PixelmonConfigProxy.getGeneral().getHealing().isUsePassiveHealer() && BattleRegistry.getBattle((Player)player) == null) {
            this.doWalkHealing(player, party);
            party.transientData.passiveHealTick = 0;
        }
    }

    public int doWalkHealing(ServerPlayer player, PlayerPartyStorage party) {
        int posX = player.m_20183_().m_123341_();
        int posZ = player.m_20183_().m_123343_();
        TransientData td = party.transientData;
        int changeX = td.lastPassiveHealX - posX;
        int changeZ = td.lastPassiveHealZ - posZ;
        td.lastPassiveHealX = posX;
        td.lastPassiveHealZ = posZ;
        if (changeX == -posX && changeZ == -posZ) {
            return 0;
        }
        int steps = Math.abs(changeX) + Math.abs(changeZ);
        if (steps > 20) {
            return 0;
        }
        if (steps == 0) {
            return 0;
        }
        boolean revive = false;
        boolean status = false;
        boolean heal = RandomHelper.getRandomChance((float)steps / (float)PixelmonConfigProxy.getGeneral().getHealing().getStepsToHealHealthPassively());
        for (int i = 0; i < steps; ++i) {
            if (!revive && RandomHelper.getRandomChance(PixelmonConfigProxy.getGeneral().getHealing().getChanceToRevivePassively())) {
                revive = true;
            }
            if (status || !RandomHelper.getRandomChance(PixelmonConfigProxy.getGeneral().getHealing().getChanceToHealStatusPassively())) continue;
            status = true;
        }
        Pokemon pokemon = party.getAll()[RandomHelper.getRandom().nextInt(6)];
        PassiveHealEvent.Pre pre = new PassiveHealEvent.Pre(player, pokemon, revive, status, heal);
        Pixelmon.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            return 0;
        }
        if (pokemon != null) {
            double percentageHP;
            DelegateLink link = new DelegateLink(pokemon);
            if (revive && pokemon.isFainted()) {
                ((PokemonLink)link).sendMessage("pixelmon.effect.revived", ((PokemonLink)link).getNickname());
                ((PokemonLink)link).setHealth(1);
                ((PokemonLink)link).update(EnumUpdateType.HP);
                status = false;
                heal = false;
            }
            if (status && !pokemon.isFainted()) {
                if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Burn && ((PokemonLink)link).removeStatuses(StatusType.Burn)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.burncure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Paralysis && ((PokemonLink)link).removeStatuses(StatusType.Paralysis)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.paralysiscure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Poison && ((PokemonLink)link).removeStatuses(StatusType.Poison)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.poisoncure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.PoisonBadly && ((PokemonLink)link).removeStatuses(StatusType.PoisonBadly)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.poisoncure", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Sleep && ((PokemonLink)link).removeStatuses(StatusType.Sleep)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.wokeup", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                } else if (((PokemonLink)link).getPrimaryStatus().type == StatusType.Freeze && ((PokemonLink)link).removeStatuses(StatusType.Freeze)) {
                    ((PokemonLink)link).sendMessage("pixelmon.status.breakice", ((PokemonLink)link).getNickname());
                    heal = false;
                    ((PokemonLink)link).update(EnumUpdateType.Status);
                }
            }
            if (heal && (percentageHP = (double)((PokemonLink)link).getHealth() / (double)((PokemonLink)link).getMaxHealth()) < (double)PixelmonConfigProxy.getGeneral().getHealing().getPassiveHealingMaxHealthPercentage() && ((PokemonLink)link).getHealth() + 1 <= ((PokemonLink)link).getMaxHealth() && ((PokemonLink)link).getHealth() != 0) {
                ((PokemonLink)link).setHealth(((PokemonLink)link).getHealth() + 1);
                ((PokemonLink)link).update(EnumUpdateType.HP);
            }
            Pixelmon.EVENT_BUS.post((Event)new PassiveHealEvent.Post(player, pokemon, revive, status, heal));
        }
        return steps;
    }
}

