/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.hatch;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.hatch.EggHatcher;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import net.minecraft.server.level.ServerPlayer;

public class WalkingEggHatcher
implements EggHatcher {
    @Override
    public void tick(ServerPlayer player, PlayerPartyStorage party) {
        ++party.transientData.eggTick;
        if (party.transientData.eggTick >= 20) {
            party.transientData.eggTick = 0;
            this.doWalkHatching(player, party);
        }
    }

    public int doWalkHatching(ServerPlayer player, PlayerPartyStorage party) {
        if (party.countEggs() < 1) {
            return 0;
        }
        TransientData td = party.transientData;
        int posX = player.m_20183_().m_123341_();
        int posZ = player.m_20183_().m_123343_();
        int changeX = td.lastEggX - posX;
        int changeZ = td.lastEggZ - posZ;
        td.lastEggX = posX;
        td.lastEggZ = posZ;
        if (changeX == -posX && changeZ == -posZ) {
            return 0;
        }
        int steps = Math.abs(changeX) + Math.abs(changeZ);
        if (steps > 20) {
            return 0;
        }
        if (steps == 0) {
            return 0;
        }
        int hatchBonus = this.getHatchBonus(party);
        for (Pokemon pokemon : party.getAll()) {
            if (pokemon == null || !pokemon.isEgg()) continue;
            pokemon.addEggSteps(steps, hatchBonus);
        }
        return steps;
    }
}

