/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.hatch;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;

public interface EggHatcher {
    public static final List<RegistryValue<Ability>> ABILITIES = Lists.newArrayList((Object[])new RegistryValue[]{AbilityRegistry.MAGMA_ARMOR, AbilityRegistry.FLAME_BODY, AbilityRegistry.STEAM_ENGINE});

    public void tick(ServerPlayer var1, PlayerPartyStorage var2);

    default public int getHatchBonus(PlayerPartyStorage party) {
        for (Pokemon pokemon : party.getTeam()) {
            int stack = 0;
            for (RegistryValue<Ability> ability : ABILITIES) {
                if (!pokemon.getAbility().isAbility(ability)) continue;
                ++stack;
            }
            if (stack <= 0) continue;
            return 2 * stack;
        }
        return 1;
    }
}

