/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.export.impl;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.export.ImportExportForm;
import com.pixelmonmod.pixelmon.api.pokemon.export.PokemonConverterProxy;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.PokemonImportException;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.ShowdownFieldType;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.ShowdownImportException;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.HiddenPower;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.FormData;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class ShowdownConverter
implements PokemonConverterProxy {
    public static final String SPECIES_TEXT = "Pok\u00e9mon";
    public static final String GENDER_TEXT = "Gender";
    public static final String ABILITY_TEXT = "Ability";
    public static final String LEVEL_TEXT = "Level";
    public static final String SHINY_TEXT = "Shiny";
    public static final String HAPPINESS_TEXT = "Happiness";
    public static final String EV_TEXT = "EVs";
    public static final String NATURE_TEXT = "Nature";
    public static final String IV_TEXT = "IVs";
    public static final String POKE_BALL_TEXT = "Poke Ball";
    public static final String GROWTH_TEXT = "Growth";
    public static final String CLONES_TEXT = "Clones";
    public static final String RUBY_TEXT = "Rubies";
    public static final String MINIOR_CORE_TEXT = "MiniorCore";
    public static final String SMELT_TEXT = "Smelts";
    public static final String MOVE_TEXT = "Moves";
    public static final String[] STAT_TEXT = new String[]{"HP", "Atk", "Def", "SpA", "SpD", "Spe"};
    public static final char MALE_SYMBOL = 'M';
    public static final char FEMALE_SYMBOL = 'F';
    public static final String SHINY_YES = "Yes";
    public static final String SHINY_NO = "No";

    @Override
    public String getExportText(Pokemon data) {
        String nickname;
        StringBuilder exportText = new StringBuilder();
        Object exportName = data.getSpecies().getName();
        if (!(data.getForm().getName().isEmpty() || data.getForm().isForm("singlestrike") || data.getForm().isForm("amped"))) {
            exportName = (String)exportName + "-" + data.getForm().getName().toLowerCase(Locale.ROOT).replace("hisuian", "Hisui").replace("alolan", "Alola").replace("galarian", "Galar").replace("pompom", "Pom-Pom").replace("lowkey", "Low-Key").replace("rapidstrike", "Rapid-Strike").replace("battle_bond", "Bond");
        }
        if (data.canGigantamax()) {
            exportName = (String)exportName + "-Gmax";
        }
        if (!(data.getPalette().getName().isEmpty() || data.isShiny() || data.getGenderProperties().isDefaultPalette(data.getPalette()))) {
            exportName = (String)exportName + "-" + data.getPalette().getName();
        }
        if ((nickname = data.getNickname()) == null || nickname.equals(exportName) || nickname.isEmpty()) {
            exportText.append((String)exportName);
        } else {
            exportText.append(nickname);
            exportText.append(" (");
            exportText.append((String)exportName);
            exportText.append(")");
        }
        if (data.getGender() != Gender.NONE) {
            exportText.append(" (");
            exportText.append(data.getGender() == Gender.MALE ? (char)'M' : 'F');
            exportText.append(")");
        }
        if (!data.getHeldItem().m_41619_() && data.getHeldItemAsItemHeld() != null && ForgeRegistries.ITEMS.getKey((Object)data.getHeldItemAsItemHeld()) != null) {
            exportText.append(" @ ");
            exportText.append(WordUtils.capitalize((String)ForgeRegistries.ITEMS.getKey((Object)data.getHeldItemAsItemHeld()).m_135815_().replace("_", " ")));
        }
        exportText.append("   \n");
        ShowdownConverter.addColonSeparated(exportText, ABILITY_TEXT, ShowdownConverter.convertCamelCaseToWords(data.getAbilityName()));
        ShowdownConverter.addColonSeparated(exportText, LEVEL_TEXT, data.getPokemonLevel());
        ShowdownConverter.addColonSeparated(exportText, SHINY_TEXT, data.isShiny() ? SHINY_YES : SHINY_NO);
        ShowdownConverter.addColonSeparated(exportText, HAPPINESS_TEXT, data.getFriendship());
        ShowdownConverter.writeStats(exportText, data.getEVs().getArray(), EV_TEXT, 0);
        exportText.append(data.getBaseNature().toString());
        exportText.append(" ");
        exportText.append(NATURE_TEXT);
        exportText.append("\n");
        ShowdownConverter.writeStats(exportText, data.getIVs().getArray(), IV_TEXT, 31);
        ShowdownConverter.addColonSeparated(exportText, POKE_BALL_TEXT, data.getBall().getName());
        ShowdownConverter.addColonSeparated(exportText, GROWTH_TEXT, data.getGrowth());
        if (data.getExtraStats() instanceof MewStats) {
            ShowdownConverter.addColonSeparated(exportText, CLONES_TEXT, ((MewStats)data.getExtraStats()).numCloned);
        }
        if (data.getExtraStats() instanceof LakeTrioStats) {
            ShowdownConverter.addColonSeparated(exportText, RUBY_TEXT, ((LakeTrioStats)data.getExtraStats()).numEnchanted);
        }
        if (data.getExtraStats() instanceof MeltanStats) {
            ShowdownConverter.addColonSeparated(exportText, SMELT_TEXT, ((MeltanStats)data.getExtraStats()).nuggetsFed);
        }
        StringJoiner joiner = new StringJoiner("\n");
        for (int i = 0; i < data.getMoveset().size(); ++i) {
            Attack attack;
            if (data.getMoveset().get(i) == null || (attack = data.getMoveset().get(i)) == null) continue;
            joiner.add("- " + attack.getMove().getAttackName());
        }
        return exportText.append(joiner).toString();
    }

    public static void addColonSeparated(StringBuilder builder, String label, Object value) {
        builder.append(label);
        builder.append(": ");
        builder.append(value.toString());
        builder.append("\n");
    }

    private static String convertCamelCaseToWords(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        int textLength = text.length();
        for (int i = 0; i < textLength; ++i) {
            char currentChar = text.charAt(i);
            if (currentChar >= 'A' && currentChar <= 'Z' && i > 0) {
                newText.append(' ');
            }
            newText.append(currentChar);
        }
        return newText.toString();
    }

    private static void writeStats(StringBuilder exportText, int[] statArray, String statType, int defaultValue) {
        boolean defaultStats = true;
        for (int stat : statArray) {
            if (stat == defaultValue) continue;
            defaultStats = false;
            break;
        }
        if (!defaultStats) {
            exportText.append(statType);
            exportText.append(": ");
            boolean hasPrevious = false;
            for (int i = 0; i < statArray.length; ++i) {
                if (hasPrevious) {
                    exportText.append(" / ");
                }
                exportText.append(statArray[i]);
                exportText.append(" ");
                exportText.append(STAT_TEXT[i]);
                hasPrevious = true;
            }
            exportText.append("\n");
        }
    }

    @Override
    public List<Pokemon> importText(String ... importText) throws PokemonImportException {
        ArrayList imported = Lists.newArrayList();
        StringBuilder built = new StringBuilder();
        for (int i = 0; i < importText.length; ++i) {
            String s = importText[i];
            if (s.isEmpty() && !built.toString().isEmpty()) {
                imported.add(this.importText(built.toString()));
                built = new StringBuilder();
                continue;
            }
            built.append(s).append(System.lineSeparator());
        }
        if (!built.toString().trim().isEmpty()) {
            imported.add(this.importText(built.toString()));
        }
        return imported;
    }

    @Override
    public Pokemon importText(String importText) throws ShowdownImportException {
        String heldItemName;
        Item newHeldItem;
        Optional<FormData> formDataOptional;
        int atIndex;
        Object speciesName;
        PokemonBuilder builder = PokemonBuilder.builder().level(100).nature(Nature.HARDY).shiny(false).ivs(31, 31, 31, 31, 31, 31).friendship(255).level(PixelmonServerConfig.maxLevel).caughtBall(PokeBallRegistry.POKE_BALL.getValueUnsafe()).growth(EnumGrowth.Ordinary);
        String[] importTextSplit = importText.split("\n");
        if (importTextSplit.length == 0) {
            throw new ShowdownImportException(importText, "Unhandled empty newline", importTextSplit, ShowdownFieldType.SPECIES, "[]");
        }
        String currentLine = importTextSplit[0];
        int leftParenthesesIndex = currentLine.lastIndexOf(40);
        int genderIndex = -1;
        int numMoves = 0;
        if (leftParenthesesIndex > -1) {
            int rightParenthesesIndex = currentLine.indexOf(41, leftParenthesesIndex);
            String nextField = currentLine.substring(leftParenthesesIndex + 1, rightParenthesesIndex).trim();
            if (nextField.length() == 1) {
                genderIndex = leftParenthesesIndex;
                char genderChar = nextField.charAt(0);
                if (genderChar == 'M') {
                    builder.gender(Gender.MALE);
                } else if (genderChar == 'F') {
                    builder.gender(Gender.FEMALE);
                } else {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_gender", Character.valueOf(genderChar), ShowdownFieldType.GENDER, "" + genderChar);
                }
                leftParenthesesIndex = currentLine.lastIndexOf(40, leftParenthesesIndex - 1);
            } else {
                throw new ShowdownImportException(importText, "showdown.import.exception.invalid_gender", nextField, ShowdownFieldType.GENDER, nextField);
            }
        }
        if (leftParenthesesIndex > -1) {
            builder.nickname(currentLine.substring(0, leftParenthesesIndex).trim());
            int rightParenthesesIndex = currentLine.indexOf(41, leftParenthesesIndex);
            speciesName = currentLine.substring(leftParenthesesIndex + 1, rightParenthesesIndex);
            atIndex = currentLine.indexOf(64, rightParenthesesIndex);
        } else {
            atIndex = currentLine.indexOf(64);
            speciesName = genderIndex > -1 ? currentLine.substring(0, genderIndex) : (atIndex > -1 ? currentLine.substring(0, atIndex) : currentLine);
        }
        if (ImportExportForm.getGmaxData((String)speciesName)) {
            builder.gigantamaxFactor();
            speciesName = ((String)speciesName).replace("-Gmax", "");
        }
        if (((String)speciesName).toLowerCase().contains(PixelmonSpecies.TOXTRICITY.getKey().toLowerCase()) && !((String)speciesName).toLowerCase().contains("low-key") && !((String)speciesName).toLowerCase().contains("amped")) {
            speciesName = (String)speciesName + "-amped";
        }
        if ((formDataOptional = ImportExportForm.getFormData(((String)(speciesName = ((String)speciesName).trim())).replace("-Alola", "-alolan").replace("-Galar", "-galarian").replace("-Hisui", "-hisuian").replace("-Pom-Pom", "-pompom").replace("-Bond", "-battle_bond"))).isPresent()) {
            FormData formData = formDataOptional.get();
            builder.species(formData.species);
            builder.form(formData.form);
        } else {
            builder.species(((String)speciesName).trim());
        }
        if (builder.getSpecies() == null || builder.getSpecies().is(PixelmonSpecies.MISSINGNO)) {
            throw new ShowdownImportException(importText, "showdown.import.exception.invalid_species", speciesName, ShowdownFieldType.SPECIES, currentLine);
        }
        if (atIndex > -1 && (newHeldItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of("pixelmon:" + (heldItemName = currentLine.substring(atIndex + 1).trim()).replace(" ", "_").replace("-", "_").replace("'", "").toLowerCase(Locale.ROOT)))) != null) {
            builder.heldItem(new ItemStack((ItemLike)newHeldItem));
        }
        boolean[] ivsSet = new boolean[6];
        String currentLineAfterColon = "";
        for (int currentIndex = 1; currentIndex < importTextSplit.length; ++currentIndex) {
            currentLine = importTextSplit[currentIndex];
            currentLineAfterColon = this.getStringAfterColon(currentLine);
            if (currentLine.startsWith(ABILITY_TEXT)) {
                Optional<Ability> ability;
                String parsedAbility = this.getStringAfterColon(currentLine).replace(" ", "").replace("-", "");
                if (parsedAbility.equals("BattleArmor") || parsedAbility.equals("ShellArmor")) {
                    parsedAbility = parsedAbility.replaceAll("o", "ou");
                }
                if (parsedAbility.equals("BattleBond")) {
                    builder.palette("alter");
                }
                if ((ability = AbilityRegistry.getAbility(parsedAbility)).isEmpty()) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_ability", parsedAbility, ShowdownFieldType.ABILITY, currentLine);
                }
                builder.ability(ability.get());
                continue;
            }
            if (currentLine.startsWith(LEVEL_TEXT)) {
                try {
                    builder.level(Integer.parseInt(this.getStringAfterColon(currentLine)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_level", currentLineAfterColon, ShowdownFieldType.LEVEL, currentLine);
                }
            }
            if (currentLine.startsWith(SHINY_TEXT)) {
                String shinyText = this.getStringAfterColon(currentLine);
                if (SHINY_YES.equalsIgnoreCase(shinyText)) {
                    builder.shiny();
                    continue;
                }
                if (SHINY_NO.equalsIgnoreCase(shinyText)) {
                    builder.shiny(false);
                    continue;
                }
                throw new ShowdownImportException(importText, "showdown.import.exception.invalid_shiny_status", currentLineAfterColon, ShowdownFieldType.SHINY, currentLine);
            }
            if (currentLine.startsWith(HAPPINESS_TEXT)) {
                try {
                    builder.friendship(Integer.parseInt(this.getStringAfterColon(currentLine)));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_happiness", currentLineAfterColon, ShowdownFieldType.HAPPINESS, this.getStringAfterColon(currentLine));
                }
            }
            if (currentLine.startsWith(EV_TEXT)) {
                builder.evs(this.parseStats(currentLine, null, (statValue, totalStats) -> {
                    int limitedStatValue = Math.max(0, Math.min(255, statValue));
                    return Math.min(limitedStatValue, 510 - totalStats);
                }, 0));
                continue;
            }
            if (currentLine.trim().endsWith(NATURE_TEXT)) {
                String natureText = currentLine.substring(0, currentLine.indexOf(32));
                Nature nature = Nature.natureFromString(natureText);
                if (nature == null) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_nature", natureText, ShowdownFieldType.NATURE, currentLine);
                }
                if (formDataOptional.isPresent()) {
                    FormData formData = formDataOptional.get();
                    if (formData.species.is(PixelmonSpecies.TOXTRICITY) && !Objects.equals(PixelmonForms.getToxtricityFormFromNature(nature), formData.form)) {
                        throw new ShowdownImportException(importText, "showdown.import.exception.invalid_nature_toxtricity", natureText, ShowdownFieldType.NATURE, currentLine);
                    }
                }
                builder.nature(nature);
                continue;
            }
            if (currentLine.startsWith(IV_TEXT)) {
                builder.ivs(this.parseStats(currentLine, ivsSet, (statValue, totalStats) -> Math.max(0, Math.min(31, statValue)), 31));
                continue;
            }
            if (currentLine.startsWith(POKE_BALL_TEXT)) {
                try {
                    builder.caughtBall(PokeBallRegistry.getPokeBall(this.getStringAfterColon(currentLine)).getValueUnsafe());
                    continue;
                }
                catch (IllegalArgumentException | NoSuchElementException e) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_ball", currentLineAfterColon, ShowdownFieldType.CAUGHT_BALL, currentLine);
                }
            }
            if (currentLine.startsWith(GROWTH_TEXT)) {
                EnumGrowth growth = EnumGrowth.getGrowthFromString(this.getStringAfterColon(currentLine));
                if (growth == null) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_growth", currentLineAfterColon, ShowdownFieldType.GROWTH, currentLine);
                }
                builder.growth(growth);
                continue;
            }
            if (currentLine.startsWith(CLONES_TEXT)) {
                try {
                    int numClones = Integer.parseInt(this.getStringAfterColon(currentLine));
                    builder.extraStats(new MewStats(numClones));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_clones", currentLineAfterColon, ShowdownFieldType.CLONES, currentLine);
                }
            }
            if (currentLine.startsWith(RUBY_TEXT)) {
                try {
                    int numEnchants = Integer.parseInt(this.getStringAfterColon(currentLine));
                    builder.extraStats(new LakeTrioStats(numEnchants));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_rubies", currentLineAfterColon, ShowdownFieldType.RUBY, currentLine);
                }
            }
            if (currentLine.startsWith(SMELT_TEXT)) {
                try {
                    int numSmelts = Integer.parseInt(this.getStringAfterColon(currentLine));
                    builder.extraStats(new MeltanStats(numSmelts));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_smelts", currentLineAfterColon, ShowdownFieldType.SMELTS, currentLine);
                }
            }
            if (currentLine.isEmpty() || currentLine.charAt(0) != '-' || (currentLine = currentLine.trim()).length() <= 1) continue;
            if (numMoves >= 4) {
                throw new ShowdownImportException(importText, "showdown.import.exception.too_many_attacks", "", ShowdownFieldType.ATTACKS, currentLine);
            }
            String moveText = currentLine.substring(1).trim();
            if (moveText.contains("Hidden Power")) {
                String typeText = moveText.replace("Hidden Power ", "").replace("[", "").replace("]", "");
                Element hiddenPowerType = Element.parseType(typeText);
                if (hiddenPowerType == null) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.invalid_hidden_power_type", "", ShowdownFieldType.ATTACKS, currentLine);
                }
                int[] hiddenPowerIVs = HiddenPower.calculateOptimalIVs(hiddenPowerType, builder.getIvs(), ivsSet);
                if (hiddenPowerIVs == null) {
                    throw new ShowdownImportException(importText, "showdown.import.exception.conflict_iv_hp", "", ShowdownFieldType.ATTACKS, currentLine);
                }
                builder.ivs(hiddenPowerIVs);
                moveText = "Hidden Power";
            }
            if (!Attack.hasAttack(moveText)) {
                throw new ShowdownImportException(importText, "showdown.import.exception.invalid_attack", moveText, ShowdownFieldType.ATTACKS, currentLine);
            }
            Attack move = new Attack(moveText);
            builder.move(numMoves++, move);
        }
        return builder.build();
    }

    public int getIntAfterColon(String string) {
        return Integer.parseInt(this.getStringAfterColon(string));
    }

    public String getStringAfterColon(String string) {
        return string.substring(string.indexOf(58) + 1).trim();
    }

    private int[] parseStats(String statString, boolean[] statSet, StatValidator validator, int base) {
        int[] statArray = new int[]{base, base, base, base, base, base};
        String[] splitStats = this.getStringAfterColon(statString).split("/");
        int totalStats = 0;
        for (String stat : splitStats) {
            stat = stat.trim();
            String statType = stat.substring(stat.lastIndexOf(32) + 1);
            for (int i = 0; i < STAT_TEXT.length; ++i) {
                if (!STAT_TEXT[i].equalsIgnoreCase(statType)) continue;
                int statAmount = NumberHelper.parseInt(stat.substring(0, stat.indexOf(32))).orElse(base);
                statArray[i] = statAmount = validator.validateStat(statAmount, totalStats);
                totalStats += statAmount;
                if (statSet == null) continue;
                statSet[i] = true;
            }
        }
        return statArray;
    }

    private static interface StatValidator {
        public int validateStat(int var1, int var2);
    }
}

