/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.export;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.export.exception.PokemonImportException;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface PokemonConverterProxy {
    default public String getFormattedExportedText(PartyStorage party) {
        return String.join((CharSequence)(System.lineSeparator() + System.lineSeparator()), this.getExportText(party.getAll()));
    }

    default public String getFormattedExportedText(Collection<Pokemon> pokemon) {
        return String.join((CharSequence)(System.lineSeparator() + System.lineSeparator()), this.getExportText(pokemon));
    }

    default public String getFormattedExportedText(Pokemon ... pokemon) {
        return String.join((CharSequence)(System.lineSeparator() + System.lineSeparator()), this.getExportText(pokemon));
    }

    default public List<String> getExportText(PartyStorage party) {
        return this.getExportText(party.getAll());
    }

    default public List<String> getExportText(Collection<Pokemon> pokemon) {
        return this.getExportText(pokemon.toArray(new Pokemon[0]));
    }

    default public List<String> getExportText(Pokemon ... pokemon) {
        ArrayList exportedText = Lists.newArrayList();
        for (Pokemon data : pokemon) {
            if (data == null) continue;
            exportedText.add(this.getExportText(data));
        }
        return exportedText;
    }

    public String getExportText(Pokemon var1);

    default public List<Pokemon> importText(Collection<String> importText) throws PokemonImportException {
        return this.importText(importText.toArray(new String[0]));
    }

    default public List<Pokemon> importText(String ... importText) throws PokemonImportException {
        ArrayList imported = Lists.newArrayList();
        for (String s : importText) {
            imported.add(this.importText(s));
        }
        return imported;
    }

    public Pokemon importText(String var1) throws PokemonImportException;
}

