/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.egg.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.egg.BreedingLogicFactory;
import com.pixelmonmod.pixelmon.api.pokemon.egg.EggGroup;
import com.pixelmonmod.pixelmon.api.pokemon.egg.impl.UniversalEggGroup;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.abilities.Abilities;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class PixelmonBreedingLogic
implements BreedingLogicFactory {
    private static final List<RegistryValue<Species>> NIDORAN_SPECIES = Lists.newArrayList((Object[])new RegistryValue[]{PixelmonSpecies.NIDORANFEMALE, PixelmonSpecies.NIDORANMALE});
    private static final List<RegistryValue<Species>> BAT_SPECIES = Lists.newArrayList((Object[])new RegistryValue[]{PixelmonSpecies.ILLUMISE, PixelmonSpecies.VOLBEAT});

    @Override
    public Optional<Pokemon> makeEgg(Pokemon parentOne, Pokemon parentTwo) {
        if (!this.canBreed(parentOne, parentTwo)) {
            return Optional.empty();
        }
        if (parentOne.isPokemonOptional(PixelmonSpecies.DITTO) && parentTwo.isPokemonOptional(PixelmonSpecies.DITTO)) {
            if (!PixelmonConfigProxy.getBreeding().isAllowDittoDittoBreeding()) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.makeRandomEgg(parentOne, parentTwo));
        }
        Species pokemon = this.calculateSpecies(parentOne, parentTwo);
        Stats form = this.calculateForm(parentOne, parentTwo, pokemon);
        String palette = this.calculatePalette(parentOne, parentTwo, pokemon);
        Pair<Integer, Boolean> abilityData = this.getEggAbilitySlot(form, parentOne, parentTwo);
        return Optional.of(PokemonBuilder.builder().species(pokemon).makeEgg().form(form.getName()).gender(Gender.getRandomGender(form)).ivs(this.getIVsForEgg(parentOne, parentTwo).getArray()).nature(this.getNatureForEgg(parentOne, parentTwo)).caughtBall(this.getPokeBall(parentOne, parentTwo)).growth(this.getEggGrowth(parentOne, parentTwo)).abilitySlot((Integer)abilityData.getFirst(), (Boolean)abilityData.getSecond()).palette(palette).moves(this.getEggMoveset(form, parentOne, parentTwo).toArray(new Attack[4])).build());
    }

    @Override
    public boolean canBreed(Pokemon parentOne, Pokemon parentTwo) {
        for (EggGroup parentOneGroup : parentOne.getForm().getEggGroups()) {
            for (EggGroup parentTwoGroup : parentTwo.getForm().getEggGroups()) {
                if (!parentOneGroup.canBreedWith(parentTwoGroup) || !parentTwoGroup.canBreedWith(parentOneGroup) || !(parentOneGroup instanceof UniversalEggGroup) && !(parentTwoGroup instanceof UniversalEggGroup) && (!parentOneGroup.canBreed(parentOne.getGender(), parentTwo.getGender()) || !parentTwoGroup.canBreed(parentOne.getGender(), parentTwo.getGender()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Stats calculateForm(Pokemon parentOne, Pokemon parentTwo, Species child) {
        List<Stats> forms;
        boolean parentTwoEverstone;
        boolean inherit1 = !parentOne.isPokemonOptional(PixelmonSpecies.DITTO) && (parentTwo.isPokemonOptional(PixelmonSpecies.DITTO) || parentOne.getGender() == Gender.FEMALE);
        AtomicReference<Pokemon> parentToCheck = new AtomicReference<Pokemon>(inherit1 ? parentOne : parentTwo);
        boolean parentOneEverstone = parentOne.getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone;
        boolean bl = parentTwoEverstone = parentTwo.getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.everStone;
        if (parentOneEverstone && parentTwoEverstone) {
            if (RandomHelper.getRandom().nextBoolean()) {
                parentToCheck.set(parentOne.getGender() == Gender.MALE ? parentOne : parentTwo);
            } else {
                parentToCheck.set(parentOne.getGender() == Gender.FEMALE ? parentOne : parentTwo);
            }
        } else if (parentOneEverstone) {
            parentToCheck.set(parentOne);
        } else if (parentTwoEverstone) {
            parentToCheck.set(parentTwo);
        } else {
            if (child.is(PixelmonSpecies.MINIOR)) {
                return child.getForm("core");
            }
            return child.getDefaultForm();
        }
        if (!parentToCheck.get().hasChild(child)) {
            parentToCheck.updateAndGet(currentValue -> currentValue == parentOne ? parentTwo : parentOne);
        }
        if (parentToCheck.get().getForm().isRegional()) {
            String formName = parentToCheck.get().getForm().getName();
            Predicate<Stats> predicate = stats -> stats.getName().equalsIgnoreCase(formName);
            if (parentToCheck.get().getForm().isHisuian()) {
                predicate = Stats::isHisuian;
            } else if (parentToCheck.get().getForm().isGalarian()) {
                predicate = Stats::isGalarian;
            } else if (parentToCheck.get().getForm().isPaldean()) {
                predicate = Stats::isPaldean;
            }
            List<Stats> forms2 = child.getForms(predicate);
            if (forms2.isEmpty()) {
                return child.getDefaultForm();
            }
            if (forms2.size() == 1) {
                return forms2.get(0);
            }
        }
        if ((forms = child.getForms(stats -> stats.getName().equalsIgnoreCase(((Pokemon)parentToCheck.get()).getForm().getName()))).isEmpty()) {
            return child.getDefaultForm();
        }
        return forms.get(0);
    }

    @Override
    public String calculatePalette(Pokemon parentOne, Pokemon parentTwo, Species child) {
        String palette = "none";
        if (child.is(PixelmonSpecies.MINIOR)) {
            Pokemon parentMinior;
            Pokemon pokemon = parentMinior = parentOne.getSpecies().is(PixelmonSpecies.MINIOR) ? parentOne : parentTwo;
            if (!parentMinior.isShiny()) {
                palette = parentMinior.getPalette().getName();
            } else {
                ArrayList paletteList = Lists.newArrayList();
                for (PaletteProperties paletteMinior : parentMinior.getGenderProperties().getPalettes()) {
                    if (Objects.equals(paletteMinior.getName(), "shiny")) continue;
                    paletteList.add(paletteMinior);
                }
                palette = ((PaletteProperties)CollectionHelper.getRandomElement(paletteList)).getName();
            }
        }
        return this.shouldEggBeShiny(parentOne, parentTwo) ? "shiny" : palette;
    }

    @Override
    public Pokemon makeRandomEgg(Pokemon parentOne, Pokemon parentTwo) {
        Species species = PixelmonSpecies.getRandomSpecies(!PixelmonConfigProxy.getBreeding().isAllowRandomBreedingEggsToBeLegendary(), !PixelmonConfigProxy.getBreeding().isAllowRandomBreedingEggsToBeMythic(), !PixelmonConfigProxy.getBreeding().isAllowRandomBreedingEggsToBeUltrabeast());
        Stats form = species.getDefaultForm();
        return PokemonBuilder.builder().species(species).form(form.getName()).level(1).ability(form.getAbilities().getRandomAbility()).ivs(this.getIVsForEgg(parentOne, parentTwo).getArray()).nature(this.getNatureForEgg(parentOne, parentTwo)).growth(this.getEggGrowth(parentOne, parentTwo)).palette(this.shouldEggBeShiny(parentOne, parentTwo) ? "shiny" : "none").gender(Gender.getRandomGender(form)).build();
    }

    @Override
    public Species calculateSpecies(Pokemon parentOne, Pokemon parentTwo) {
        Item itemFromOtherParent;
        boolean inherit1 = !parentOne.isPokemonOptional(PixelmonSpecies.DITTO) && (parentTwo.isPokemonOptional(PixelmonSpecies.DITTO) || parentOne.getGender() == Gender.FEMALE);
        Pokemon parentForEggLine = inherit1 ? parentOne : parentTwo;
        Item itemFromParent = parentForEggLine.getHeldItem().m_41720_();
        Item item = itemFromOtherParent = inherit1 ? parentTwo.getHeldItem().m_41720_() : parentOne.getHeldItem().m_41720_();
        if (parentForEggLine.isPokemonOptional(PixelmonSpecies.NIDORANFEMALE, PixelmonSpecies.NIDORANMALE, PixelmonSpecies.NIDORINO, PixelmonSpecies.NIDOKING)) {
            return CollectionHelper.getRandomElement(NIDORAN_SPECIES).getValueUnsafe();
        }
        if (parentForEggLine.isPokemonOptional(PixelmonSpecies.ILLUMISE, PixelmonSpecies.VOLBEAT)) {
            return CollectionHelper.getRandomElement(BAT_SPECIES).getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.sea_incense, PixelmonSpecies.AZURILL, PixelmonSpecies.MARILL, PixelmonSpecies.AZUMARILL)) {
            return PixelmonSpecies.MARILL.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.lax_incense, PixelmonSpecies.WYNAUT, PixelmonSpecies.WOBBUFFET)) {
            return PixelmonSpecies.WOBBUFFET.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.rose_incense, PixelmonSpecies.BUDEW, PixelmonSpecies.ROSELIA, PixelmonSpecies.ROSERADE)) {
            return PixelmonSpecies.ROSELIA.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.pure_incense, PixelmonSpecies.CHINGLING, PixelmonSpecies.CHIMECHO)) {
            return PixelmonSpecies.CHIMECHO.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.rock_incense, PixelmonSpecies.BONSLY, PixelmonSpecies.SUDOWOODO)) {
            return PixelmonSpecies.SUDOWOODO.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.odd_incense, PixelmonSpecies.MIMEJR, PixelmonSpecies.MRMIME)) {
            return PixelmonSpecies.MRMIME.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.odd_incense, PixelmonSpecies.MIMEJR, PixelmonSpecies.MRRIME)) {
            return PixelmonSpecies.MRMIME.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.luck_incense, PixelmonSpecies.HAPPINY, PixelmonSpecies.CHANSEY, PixelmonSpecies.BLISSEY)) {
            return PixelmonSpecies.CHANSEY.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.wave_incense, PixelmonSpecies.MANTYKE, PixelmonSpecies.MANTINE)) {
            return PixelmonSpecies.MANTINE.getValueUnsafe();
        }
        if (this.checkIncense(itemFromParent, itemFromOtherParent, parentForEggLine, PixelmonItems.full_incense, PixelmonSpecies.MUNCHLAX, PixelmonSpecies.SNORLAX)) {
            return PixelmonSpecies.SNORLAX.getValueUnsafe();
        }
        return parentForEggLine.getForm().getBaseEvolution();
    }

    @Override
    public IVStore getIVsForEgg(Pokemon parentOne, Pokemon parentTwo) {
        IVStore newIVs = IVStore.createRandomNewIVs();
        int numberToInherit = 3;
        HeldItem heldItem1 = parentOne.getHeldItemAsItemHeld();
        HeldItem heldItem2 = parentTwo.getHeldItemAsItemHeld();
        if (heldItem1 == PixelmonItems.destiny_knot || heldItem2 == PixelmonItems.destiny_knot) {
            numberToInherit = 5;
        }
        Map<BattleStatsType, List<Integer>> stats = this.getInheritStats(numberToInherit, parentOne, parentTwo);
        for (Map.Entry<BattleStatsType, List<Integer>> entry : stats.entrySet()) {
            newIVs.setStat(entry.getKey(), (Integer)RandomHelper.getRandomElementFromCollection((Collection)entry.getValue()));
        }
        return newIVs;
    }

    private Map<BattleStatsType, List<Integer>> getInheritStats(int numberToInherit, Pokemon ... pokemons) {
        int i;
        HashMap inherit = Maps.newHashMap();
        for (i = 0; i < pokemons.length; ++i) {
            HeldItem nextItem;
            Pokemon pokemon = pokemons[i];
            HeldItem heldItem = pokemon.getHeldItemAsItemHeld();
            if (heldItem == PixelmonItems.power_weight) {
                inherit.computeIfAbsent(BattleStatsType.HP, ___ -> Lists.newArrayList()).add(pokemon.getIVs().getStat(BattleStatsType.HP));
                --numberToInherit;
            } else if (heldItem == PixelmonItems.power_bracer) {
                inherit.computeIfAbsent(BattleStatsType.ATTACK, ___ -> Lists.newArrayList()).add(pokemon.getIVs().getStat(BattleStatsType.ATTACK));
                --numberToInherit;
            } else if (heldItem == PixelmonItems.power_belt) {
                inherit.computeIfAbsent(BattleStatsType.DEFENSE, ___ -> Lists.newArrayList()).add(pokemon.getIVs().getStat(BattleStatsType.DEFENSE));
                --numberToInherit;
            } else if (heldItem == PixelmonItems.power_lens) {
                inherit.computeIfAbsent(BattleStatsType.SPECIAL_ATTACK, ___ -> Lists.newArrayList()).add(pokemon.getIVs().getStat(BattleStatsType.SPECIAL_ATTACK));
                --numberToInherit;
            } else if (heldItem == PixelmonItems.power_band) {
                inherit.computeIfAbsent(BattleStatsType.SPECIAL_DEFENSE, ___ -> Lists.newArrayList()).add(pokemon.getIVs().getStat(BattleStatsType.SPECIAL_DEFENSE));
                --numberToInherit;
            } else if (heldItem == PixelmonItems.power_anklet) {
                inherit.computeIfAbsent(BattleStatsType.SPEED, ___ -> Lists.newArrayList()).add(pokemon.getIVs().getStat(BattleStatsType.SPEED));
                --numberToInherit;
            }
            if (i + 1 == pokemons.length || (nextItem = pokemons[i + 1].getHeldItemAsItemHeld()) == PixelmonItems.no_item || heldItem != nextItem) continue;
            if (RandomHelper.getRandomChance()) break;
            inherit.clear();
        }
        for (i = 0; i < numberToInherit; ++i) {
            BattleStatsType type = RandomHelper.getRandomElementExcluding(BattleStatsType.EV_IV_STATS, inherit.keySet().toArray(new BattleStatsType[0]));
            inherit.computeIfAbsent(type, ___ -> Lists.newArrayList()).add(RandomHelper.getRandom().nextBoolean() ? pokemons[0].getIVs().getStat(type) : pokemons[1].getIVs().getStat(type));
        }
        return inherit;
    }

    @Override
    public Nature getNatureForEgg(Pokemon parentOne, Pokemon parentTwo) {
        boolean isEverstone2;
        boolean isEverstone1 = parentOne.getHeldItemAsItemHeld() == PixelmonItems.ever_stone;
        boolean bl = isEverstone2 = parentTwo.getHeldItemAsItemHeld() == PixelmonItems.ever_stone;
        if (isEverstone1 && isEverstone2) {
            return RandomHelper.getRandomChance() ? parentOne.getBaseNature() : parentTwo.getBaseNature();
        }
        if (isEverstone1) {
            return parentOne.getBaseNature();
        }
        if (isEverstone2) {
            return parentTwo.getBaseNature();
        }
        return Nature.getRandomNature();
    }

    @Override
    public PokeBall getPokeBall(Pokemon parentOne, Pokemon parentTwo) {
        Pokemon other;
        Pokemon inheriting;
        if (parentOne.getSpecies() == parentTwo.getSpecies()) {
            inheriting = RandomHelper.getRandomChance(50) ? parentOne : parentTwo;
        } else if (parentOne.isPokemonOptional(PixelmonSpecies.DITTO)) {
            inheriting = parentTwo;
        } else if (parentTwo.isPokemonOptional(PixelmonSpecies.DITTO)) {
            inheriting = parentOne;
        } else {
            inheriting = this.findMother(parentOne, parentTwo);
            if (inheriting == null) {
                inheriting = RandomHelper.getRandomChance(50) ? parentOne : parentTwo;
            }
        }
        Pokemon pokemon = other = inheriting == parentOne ? parentTwo : parentOne;
        if (!inheriting.getBall().is(PokeBallRegistry.MASTER_BALL, PokeBallRegistry.CHERISH_BALL)) {
            return inheriting.getBall();
        }
        if (!other.getBall().is(PokeBallRegistry.MASTER_BALL, PokeBallRegistry.CHERISH_BALL)) {
            return other.getBall();
        }
        return PokeBallRegistry.POKE_BALL.getValueUnsafe();
    }

    @Override
    public EnumGrowth getEggGrowth(Pokemon parentOne, Pokemon parentTwo) {
        double averageOrdinal = (float)(parentOne.getGrowth().scaleOrdinal + parentTwo.getGrowth().scaleOrdinal) / 2.0f;
        int ordinal = (int)averageOrdinal;
        if ((double)ordinal != averageOrdinal) {
            ordinal = (int)(RandomHelper.getRandomChance() ? Math.floor(averageOrdinal) : Math.ceil(averageOrdinal));
        }
        ordinal = Mth.m_14045_((int)ordinal, (int)1, (int)7);
        return EnumGrowth.getGrowthFromScaleOrdinal(RandomHelper.getRandomNumberBetween(ordinal - 1, ordinal + 1));
    }

    @Override
    public Ability getEggAbility(Stats form, Pokemon parentOne, Pokemon parentTwo) {
        Ability otherNormalAbility;
        Abilities abilities = form.getAbilities();
        Pair<Pokemon, Integer> parentAndPercent = this.calculateParentAndPercent(form, parentOne, parentTwo);
        if (parentAndPercent == null) {
            return form.getAbilities().getRandomAbility();
        }
        Pokemon parent = (Pokemon)parentAndPercent.getFirst();
        int inheritanceChance = (Integer)parentAndPercent.getSecond();
        boolean passingDownHA = parent.hasHiddenAbility();
        if (!PixelmonConfigProxy.getBreeding().isAllowCrossRegionHiddenAbilityInheritance() && passingDownHA) {
            String parentRegionalTag = parent.getForm().getRegionalTag();
            if (parentRegionalTag != null) {
                List<Stats> childFormsMatchingRegion = form.getParentSpecies().getForms(parentRegionalTag);
                if (!childFormsMatchingRegion.isEmpty() && !form.hasTag(parentRegionalTag)) {
                    passingDownHA = false;
                }
            } else if (form.isRegional()) {
                passingDownHA = false;
            }
        }
        if (RandomHelper.getRandomChance(inheritanceChance)) {
            if (passingDownHA) {
                return abilities.getRandomHiddenAbility();
            }
            int abilitySlot = parent.getForm().getAbilities().getAbilitySlot(parent.getAbility());
            if (abilitySlot == -1 || abilities.getAbilities().length <= abilitySlot) {
                return abilities.getRandomAbility();
            }
            return abilities.getAbilities()[abilitySlot];
        }
        if (passingDownHA) {
            return abilities.getRandomAbility();
        }
        int abilitySlot = parent.getForm().getAbilities().getAbilitySlot(parent.getAbility());
        if (abilitySlot == -1) {
            return abilities.getRandomAbility();
        }
        Ability[] toBeExcluded = new Ability[2];
        if (abilities.getAbilities().length > abilitySlot) {
            toBeExcluded[0] = abilities.getAbilities()[abilitySlot];
        }
        if (abilities.getHiddenAbilities().length > 1) {
            toBeExcluded[1] = abilities.getHiddenAbilities()[0];
        }
        if ((otherNormalAbility = parent.getForm().getAbilities().getRandomAbilityExcluding(toBeExcluded)) == null) {
            return abilities.getAbilities()[abilitySlot];
        }
        return otherNormalAbility;
    }

    @Override
    public Pair<Integer, Boolean> getEggAbilitySlot(Stats form, Pokemon parentOne, Pokemon parentTwo) {
        Abilities abilities = form.getAbilities();
        Pair<Pokemon, Integer> parentAndPercent = this.calculateParentAndPercent(form, parentOne, parentTwo);
        if (parentAndPercent == null) {
            return Pair.of((Object)-1, (Object)false);
        }
        Pokemon parent = (Pokemon)parentAndPercent.getFirst();
        boolean inheriting = RandomHelper.getRandomChance((Integer)parentAndPercent.getSecond());
        boolean passingDownHA = parent.hasHiddenAbility();
        int slot = parent.getAbilitySlot();
        if (!PixelmonConfigProxy.getBreeding().isAllowCrossRegionHiddenAbilityInheritance() && passingDownHA) {
            String parentRegionalTag = parent.getForm().getRegionalTag();
            if (parentRegionalTag != null) {
                List<Stats> childFormsMatchingRegion = form.getParentSpecies().getForms(parentRegionalTag);
                if (!childFormsMatchingRegion.isEmpty() && !form.hasTag(parentRegionalTag)) {
                    inheriting = false;
                }
            } else if (form.isRegional()) {
                inheriting = false;
            }
        }
        if (inheriting) {
            return Pair.of((Object)slot, (Object)passingDownHA);
        }
        int numAbilities = abilities.getAbilities().length;
        if (numAbilities == 1) {
            return Pair.of((Object)0, (Object)false);
        }
        int newSlot = -1;
        if (passingDownHA) {
            newSlot = RandomHelper.getRandomNumberBetween(0, numAbilities - 1);
        } else {
            newSlot = RandomHelper.getRandomNumberBetween(0, numAbilities - 2);
            if (newSlot >= slot) {
                ++newSlot;
            }
        }
        return Pair.of((Object)newSlot, (Object)false);
    }

    private Pair<Pokemon, Integer> calculateParentAndPercent(Stats form, Pokemon parentOne, Pokemon parentTwo) {
        Pokemon inheritParent;
        boolean is1Ditto = parentOne.isPokemonOptional(PixelmonSpecies.DITTO);
        boolean is2Ditto = parentTwo.isPokemonOptional(PixelmonSpecies.DITTO);
        int percent = 80;
        if (is1Ditto || is2Ditto) {
            if (is1Ditto && is2Ditto) {
                return null;
            }
            Pokemon pokemon = inheritParent = is1Ditto ? parentTwo : parentOne;
            if (inheritParent.getGender() == Gender.MALE || inheritParent.hasHiddenAbility()) {
                percent = 60;
            }
        } else {
            inheritParent = parentOne.getGender() == Gender.FEMALE ? parentOne : parentTwo;
        }
        return Pair.of((Object)inheritParent, (Object)percent);
    }

    @Override
    public boolean shouldEggBeShiny(Pokemon parentOne, Pokemon parentTwo) {
        float differentTrainerFactor = 1.0f;
        if (!Objects.equals(parentOne.getOriginalTrainerUUID(), parentTwo.getOriginalTrainerUUID())) {
            differentTrainerFactor = 6.0f;
        }
        if (StorageProxy.getPartyNow(parentOne.getOwnerPlayerUUID()).getShinyCharm().isActive()) {
            differentTrainerFactor *= PixelmonConfigProxy.getSpawning().getShinyCharmMultiplier();
        }
        return PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)Level.f_46428_) != 0.0f && RandomHelper.getRandom().nextFloat() < differentTrainerFactor / PixelmonConfigProxy.getSpawning().getShinyRate((ResourceKey<Level>)Level.f_46428_);
    }

    @Override
    public Moveset getEggMoveset(Stats egg, Pokemon parentOne, Pokemon parentTwo) {
        Set<ImmutableAttack> possibleEggMoves = egg.getMoves().getEggMoves();
        List<ImmutableAttack> lvl1Moves = egg.getMoves().getMovesAtLevel(1);
        List<ImmutableAttack> levelupMoves = this.getPokemonLevelupMoves(egg, parentOne, parentTwo);
        Pokemon father = this.findFather(parentOne, parentTwo);
        List<ImmutableAttack> fathersTMHMTutorMoves = this.getFathersTMHMTutorMoves(egg, father);
        List<ImmutableAttack> fathersEggMoves = this.getEggMoves(egg, father, possibleEggMoves);
        List<ImmutableAttack> mothersEggMoves = this.getEggMoves(egg, this.findMother(parentOne, parentTwo), possibleEggMoves);
        ArrayList masterAttackList = Lists.newArrayList();
        if (this.canLearnVoltTackle(egg.getParentSpecies(), parentOne, parentTwo)) {
            AttackRegistry.VOLT_TACKLE.ifInitialized(voltTackle -> {
                masterAttackList.add(voltTackle);
                possibleEggMoves.add((ImmutableAttack)voltTackle);
            });
        }
        Predicate<ImmutableAttack> doesNotContain = attack -> !masterAttackList.contains(attack);
        mothersEggMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        fathersEggMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        fathersTMHMTutorMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        levelupMoves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        lvl1Moves.stream().filter(doesNotContain).forEach(masterAttackList::add);
        return this.getFirstFourMoves(masterAttackList);
    }

    @Override
    public List<ImmutableAttack> getPokemonLevelupMoves(Stats egg, Pokemon parentOne, Pokemon parentTwo) {
        List<ImmutableAttack> allBabyAttacks = egg.getMoves().getMovesUpToLevel(100);
        List<ImmutableAttack> pixelmon1Attacks = parentOne.getMoveset().asImmutable();
        List<ImmutableAttack> pixelmon2Attacks = parentTwo.getMoveset().asImmutable();
        allBabyAttacks.removeIf(attack -> !pixelmon1Attacks.contains(attack) || !pixelmon2Attacks.contains(attack));
        return allBabyAttacks;
    }

    @Override
    public Moveset getFirstFourMoves(List<ImmutableAttack> masterAttackList) {
        Moveset moveset = new Moveset();
        moveset.set(0, new Attack(AttackRegistry.TACKLE));
        moveset.set(1, null);
        moveset.set(2, null);
        moveset.set(3, null);
        if (!masterAttackList.isEmpty()) {
            for (int i = 0; i < Math.min(4, masterAttackList.size()); ++i) {
                if (masterAttackList.get(i) == null) continue;
                moveset.set(i, masterAttackList.get(i).ofMutable());
            }
        }
        return moveset;
    }

    @Override
    public List<ImmutableAttack> getEggMoves(Stats egg, Pokemon parent, Set<ImmutableAttack> allEggMoves) {
        ArrayList eggMoves = Lists.newArrayList();
        if (parent != null) {
            List<ImmutableAttack> allParentsMoves = parent.getMoveset().asImmutable();
            eggMoves.addAll(allParentsMoves.stream().filter(allEggMoves::contains).collect(Collectors.toList()));
        }
        return eggMoves;
    }

    @Override
    public boolean canLearnVoltTackle(Species species, Pokemon parentOne, Pokemon parentTwo) {
        if (!species.is(PixelmonSpecies.PICHU)) {
            return false;
        }
        return parentOne.getHeldItemAsItemHeld() == PixelmonItems.light_ball || parentTwo.getHeldItemAsItemHeld() == PixelmonItems.light_ball;
    }

    @Override
    public List<ImmutableAttack> getFathersTMHMTutorMoves(Stats egg, Pokemon father) {
        ArrayList<ImmutableAttack> tmhmTutorMoves = new ArrayList<ImmutableAttack>();
        if (father != null) {
            Set<ImmutableAttack> allBabyTMHMTutorMoves = egg.getMoves().getTMMoves();
            allBabyTMHMTutorMoves.addAll(egg.getMoves().getTutorMoves());
            allBabyTMHMTutorMoves.addAll(egg.getMoves().getTransferMoves());
            List<ImmutableAttack> allFathersMoves = father.getMoveset().asImmutable();
            tmhmTutorMoves.addAll(allFathersMoves.stream().filter(allBabyTMHMTutorMoves::contains).collect(Collectors.toList()));
        }
        return tmhmTutorMoves;
    }

    @Override
    public Pokemon findFather(Pokemon parentOne, Pokemon parentTwo) {
        boolean is1Ditto = parentOne.isPokemonOptional(PixelmonSpecies.DITTO);
        boolean is2Ditto = parentTwo.isPokemonOptional(PixelmonSpecies.DITTO);
        if (is1Ditto || is2Ditto) {
            if (is1Ditto && parentTwo.getGender() != Gender.FEMALE) {
                return parentTwo;
            }
            if (is2Ditto && parentOne.getGender() != Gender.FEMALE) {
                return parentOne;
            }
            return null;
        }
        return parentOne.getGender() == Gender.MALE ? parentOne : parentTwo;
    }

    @Override
    public Pokemon findMother(Pokemon parentOne, Pokemon parentTwo) {
        boolean is1Ditto = parentOne.isPokemonOptional(PixelmonSpecies.DITTO);
        boolean is2Ditto = parentTwo.isPokemonOptional(PixelmonSpecies.DITTO);
        if (is1Ditto || is2Ditto) {
            if (is1Ditto && parentTwo.getGender() != Gender.MALE) {
                return parentTwo;
            }
            if (is2Ditto && parentOne.getGender() != Gender.MALE) {
                return parentOne;
            }
            return null;
        }
        return parentOne.getGender() == Gender.FEMALE ? parentOne : parentTwo;
    }

    @Override
    @SafeVarargs
    public final boolean checkIncense(Item itemTypeParent, Item itemTypeOther, Pokemon parentForEggLine, Item neededItem, RegistryValue<Species> baby, RegistryValue<Species> ... parents) {
        if (!parentForEggLine.isPokemonOptional(parents)) {
            return false;
        }
        if (itemTypeParent != neededItem && itemTypeOther != neededItem) {
            return true;
        }
        return PixelmonConfigProxy.getSpawning().isGenerationEnabled(parentForEggLine.getSpecies().getGeneration()) && !PixelmonConfigProxy.getSpawning().isGenerationEnabled(baby.getValueUnsafe().getGeneration());
    }
}

