/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.effects;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PassivePoisonEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.effects.PassiveEffectTicker;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;

public class WalkingPassiveEffectTicker
implements PassiveEffectTicker {
    @Override
    public void tick(ServerPlayer player, PlayerPartyStorage party) {
        ++party.transientData.passivePoisonTick;
        if (party.transientData.passivePoisonTick >= 20 && PixelmonConfigProxy.getGeneral().getOutsideEffects().isUseOutsideEffects() && BattleRegistry.getBattle((Player)player) == null) {
            this.doWalkPoison(player, party);
            party.transientData.passivePoisonTick = 0;
        }
    }

    public int doWalkPoison(ServerPlayer player, PlayerPartyStorage party) {
        int posX = player.m_20183_().m_123341_();
        int posZ = player.m_20183_().m_123343_();
        TransientData td = party.transientData;
        int changeX = td.lastPassivePoisonHealX - posX;
        int changeZ = td.lastPassivePoisonHealZ - posZ;
        td.lastPassivePoisonHealX = posX;
        td.lastPassivePoisonHealZ = posZ;
        if (changeX == -posX && changeZ == -posZ) {
            return 0;
        }
        int steps = Math.abs(changeX) + Math.abs(changeZ);
        if (steps > 20) {
            return 0;
        }
        if (steps == 0) {
            return 0;
        }
        Pokemon pokemon = party.getAll()[RandomHelper.getRandom().nextInt(6)];
        PassivePoisonEvent.Pre pre = new PassivePoisonEvent.Pre(player, pokemon);
        Pixelmon.EVENT_BUS.post((Event)pre);
        if (pre.isCanceled()) {
            return 0;
        }
        if (pokemon != null) {
            DelegateLink link = new DelegateLink(pokemon);
            if (((PokemonLink)link).getPrimaryStatus().type != StatusType.Poison && ((PokemonLink)link).getPrimaryStatus().type != StatusType.PoisonBadly) {
                return 0;
            }
            if (pokemon.getAbility().getName().equalsIgnoreCase("Immunity")) {
                return 0;
            }
            if (pokemon.getHealth() <= 1) {
                ((PokemonLink)link).removeStatuses(StatusType.Poison);
                ((PokemonLink)link).removeStatuses(StatusType.PoisonBadly);
                ((PokemonLink)link).sendMessage("pixelmon.status.poisoncure", ((PokemonLink)link).getNickname());
            }
            int dmg = RandomHelper.getRandomNumberBetween(0, PixelmonConfigProxy.getGeneral().getOutsideEffects().getPoisonMaxDamage());
            if (((PokemonLink)link).getPrimaryStatus().type == StatusType.PoisonBadly) {
                dmg = (int)((double)dmg + (double)dmg * 0.5);
            }
            if (dmg >= pokemon.getHealth()) {
                ((PokemonLink)link).removeStatuses(StatusType.Poison);
                ((PokemonLink)link).removeStatuses(StatusType.PoisonBadly);
                ((PokemonLink)link).sendMessage("pixelmon.status.poisoncure", ((PokemonLink)link).getNickname());
                pokemon.setHealth(1);
            }
            pokemon.setHealth(pokemon.getHealth() - dmg);
            Pixelmon.EVENT_BUS.post((Event)new PassivePoisonEvent.Post(player, pokemon));
        }
        return steps;
    }
}

