/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.drops;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.pokemon.drops.ItemWithChance;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHoldsItemsEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;

public class PokemonDropInformation {
    private final PokemonSpecification pokemonSpec;
    private final List<ItemWithChance> drops;

    public PokemonDropInformation(JsonObject jsonObject) {
        this.pokemonSpec = PokemonSpecificationProxy.create(jsonObject.get("pokemon").getAsString()).get();
        this.drops = Lists.newArrayList();
        this.parseLegacyJson(jsonObject);
        if (jsonObject.has("items")) {
            this.drops.addAll(ItemWithChance.parse(jsonObject.getAsJsonArray("items")));
        }
    }

    public PokemonDropInformation(PokemonSpecification pokemonSpec, ItemWithChance ... items) {
        this.pokemonSpec = pokemonSpec;
        this.drops = Lists.newArrayList((Object[])items);
    }

    private void parseLegacyJson(JsonObject jsonObject) {
        this.parseLegacyFormat(jsonObject, 1.0, "maindropdata", "maindropmin", "maindropmax");
        this.parseLegacyFormat(jsonObject, 1.0, "optdrop1data", "optdrop1min", "optdrop1max");
        this.parseLegacyFormat(jsonObject, 1.0, "optdrop2data", "optdrop2min", "optdrop2max");
        this.parseLegacyFormat(jsonObject, 0.1, "raredropdata", "raredropmin", "raredropmax");
    }

    private void parseLegacyFormat(JsonObject jsonObject, double chance, String itemKey, String minKey, String maxKey) {
        if (!jsonObject.has(itemKey)) {
            return;
        }
        ItemStack mainDrop = DropItemRegistry.parseItem(jsonObject.get(itemKey).getAsString());
        int minAmount = 1;
        int maxAmount = 1;
        if (jsonObject.has(minKey)) {
            minAmount = jsonObject.get(minKey).getAsInt();
        }
        if (jsonObject.has(maxKey)) {
            maxAmount = jsonObject.get(maxKey).getAsInt();
        }
        this.drops.add(new ItemWithChance(mainDrop, minAmount, maxAmount, chance));
    }

    public PokemonSpecification getPokemonSpec() {
        return this.pokemonSpec;
    }

    public List<ItemWithChance> getDrops() {
        return this.drops;
    }

    public void addDrop(ItemWithChance item) {
        this.drops.add(item);
    }

    public List<ItemStack> getDrops(AbstractHoldsItemsEntity pixelmon) {
        if (!this.pokemonSpec.matches((Object)pixelmon)) {
            return ImmutableList.of();
        }
        ArrayList drops = Lists.newArrayList();
        for (ItemWithChance drop : this.drops) {
            drops.add(drop.getItem());
        }
        drops.removeIf(itemStack -> Objects.equals(itemStack, ItemStack.f_41583_));
        return drops;
    }
}

