/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.drops;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemWithChance {
    private final ItemStack itemStack;
    private final int min;
    private final int max;
    private final double chance;

    public ItemWithChance(ItemStack itemStack, int amount) {
        this(itemStack, amount, amount);
    }

    public ItemWithChance(ItemStack itemStack, int amount, double chance) {
        this(itemStack, amount, amount, chance);
    }

    public ItemWithChance(ItemStack itemStack, int min, int max) {
        this(itemStack, min, max, 1.0);
    }

    public ItemWithChance(ItemStack itemStack, int min, int max, double chance) {
        this.itemStack = itemStack;
        this.min = min;
        this.max = max;
        this.chance = chance;
    }

    public ItemStack getItemStack() {
        return this.itemStack.m_41777_();
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getChance() {
        return this.chance;
    }

    public ItemStack getItem() {
        if (!this.shouldGiveItem()) {
            return ItemStack.f_41583_;
        }
        int amount = this.getRandomAmount();
        ItemStack clone = this.itemStack.m_41777_();
        clone.m_41764_(amount);
        return clone;
    }

    private boolean shouldGiveItem() {
        if (this.chance == 0.0) {
            return false;
        }
        if (this.chance == 1.0) {
            return true;
        }
        return RandomHelper.getRandomChance(this.chance);
    }

    private int getRandomAmount() {
        if (this.min == this.max) {
            return this.min;
        }
        return RandomHelper.getRandomNumberBetween(this.min, this.max);
    }

    public static List<ItemWithChance> parse(JsonArray array) {
        ArrayList items = Lists.newArrayList();
        for (JsonElement jsonElement : array) {
            items.add(ItemWithChance.parse(jsonElement.getAsJsonObject()));
        }
        return items;
    }

    public static ItemWithChance parse(JsonObject object) {
        ItemStack itemStack;
        String itemText;
        JsonElement item = object.get("item");
        String string = itemText = item.isJsonPrimitive() ? item.getAsString() : "";
        if (itemText.isEmpty()) {
            try {
                itemStack = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)item.getAsJsonObject().toString()));
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failed to read item NBT in boss drop: " + itemText);
                itemStack = ItemStack.f_41583_;
            }
        } else if (itemText.contains("{")) {
            try {
                itemStack = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)itemText));
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failed to read item NBT in boss drop: " + itemText);
                itemStack = ItemStack.f_41583_;
            }
        } else {
            try {
                itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(itemText)));
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Failed to read item in boss drop: " + itemText);
                itemStack = ItemStack.f_41583_;
            }
        }
        int min = 1;
        int max = 1;
        double chance = 1.0;
        if (object.has("min")) {
            min = object.get("min").getAsInt();
        }
        if (object.has("max")) {
            max = object.get("max").getAsInt();
        }
        if (object.has("chance")) {
            chance = object.get("chance").getAsDouble();
        }
        return new ItemWithChance(itemStack, min, max, chance);
    }
}

