/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.catching;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureHealth;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureMethod;
import com.pixelmonmod.pixelmon.api.pokemon.catching.CaptureValues;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;

public class CaptureMethods {
    public static final CaptureMethod ALWAYS_CAPTURE = new CaptureMethod(){

        @Override
        public CaptureValues calculateCapture(CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, @Nullable RaidData raid, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            CaptureValues values = new CaptureValues(255, 1.0);
            values.setCaught(4);
            return values;
        }

        @Override
        public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            return values;
        }
    };
    public static final CaptureMethod FIFTY_FIFTY = new CaptureMethod(){

        @Override
        public CaptureValues calculateCapture(CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, @Nullable RaidData raid, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            CaptureValues values = new CaptureValues(255, 1.0);
            if (RandomHelper.getRandom().nextBoolean()) {
                values.setCaught(4);
            } else {
                values.setShakes(RandomHelper.getRandom().nextInt(4));
            }
            return values;
        }

        @Override
        public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            return values;
        }
    };
    public static final CaptureMethod GEN_1 = new CaptureMethod(){

        @Override
        public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            if (pokeBall.isGuaranteedCatch()) {
                values.setCaught(3);
                return values;
            }
            if (values.getCatchRate() > 0) {
                this.captureCalculation(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
            }
            return values;
        }

        @Override
        public double statusEffectCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            StatusType currentStatus;
            PixelmonWrapper pw = health.getWrapper();
            StatusType statusType = currentStatus = pw == null ? pokemon.getStatus().type : pw.getPrimaryStatus().type;
            if (MAJOR_STATUSES.contains(currentStatus)) {
                return 25.0;
            }
            if (MINOR_STATUSES.contains(currentStatus)) {
                return 12.0;
            }
            return 0.0;
        }

        @Override
        public void captureCalculation(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            int ballRate = this.approximateGen1BallRateA(values);
            double bonusStatus = this.statusEffectCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
            double n = RandomHelper.getRandom().nextInt(ballRate + 1);
            if (bonusStatus > 0.0 && n < bonusStatus) {
                values.setCaught(3);
                return;
            }
            if (n - bonusStatus > (double)values.getCatchRate()) {
                return;
            }
            double hpMax = health.getMaxHP();
            double hpCurrent = health.getCurrentHP();
            double m = RandomHelper.getRandom().nextInt(256);
            double ball = this.approximateGen1BallRateB(values);
            double f = Mth.m_14008_((double)Math.floor(hpMax * 1020.0 / (hpCurrent * ball)), (double)1.0, (double)255.0);
            if (f >= m) {
                values.setCaught(3);
                return;
            }
            values.setVariable("A", ballRate);
            values.setVariable("B", bonusStatus);
            values.setVariable("F", f);
            this.shakeCountCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
        }

        @Override
        public void shakeCountCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
            double ballRate = values.getVariable("A");
            double bonusStatus = Math.ceil(values.getVariable("B") * 0.4);
            double f = values.getVariable("F");
            double d = Math.floor((double)values.getCatchRate() * 100.0 / ballRate);
            if (d >= 256.0) {
                values.setShakes(3);
                return;
            }
            double x = Math.floor(d * f / 255.0) + bonusStatus;
            if (x < 10.0) {
                values.setShakes(0);
            } else if (x < 30.0) {
                values.setShakes(1);
            } else if (x < 70.0) {
                values.setShakes(2);
            } else {
                values.setShakes(3);
            }
        }

        private int approximateGen1BallRateA(CaptureValues values) {
            return (int)Math.max(50.0, 250.0 - (values.getBallBonus() - 1.0) * 100.0);
        }

        private int approximateGen1BallRateB(CaptureValues values) {
            return (int)Math.max(4.0, 12.0 - (values.getBallBonus() - 1.0) * 8.0);
        }
    };
    private static final Map<Integer, Integer> AB_MAP = new Int2IntOpenHashMap();
    public static final CaptureMethod GEN_2;
    public static final CaptureMethod GEN_3_4;
    public static final CaptureMethod GEN_5;
    public static final CaptureMethod GEN_6_7;
    public static final CaptureMethod GEN_8;

    static {
        AB_MAP.put(0, 63);
        AB_MAP.put(1, 63);
        AB_MAP.put(2, 75);
        AB_MAP.put(3, 84);
        AB_MAP.put(4, 90);
        AB_MAP.put(5, 95);
        AB_MAP.put(6, 103);
        AB_MAP.put(7, 103);
        AB_MAP.put(8, 113);
        AB_MAP.put(9, 113);
        AB_MAP.put(10, 113);
        AB_MAP.put(11, 126);
        AB_MAP.put(12, 126);
        AB_MAP.put(13, 126);
        AB_MAP.put(14, 126);
        AB_MAP.put(15, 126);
        AB_MAP.put(16, 134);
        AB_MAP.put(17, 134);
        AB_MAP.put(18, 134);
        AB_MAP.put(19, 134);
        AB_MAP.put(20, 134);
        AB_MAP.put(21, 149);
        AB_MAP.put(22, 149);
        AB_MAP.put(23, 149);
        AB_MAP.put(24, 149);
        AB_MAP.put(25, 149);
        AB_MAP.put(26, 149);
        AB_MAP.put(27, 149);
        AB_MAP.put(28, 149);
        AB_MAP.put(29, 149);
        AB_MAP.put(30, 149);
        AB_MAP.put(31, 160);
        AB_MAP.put(32, 160);
        AB_MAP.put(33, 160);
        AB_MAP.put(34, 160);
        AB_MAP.put(35, 160);
        AB_MAP.put(36, 160);
        AB_MAP.put(37, 160);
        AB_MAP.put(38, 160);
        AB_MAP.put(39, 160);
        AB_MAP.put(40, 160);
        AB_MAP.put(41, 169);
        AB_MAP.put(42, 169);
        AB_MAP.put(43, 169);
        AB_MAP.put(44, 169);
        AB_MAP.put(45, 169);
        AB_MAP.put(46, 169);
        AB_MAP.put(47, 169);
        AB_MAP.put(48, 169);
        AB_MAP.put(49, 169);
        AB_MAP.put(50, 169);
        AB_MAP.put(51, 177);
        AB_MAP.put(52, 177);
        AB_MAP.put(53, 177);
        AB_MAP.put(54, 177);
        AB_MAP.put(55, 177);
        AB_MAP.put(56, 177);
        AB_MAP.put(57, 177);
        AB_MAP.put(58, 177);
        AB_MAP.put(59, 177);
        AB_MAP.put(60, 177);
        AB_MAP.put(61, 191);
        AB_MAP.put(62, 191);
        AB_MAP.put(63, 191);
        AB_MAP.put(64, 191);
        AB_MAP.put(65, 191);
        AB_MAP.put(66, 191);
        AB_MAP.put(67, 191);
        AB_MAP.put(68, 191);
        AB_MAP.put(69, 191);
        AB_MAP.put(70, 191);
        AB_MAP.put(71, 191);
        AB_MAP.put(72, 191);
        AB_MAP.put(73, 191);
        AB_MAP.put(74, 191);
        AB_MAP.put(75, 191);
        AB_MAP.put(76, 191);
        AB_MAP.put(77, 191);
        AB_MAP.put(78, 191);
        AB_MAP.put(79, 191);
        AB_MAP.put(80, 191);
        AB_MAP.put(81, 201);
        AB_MAP.put(82, 201);
        AB_MAP.put(83, 201);
        AB_MAP.put(84, 201);
        AB_MAP.put(85, 201);
        AB_MAP.put(86, 201);
        AB_MAP.put(87, 201);
        AB_MAP.put(88, 201);
        AB_MAP.put(89, 201);
        AB_MAP.put(90, 201);
        AB_MAP.put(91, 201);
        AB_MAP.put(92, 201);
        AB_MAP.put(93, 201);
        AB_MAP.put(94, 201);
        AB_MAP.put(95, 201);
        AB_MAP.put(96, 201);
        AB_MAP.put(97, 201);
        AB_MAP.put(98, 201);
        AB_MAP.put(99, 201);
        AB_MAP.put(100, 201);
        AB_MAP.put(101, 211);
        AB_MAP.put(102, 211);
        AB_MAP.put(103, 211);
        AB_MAP.put(104, 211);
        AB_MAP.put(105, 211);
        AB_MAP.put(106, 211);
        AB_MAP.put(107, 211);
        AB_MAP.put(108, 211);
        AB_MAP.put(109, 211);
        AB_MAP.put(110, 211);
        AB_MAP.put(111, 211);
        AB_MAP.put(112, 211);
        AB_MAP.put(113, 211);
        AB_MAP.put(114, 211);
        AB_MAP.put(115, 211);
        AB_MAP.put(116, 211);
        AB_MAP.put(117, 211);
        AB_MAP.put(118, 211);
        AB_MAP.put(119, 211);
        AB_MAP.put(120, 211);
        AB_MAP.put(121, 220);
        AB_MAP.put(122, 220);
        AB_MAP.put(123, 220);
        AB_MAP.put(124, 220);
        AB_MAP.put(125, 220);
        AB_MAP.put(126, 220);
        AB_MAP.put(127, 220);
        AB_MAP.put(128, 220);
        AB_MAP.put(129, 220);
        AB_MAP.put(130, 220);
        AB_MAP.put(131, 220);
        AB_MAP.put(132, 220);
        AB_MAP.put(133, 220);
        AB_MAP.put(134, 220);
        AB_MAP.put(135, 220);
        AB_MAP.put(136, 220);
        AB_MAP.put(137, 220);
        AB_MAP.put(138, 220);
        AB_MAP.put(139, 220);
        AB_MAP.put(140, 220);
        AB_MAP.put(141, 227);
        AB_MAP.put(142, 227);
        AB_MAP.put(143, 227);
        AB_MAP.put(144, 227);
        AB_MAP.put(145, 227);
        AB_MAP.put(146, 227);
        AB_MAP.put(147, 227);
        AB_MAP.put(148, 227);
        AB_MAP.put(149, 227);
        AB_MAP.put(150, 227);
        AB_MAP.put(151, 227);
        AB_MAP.put(152, 227);
        AB_MAP.put(153, 227);
        AB_MAP.put(154, 227);
        AB_MAP.put(155, 227);
        AB_MAP.put(156, 227);
        AB_MAP.put(157, 227);
        AB_MAP.put(158, 227);
        AB_MAP.put(159, 227);
        AB_MAP.put(160, 227);
        AB_MAP.put(161, 234);
        AB_MAP.put(162, 234);
        AB_MAP.put(163, 234);
        AB_MAP.put(164, 234);
        AB_MAP.put(165, 234);
        AB_MAP.put(166, 234);
        AB_MAP.put(167, 234);
        AB_MAP.put(168, 234);
        AB_MAP.put(169, 234);
        AB_MAP.put(170, 234);
        AB_MAP.put(171, 234);
        AB_MAP.put(172, 234);
        AB_MAP.put(173, 234);
        AB_MAP.put(174, 234);
        AB_MAP.put(175, 234);
        AB_MAP.put(176, 234);
        AB_MAP.put(177, 234);
        AB_MAP.put(178, 234);
        AB_MAP.put(179, 234);
        AB_MAP.put(180, 234);
        AB_MAP.put(181, 240);
        AB_MAP.put(182, 240);
        AB_MAP.put(183, 240);
        AB_MAP.put(184, 240);
        AB_MAP.put(185, 240);
        AB_MAP.put(186, 240);
        AB_MAP.put(187, 240);
        AB_MAP.put(188, 240);
        AB_MAP.put(189, 240);
        AB_MAP.put(190, 240);
        AB_MAP.put(191, 240);
        AB_MAP.put(192, 240);
        AB_MAP.put(193, 240);
        AB_MAP.put(194, 240);
        AB_MAP.put(195, 240);
        AB_MAP.put(196, 240);
        AB_MAP.put(197, 240);
        AB_MAP.put(198, 240);
        AB_MAP.put(199, 240);
        AB_MAP.put(200, 240);
        AB_MAP.put(201, 246);
        AB_MAP.put(202, 246);
        AB_MAP.put(203, 246);
        AB_MAP.put(204, 246);
        AB_MAP.put(205, 246);
        AB_MAP.put(206, 246);
        AB_MAP.put(207, 246);
        AB_MAP.put(208, 246);
        AB_MAP.put(209, 246);
        AB_MAP.put(210, 246);
        AB_MAP.put(211, 246);
        AB_MAP.put(212, 246);
        AB_MAP.put(213, 246);
        AB_MAP.put(214, 246);
        AB_MAP.put(215, 246);
        AB_MAP.put(216, 246);
        AB_MAP.put(217, 246);
        AB_MAP.put(218, 246);
        AB_MAP.put(219, 246);
        AB_MAP.put(220, 246);
        AB_MAP.put(221, 251);
        AB_MAP.put(222, 251);
        AB_MAP.put(223, 251);
        AB_MAP.put(224, 251);
        AB_MAP.put(225, 251);
        AB_MAP.put(226, 251);
        AB_MAP.put(227, 251);
        AB_MAP.put(228, 251);
        AB_MAP.put(229, 251);
        AB_MAP.put(230, 251);
        AB_MAP.put(231, 251);
        AB_MAP.put(232, 251);
        AB_MAP.put(233, 251);
        AB_MAP.put(234, 251);
        AB_MAP.put(235, 251);
        AB_MAP.put(236, 251);
        AB_MAP.put(237, 251);
        AB_MAP.put(238, 251);
        AB_MAP.put(239, 251);
        AB_MAP.put(240, 251);
        AB_MAP.put(241, 253);
        AB_MAP.put(242, 253);
        AB_MAP.put(243, 253);
        AB_MAP.put(244, 253);
        AB_MAP.put(245, 253);
        AB_MAP.put(246, 253);
        AB_MAP.put(247, 253);
        AB_MAP.put(248, 253);
        AB_MAP.put(249, 253);
        AB_MAP.put(250, 253);
        AB_MAP.put(251, 253);
        AB_MAP.put(252, 253);
        AB_MAP.put(253, 253);
        AB_MAP.put(254, 253);
        AB_MAP.put(255, 255);
        GEN_2 = new CaptureMethod(){

            @Override
            public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                if (pokeBall.isGuaranteedCatch()) {
                    values.setCaught(3);
                    return values;
                }
                if (values.getCatchRate() > 0) {
                    this.captureCalculation(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                }
                this.shakeCountCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                return values;
            }

            @Override
            public void captureCalculation(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                double hpMax = health.getMaxHP();
                double hpCurrent = health.getCurrentHP();
                PixelmonWrapper pw = health.getWrapper();
                if (pw != null) {
                    hpCurrent = pw.getHealth();
                }
                double rateModified = Mth.m_14008_((double)Math.floor((double)values.getCatchRate() * values.getBallBonus()), (double)1.0, (double)255.0);
                double bonusStatus = this.statusEffectCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                double hpMaxModified = 3.0 * hpMax;
                double hpCurrentModified = 2.0 * hpCurrent;
                if (hpMaxModified > 255.0) {
                    hpMaxModified /= 2.0;
                    hpMaxModified /= 2.0;
                    hpCurrentModified /= 2.0;
                    hpCurrentModified /= 2.0;
                }
                hpCurrentModified = Math.max(1.0, hpCurrentModified);
                double a = Math.min(255.0, Math.max(1.0, Math.floor((hpMaxModified - hpCurrentModified) * rateModified / hpMaxModified)) + bonusStatus);
                double b = AB_MAP.get((int)a).intValue();
                values.setVariable("A", a);
                values.setVariable("B", b);
            }

            @Override
            public double statusEffectCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                StatusType currentStatus;
                PixelmonWrapper pw = health.getWrapper();
                StatusType statusType = currentStatus = pw == null ? pokemon.getStatus().type : pw.getPrimaryStatus().type;
                if (MAJOR_STATUSES.contains(currentStatus)) {
                    return 10.0;
                }
                if (MINOR_STATUSES.contains(currentStatus)) {
                    return 5.0;
                }
                return 0.0;
            }

            @Override
            public void shakeCountCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                double a = values.getVariable("A");
                double b = values.getVariable("B");
                if ((double)RandomHelper.getRandom().nextInt(256) <= a) {
                    values.setCaught(3);
                    return;
                }
                if (values.getCatchRate() > 0 && b != 0.0) {
                    if (a < 255.0) {
                        for (int i = 0; i < 3; ++i) {
                            int roll = RandomHelper.getRandom().nextInt(256);
                            if (!((double)roll <= b)) continue;
                            values.addShake();
                        }
                    } else {
                        values.setShakes(3);
                    }
                }
                values.trySetCaught(3);
            }
        };
        GEN_3_4 = new CaptureMethod(){

            @Override
            public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                return GEN_5.tryCapture(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
            }

            @Override
            public double statusEffectCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                StatusType currentStatus;
                PixelmonWrapper pw = health.getWrapper();
                StatusType statusType = currentStatus = pw == null ? pokemon.getStatus().type : pw.getPrimaryStatus().type;
                if (MAJOR_STATUSES.contains(currentStatus)) {
                    return 2.0;
                }
                if (MINOR_STATUSES.contains(currentStatus)) {
                    return 1.5;
                }
                return 1.0;
            }
        };
        GEN_5 = new CaptureMethod(){

            @Override
            public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                if (pokeBall.isGuaranteedCatch()) {
                    values.setCaught(4);
                    return values;
                }
                if (values.getCatchRate() > 0) {
                    this.captureCalculation(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                    this.criticalCaptureCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                }
                this.shakeCountCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                return values;
            }
        };
        GEN_6_7 = new CaptureMethod(){

            @Override
            public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                return GEN_5.tryCapture(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
            }

            @Override
            public void captureCalculation(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                double hpMax = health.getMaxHP();
                double hpCurrent = health.getCurrentHP();
                PixelmonWrapper pw = health.getWrapper();
                if (pw != null) {
                    hpCurrent = pw.getHealth();
                }
                double bonusStatus = this.statusEffectCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                double a = (3.0 * hpMax - 2.0 * hpCurrent) * (double)values.getCatchRate() * values.getBallBonus() / (3.0 * hpMax) * bonusStatus;
                double b = 65536.0 / Math.pow(255.0 / a, 0.1875);
                values.setVariable("A", a);
                values.setVariable("B", b);
            }
        };
        GEN_8 = new CaptureMethod(){

            @Override
            public CaptureValues tryCapture(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                return GEN_5.tryCapture(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
            }

            @Override
            public void captureCalculation(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                double cvc;
                double hpMax = health.getMaxHP();
                double hpCurrent = health.getCurrentHP();
                PixelmonWrapper pw = health.getWrapper();
                if (pw != null) {
                    hpCurrent = pw.getHealth();
                }
                double bonusStatus = this.statusEffectCheck(values, health, pokeBall, pokeBallEntity, thrower, pokemon, mode);
                double d = cvc = StorageProxy.getPartyNow(thrower).getLowestLevel() < pokemon.getPokemonLevel() ? 410.0 : 4096.0;
                if (health.isRaid()) {
                    values.disableCritical();
                    int stars = health.getRaid().getStars();
                    cvc = stars <= 0 ? 1044480.0 : (stars == 1 ? 8192.0 : (stars == 2 ? 6144.0 : (stars == 3 ? 4096.0 : (stars == 4 ? 2048.0 : (stars == 5 ? 1024.0 : 0.0)))));
                }
                double a = Math.floor((3.0 * hpMax - 2.0 * hpCurrent) * 4096.0 + 0.5) * (double)values.getCatchRate();
                a = this.round(values.getBallBonus() * a) / (3.0 * hpMax);
                if (pokemon.getPokemonLevel() <= 20) {
                    a = Math.floor((30.0 - (double)pokemon.getPokemonLevel()) * a / 10.0);
                }
                a = this.round(bonusStatus * a);
                a = Math.min(this.round(cvc * a), 1044480.0);
                double b = 65536.0 / Math.pow(1044480.0 / a, 0.1875);
                values.setVariable("A", a);
                values.setVariable("B", b);
            }

            @Override
            public void criticalCaptureCheck(CaptureValues values, CaptureHealth health, PokeBall pokeBall, @Nullable PokeBallEntity pokeBallEntity, ServerPlayer thrower, Pokemon pokemon, PokeBallMode mode) {
                PlayerPartyStorage pps = StorageProxy.getPartyNow(thrower);
                double a = values.getVariable("A");
                int caught = pps.playerPokedex.countCaught();
                double am = caught <= 30 ? 0.0 : (caught <= 150 ? 2048.0 : (caught <= 300 ? 4096.0 : (caught <= 450 ? 6144.0 : (caught <= 600 ? 8192.0 : 10240.0))));
                if (pps.getCatchingCharm().isActive()) {
                    am *= PixelmonConfigProxy.getGeneral().getCatchingCharmMultiplier();
                }
                int c = (int)(7.1587883E7 * this.round(am * a) / 1.7592186044416E13);
                if (RandomHelper.getRandom().nextInt(256) < c) {
                    values.setCritical();
                }
            }

            private double round(double x) {
                return Math.floor((x + 2048.0) / 4096.0);
            }
        };
    }
}

