/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.catching;

import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CaptureHealth {
    private final double currentHP;
    private final double maxHP;
    private final PixelmonEntity entity;
    private final PixelmonWrapper wrapper;
    private final boolean isRaid;
    private final RaidData.RaidPlayer raidPlayer;
    private final RaidData raid;

    public CaptureHealth(@Nonnull PixelmonEntity entity) {
        this.currentHP = entity.m_21223_();
        this.maxHP = entity.m_21233_();
        this.entity = entity;
        this.wrapper = entity.getPixelmonWrapper();
        this.isRaid = false;
        this.raidPlayer = null;
        this.raid = null;
    }

    public CaptureHealth(@Nonnull RaidData.RaidPlayer raidPlayer, @Nonnull RaidData raid) {
        this.currentHP = 1.0;
        this.maxHP = raidPlayer.possibleCatch.getMaxHealth();
        this.entity = null;
        this.wrapper = null;
        this.isRaid = true;
        this.raidPlayer = raidPlayer;
        this.raid = raid;
    }

    public double getCurrentHP() {
        return this.currentHP;
    }

    public double getMaxHP() {
        return this.maxHP;
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    @Nullable
    public PixelmonEntity getEntity() {
        return this.entity;
    }

    public boolean hasWrapper() {
        return this.wrapper != null;
    }

    @Nullable
    public PixelmonWrapper getWrapper() {
        return this.wrapper;
    }

    public boolean isRaid() {
        return this.isRaid;
    }

    @Nullable
    public RaidData.RaidPlayer getRaidPlayer() {
        return this.raidPlayer;
    }

    @Nullable
    public RaidData getRaid() {
        return this.raid;
    }
}

