/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.boss;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.WeightedSet;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DropSet {
    private final double chance;
    private final int quantity;
    private final WeightedSet<Drop> drops;

    public DropSet(double chance, int quantity, WeightedSet<Drop> drops) {
        this.chance = chance;
        this.quantity = quantity;
        this.drops = drops;
    }

    public DropSet(JsonObject json, JsonDeserializationContext ctx) {
        this.chance = json.get("chance").getAsDouble();
        this.quantity = json.get("quantity").getAsInt();
        this.drops = WeightedSet.newWeightedSet(new Object[0]);
        for (JsonElement element : json.getAsJsonArray("drops")) {
            Drop drop = new Drop(element.getAsJsonObject(), ctx);
            this.drops.add(drop.getWeight(), drop);
        }
    }

    public DropSet(FriendlyByteBuf buf) {
        this.chance = buf.readDouble();
        this.quantity = buf.readInt();
        int numberOfDrops = buf.readInt();
        this.drops = WeightedSet.newWeightedSet(new Object[0]);
        for (int i = numberOfDrops; i > 0; --i) {
            Drop d = new Drop(buf);
            this.drops.add(d.weight, d);
        }
    }

    public Set<Drop> getDrops() {
        HashSet drops = Sets.newHashSet();
        if (!this.drops.isEffectivelyEmpty() && RandomHelper.getRandomChance(this.chance)) {
            for (int i = 0; i < this.quantity; ++i) {
                drops.add(this.drops.get());
            }
        }
        return drops;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.writeDouble(this.chance);
        buf.writeInt(this.quantity);
        buf.writeInt(this.drops.size());
        Iterator<Drop> dropIterator = this.drops.iterator();
        while (dropIterator.hasNext()) {
            Drop drop = dropIterator.next();
            drop.toBuffer(buf);
        }
    }

    public static class Drop {
        private final int weight;
        private final String name;
        private final ItemStack item;
        private final String[] commands;
        private final boolean ephemeral;

        public Drop(int weight, String name, ItemStack item, boolean ephemeral, String ... commands) {
            this.weight = weight;
            this.name = name;
            this.item = item;
            this.ephemeral = ephemeral;
            this.commands = commands;
        }

        public Drop(JsonObject json, JsonDeserializationContext ctx) {
            ItemStack item;
            this.weight = json.get("weight").getAsInt();
            this.name = json.get("name").getAsString();
            String itemString = json.get("item").getAsString();
            if (itemString.contains("{")) {
                try {
                    item = ItemStack.m_41712_((CompoundTag)TagParser.m_129359_((String)itemString));
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to read tag as item in boss drop: {}", (Object)itemString);
                    item = ItemStack.f_41583_;
                }
            } else {
                try {
                    item = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocationHelper.of(itemString)));
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to read item in boss drop: {}", (Object)itemString);
                    item = ItemStack.f_41583_;
                }
            }
            this.item = item;
            if (json.has("nbt")) {
                try {
                    item.m_41751_(item.m_41784_().m_128391_(TagParser.m_129359_((String)json.get("nbt").getAsString())));
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to read tag in boss drop: {}", (Object)itemString);
                }
            }
            JsonArray commands = json.getAsJsonArray("commands");
            this.commands = new String[commands.size()];
            int i = 0;
            for (JsonElement command : commands) {
                this.commands[i++] = command.getAsString();
            }
            this.ephemeral = json.get("ephemeral").getAsBoolean();
        }

        public Drop(FriendlyByteBuf buf) {
            this.weight = buf.readInt();
            this.name = buf.m_130277_();
            this.item = buf.m_130267_();
            if (!this.name.isEmpty()) {
                this.item.m_41714_((Component)Component.m_237113_((String)this.name));
            }
            int commandsLength = buf.readInt();
            this.commands = new String[commandsLength];
            for (int i = 0; i < commandsLength; ++i) {
                this.commands[i] = buf.m_130277_();
            }
            this.ephemeral = buf.readBoolean();
        }

        public void toBuffer(FriendlyByteBuf buf) {
            buf.writeInt(this.weight);
            buf.m_130070_(this.name);
            buf.m_130055_(this.item);
            buf.writeInt(this.commands.length);
            for (String command : this.commands) {
                buf.m_130070_(command);
            }
            buf.writeBoolean(this.ephemeral);
        }

        public int getWeight() {
            return this.weight;
        }

        public String getName() {
            return this.name == null || this.name.isEmpty() ? this.item.m_41611_().getString() : this.name;
        }

        public ItemStack getDisplayItem() {
            ItemStack stack = this.item.m_41777_();
            if (!this.name.isEmpty()) {
                stack.m_41714_((Component)Component.m_237113_((String)this.getName()));
            }
            return stack;
        }

        public void drop(ServerPlayer player, Vec3 pos) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (this.ephemeral) {
                this.give(player);
            } else {
                server.execute(() -> player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), this.item.m_41777_())));
            }
        }

        public void give(ServerPlayer player) {
            ItemStack item;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (!this.ephemeral && !player.m_36356_(item = this.item.m_41777_())) {
                player.m_7197_(item, false, false);
            }
            for (String command : this.commands) {
                server.m_129892_().m_230957_(server.m_129893_(), command.replace("@p", player.m_7755_().getString()));
            }
        }
    }
}

