/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.boss;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierTypeAdapter;
import com.pixelmonmod.pixelmon.api.pokemon.boss.DropSet;
import com.pixelmonmod.pixelmon.api.util.WeightedSet;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.config.starter.ColorTypeAdapter;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;

public class BossTierRegistry {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).registerTypeAdapter(BossTier.class, (Object)new BossTierTypeAdapter()).serializeNulls().create();
    private static final Map<String, BossTier> BOSS_TIERS = Maps.newHashMap();
    private static final WeightedSet<BossTier> SPAWNABLE_BOSS_TIERS = WeightedSet.newWeightedSet(new Object[0]);
    private static final WeightedSet<BossTier> SPAWNABLE_MEGA_BOSS_TIERS = WeightedSet.newWeightedSet(new Object[0]);
    private static final List<BossTier> BOSS_TIERS_NOT_NOT_BOSS = Lists.newArrayList();
    public static BossTier NOT_BOSS;

    public static void registerBossTier(BossTier bossTier) {
        BOSS_TIERS.put(bossTier.getID(), bossTier);
        if (bossTier.canRandomlySpawn()) {
            SPAWNABLE_BOSS_TIERS.add(bossTier.getWeight(), bossTier);
            if (bossTier.isMega()) {
                SPAWNABLE_MEGA_BOSS_TIERS.add(bossTier.getWeight(), bossTier);
            }
        }
        if (bossTier.isNotBoss()) {
            NOT_BOSS = bossTier;
        } else {
            BOSS_TIERS_NOT_NOT_BOSS.add(bossTier);
        }
    }

    public static void addNotBossIfNotPresent() {
        if (!BOSS_TIERS.containsKey("notboss")) {
            BossTierRegistry.registerBossTier(new BossTier("notboss", "enum.trainerBoss.notboss", false, 0, Color.WHITE, 1.0f, false, 0.0, 0.0, "", 1.0, 0, new DropSet[0]));
        }
    }

    public static Optional<BossTier> getBossTier(String id) {
        return Optional.ofNullable(BossTierRegistry.getBossTierUnsafe(id));
    }

    public static BossTier getBossTierUnsafe(String id) {
        return BOSS_TIERS.get(id.toLowerCase(Locale.ROOT));
    }

    public static BossTier getBossTierOrNotBoss(String id) {
        return BOSS_TIERS.getOrDefault(id.toLowerCase(Locale.ROOT), NOT_BOSS);
    }

    public static List<BossTier> getBossTiers() {
        return BOSS_TIERS_NOT_NOT_BOSS;
    }

    public static BossTier getRandomBossTier() {
        return RandomHelper.getRandomElementFromCollection(BOSS_TIERS_NOT_NOT_BOSS);
    }

    public static BossTier getRandomSpawnableBossTier() {
        return SPAWNABLE_BOSS_TIERS.get();
    }

    public static BossTier getRandomSpawnableMegaBossTier() {
        return SPAWNABLE_MEGA_BOSS_TIERS.get();
    }

    public static void reset() {
        BOSS_TIERS.clear();
        SPAWNABLE_BOSS_TIERS.clear();
        SPAWNABLE_MEGA_BOSS_TIERS.clear();
        BOSS_TIERS_NOT_NOT_BOSS.clear();
        NOT_BOSS = null;
    }

    public static void readFromJson(Gson gson, JsonElement json) {
        BossTier bossTier = (BossTier)gson.fromJson(json, BossTier.class);
        if (bossTier != null) {
            BossTierRegistry.registerBossTier(bossTier);
        }
    }

    public static void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(BOSS_TIERS.size());
        for (BossTier bossTier : BOSS_TIERS.values()) {
            bossTier.toBuffer(buf);
        }
    }

    public static void readFromBuffer(FriendlyByteBuf buf) {
        BossTierRegistry.reset();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            BossTierRegistry.registerBossTier(new BossTier(buf));
        }
    }
}

