/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.boss;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.pixelmonmod.pixelmon.api.pokemon.boss.DropSet;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.config.starter.ColorTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractHoldsItemsEntity;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BossTier {
    private final String id;
    private final String name;
    private final boolean canRandomlySpawn;
    private final int weight;
    private final Color color;
    private final float modelScaleFactor;
    private final boolean isMega;
    private final double megaStoneObtainChance;
    private final double megaStoneRepeatChance;
    private final String alwaysPalette;
    private final double levelMultiplier;
    private final int extraLevels;
    private final List<DropSet> dropSets;
    private transient Boolean isBoss = null;

    public BossTier(String id, String name, boolean canRandomlySpawn, int weight, Color color, float modelScaleFactor, boolean isMega, double megaStoneObtainChance, double megaStoneRepeatChance, String alwaysPalette, double levelMultiplier, int extraLevels, DropSet ... dropSets) {
        this.id = id;
        this.name = name;
        this.canRandomlySpawn = canRandomlySpawn;
        this.weight = weight;
        this.color = color;
        this.modelScaleFactor = modelScaleFactor;
        this.isMega = isMega;
        this.megaStoneObtainChance = megaStoneObtainChance;
        this.megaStoneRepeatChance = megaStoneRepeatChance;
        this.alwaysPalette = alwaysPalette;
        this.levelMultiplier = levelMultiplier;
        this.extraLevels = extraLevels;
        this.dropSets = Lists.newArrayList((Object[])dropSets);
    }

    public BossTier(JsonObject json, JsonDeserializationContext ctx) {
        this.id = json.get("id").getAsString();
        this.name = json.get("name").getAsString();
        this.canRandomlySpawn = json.get("canRandomlySpawn").getAsBoolean();
        this.weight = json.get("weight").getAsInt();
        this.color = ColorTypeAdapter.getColor(json.get("color"));
        this.modelScaleFactor = json.get("modelScaleFactor").getAsFloat();
        this.isMega = json.get("isMega").getAsBoolean();
        this.megaStoneObtainChance = json.get("megaStoneObtainChance").getAsDouble();
        this.megaStoneRepeatChance = json.get("megaStoneRepeatChance").getAsDouble();
        this.alwaysPalette = json.get("alwaysPalette").getAsString();
        this.levelMultiplier = json.get("levelMultiplier").getAsDouble();
        this.extraLevels = json.get("extraLevels").getAsInt();
        this.dropSets = Lists.newArrayList();
        for (JsonElement element : json.getAsJsonArray("dropSets")) {
            this.dropSets.add(new DropSet((JsonObject)element, ctx));
        }
    }

    public BossTier(FriendlyByteBuf buf) {
        this.id = buf.m_130277_();
        this.name = buf.m_130277_();
        this.canRandomlySpawn = buf.readBoolean();
        this.weight = buf.readInt();
        this.color = new Color(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        this.modelScaleFactor = buf.readFloat();
        this.megaStoneObtainChance = buf.readDouble();
        this.megaStoneRepeatChance = buf.readDouble();
        this.isMega = buf.readBoolean();
        this.alwaysPalette = buf.m_130277_();
        this.levelMultiplier = buf.readDouble();
        this.extraLevels = buf.readInt();
        this.dropSets = new ArrayList<DropSet>();
        int dropSetsLength = buf.readInt();
        for (int i = 0; i < dropSetsLength; ++i) {
            DropSet dropSet = new DropSet(buf);
            this.dropSets.add(dropSet);
        }
    }

    public JsonObject toJson(JsonSerializationContext ctx) {
        JsonObject json = new JsonObject();
        json.addProperty("id", this.id);
        json.addProperty("name", this.name);
        json.addProperty("canRandomlySpawn", Boolean.valueOf(this.canRandomlySpawn));
        json.addProperty("weight", (Number)this.weight);
        json.add("color", ColorTypeAdapter.toJson(this.color));
        json.addProperty("modelScaleFactor", (Number)Float.valueOf(this.modelScaleFactor));
        json.addProperty("isMega", Boolean.valueOf(this.isMega));
        json.addProperty("alwaysPalette", this.alwaysPalette);
        json.addProperty("levelMultiplier", (Number)this.levelMultiplier);
        json.addProperty("extraLevels", (Number)this.extraLevels);
        return json;
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.id);
        buf.m_130070_(this.name);
        buf.writeBoolean(this.canRandomlySpawn);
        buf.writeInt(this.weight);
        buf.writeInt(this.color.getRed());
        buf.writeInt(this.color.getGreen());
        buf.writeInt(this.color.getBlue());
        buf.writeInt(this.color.getAlpha());
        buf.writeFloat(this.modelScaleFactor);
        buf.writeDouble(this.megaStoneObtainChance);
        buf.writeDouble(this.megaStoneRepeatChance);
        buf.writeBoolean(this.isMega);
        buf.m_130070_(this.alwaysPalette);
        buf.writeDouble(this.levelMultiplier);
        buf.writeInt(this.extraLevels);
        buf.writeInt(this.dropSets.size());
        for (int i = 0; i < this.dropSets.size(); ++i) {
            this.dropSets.get(i).toBuffer(buf);
        }
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBoss() {
        if (this.isBoss == null) {
            this.isBoss = !this.id.equalsIgnoreCase("notboss");
        }
        return this.isBoss;
    }

    public boolean isNotBoss() {
        return !this.isBoss();
    }

    public boolean canRandomlySpawn() {
        return this.canRandomlySpawn;
    }

    public int getWeight() {
        return this.weight;
    }

    public Color getColor() {
        return this.color;
    }

    public float getModelScaleFactor() {
        return this.modelScaleFactor;
    }

    public boolean isMega() {
        return this.isMega;
    }

    public String getAlwaysPalette() {
        return this.alwaysPalette;
    }

    public double getLevelMultiplier() {
        return this.levelMultiplier;
    }

    public int getExtraLevels() {
        return this.extraLevels;
    }

    public Set<DropSet.Drop> getDrops(ServerPlayer player, AbstractHoldsItemsEntity pixelmon) {
        HashSet drops = Sets.newHashSet();
        for (DropSet dropSet : this.dropSets) {
            drops.addAll(dropSet.getDrops());
        }
        if (this.isMega()) {
            PlayerPartyStorage storage;
            Item megaStone;
            Species pokemon = pixelmon.getSpecies();
            Stats form = pixelmon.getForm();
            if (form.hasMegaForm() && (megaStone = CollectionHelper.getRandomElement(form.getMegaItems())) != null && RandomHelper.getRandomChance((storage = StorageProxy.getPartyNow(player)).isMegaItemObtained(pokemon, form) ? this.megaStoneRepeatChance : this.megaStoneObtainChance)) {
                drops.add(new DropSet.Drop(1, "", new ItemStack((ItemLike)megaStone), false, new String[0]));
                storage.obtainedItem(pokemon, form, player);
            }
        }
        return drops;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BossTier)) {
            return false;
        }
        return ((BossTier)obj).getID().equalsIgnoreCase(this.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public String toString() {
        return "BossTier{" + this.getID() + "}";
    }
}

