/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public class Truant
extends AbstractAbility {
    public boolean canMove = true;
    public boolean replacedEOTFaint = false;

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (user.bc.simulateMode) {
            return this.canMove;
        }
        if (this.canMove) {
            return true;
        }
        this.canMove = true;
        user.bc.sendToAll("pixelmon.abilities.truant", user.getNickname());
        return false;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.simulateMode) {
            return;
        }
        this.canMove = !newPokemon.evolvedThisTurn && !this.replacedEOTFaint;
        this.replacedEOTFaint = false;
    }

    @Override
    public void applySwitchReplaceEffect(PixelmonWrapper newPokemon, PixelmonWrapper oldPokemon) {
        if (newPokemon.bc.simulateMode) {
            return;
        }
        this.replacedEOTFaint = oldPokemon.isFainted() && oldPokemon.faintedAtEndOfTurn;
    }

    @Override
    public void startMove(PixelmonWrapper pw) {
        if (pw.bc.simulateMode) {
            return;
        }
        this.canMove = false;
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }
}

