/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.ArrayList;
import java.util.Set;

public class Trace
extends AbstractAbility {
    private static final Set<String> INVALID_ABILITIES = Sets.newHashSet((Object[])new String[]{"AsOne", "BattleBond", "Comatose", "Disguise", "FlowerGift", "Forecast", "GulpMissile", "HungerSwitch", "IceFace", "Illusion", "Imposter", "Multitype", "NeutralizingGas", "PowerConstruct", "PowerOfAlchemy", "Receiver", "RKSSystem", "Schooling", "ShieldsDown", "StanceChange", "Trace", "ZenMode", "Commander", "ZeroToHero"});
    public boolean brokenByNullAbility = false;

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.brokenByNullAbility = false;
        ArrayList<PixelmonWrapper> opponents = newPokemon.getOpponentPokemon();
        for (PixelmonWrapper opponent : opponents) {
            Ability targetAbility = opponent.getBattleAbility(false);
            if (targetAbility != null && !(targetAbility instanceof ComingSoon)) continue;
            this.brokenByNullAbility = true;
        }
        this.traceAbility(newPokemon);
    }

    @Override
    public void applyFoeSwitchInEffect(PixelmonWrapper user, PixelmonWrapper newPokemon, PixelmonWrapper former) {
        this.traceAbility(user);
    }

    private void traceAbility(PixelmonWrapper user) {
        if (this.brokenByNullAbility) {
            return;
        }
        ArrayList<PixelmonWrapper> opponents = user.getOpponentPokemon();
        while (!opponents.isEmpty()) {
            PixelmonWrapper opponent = RandomHelper.getRandomElementFromList(opponents);
            Ability targetAbility = opponent.getBattleAbility(false);
            if (!INVALID_ABILITIES.contains(targetAbility.getName()) && !(targetAbility instanceof ComingSoon) && !opponent.isFainted() && targetAbility.canBeCopied()) {
                user.bc.sendToAll("pixelmon.abilities.trace", user.getNickname(), opponent.getNickname(), targetAbility.getTranslatedName());
                user.setTempAbility(targetAbility);
                return;
            }
            opponents.remove(opponent);
        }
    }
}

