/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.api.pokemon.requirement.impl.FormRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnInfoPokemon;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class Static
extends AbstractAbility {
    @Override
    public void applyEffectOnContactTarget(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.getRandomChance(30) && !user.hasStatus(StatusType.Paralysis) && Paralysis.paralyze(target, user, null, false)) {
            target.bc.sendToAll("pixelmon.abilities.static", target.getNickname(), user.getNickname());
        }
    }

    @Override
    public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        if (!(spawnInfo instanceof SpawnInfoPokemon)) {
            return 1.0f;
        }
        SpawnInfoPokemon spawnInfoPokemon = (SpawnInfoPokemon)spawnInfo;
        RegistryValue specSpecies = spawnInfoPokemon.getPokemonSpec().getValue(SpeciesRequirement.class).orElse(null);
        if (spawnInfoPokemon.getPokemonSpec() == null || specSpecies == null || !specSpecies.isInitialized()) {
            return 1.0f;
        }
        Species species = spawnInfoPokemon.getSpecies();
        if (species == null) {
            return 1.0f;
        }
        String form = spawnInfoPokemon.getPokemonSpec().getValue(FormRequirement.class).orElse(species.getDefaultForm().getName());
        Stats stats = species.getForm(form);
        if (stats == null || stats.getTypes() == null) {
            return 1.0f;
        }
        return stats.getTypes().contains(Element.ELECTRIC) ? 5.0f : 1.0f;
    }
}

