/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public class SlowStart
extends AbstractAbility {
    private int turnsRemaining = 5;

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        newPokemon.bc.sendToAll("pixelmon.abilities.slowstart", newPokemon.getNickname());
        this.turnsRemaining = 5;
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.turnsRemaining = 5;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (this.turnsRemaining > 0) {
            int n = BattleStatsType.SPEED.getStatIndex();
            stats[n] = stats[n] / 2;
        }
        return stats;
    }

    @Override
    public int[] modifyStatsCancellable(PixelmonWrapper user, int[] stats) {
        boolean moveIgnoresAbility;
        boolean bl = moveIgnoresAbility = user.attack != null && user.attack.getMove().getIgnoresAbilities() && !user.isTempAttack;
        if (this.turnsRemaining > 0 && !moveIgnoresAbility) {
            int n = BattleStatsType.ATTACK.getStatIndex();
            stats[n] = stats[n] / 2;
        }
        return stats;
    }

    @Override
    public void startMove(PixelmonWrapper user) {
        if (!user.bc.simulateMode && this.turnsRemaining > 0 && user.attack != null) {
            int[] stats = user.getBattleStats().getBattleStats();
            if (user.attack.isAttack(AttackRegistry.PHOTON_GEYSER) && user.isTempAttack) {
                if (stats[BattleStatsType.ATTACK.getStatIndex()] * 2 > stats[BattleStatsType.SPECIAL_ATTACK.getStatIndex()]) {
                    int n = BattleStatsType.ATTACK.getStatIndex();
                    stats[n] = stats[n] * 2;
                }
            } else if (user.attack.getMove().getAttackCategory() == AttackCategory.SPECIAL && user.usingZ) {
                int n = BattleStatsType.SPECIAL_ATTACK.getStatIndex();
                stats[n] = stats[n] / 2;
            }
            user.getBattleStats().setStatsForTurn(stats);
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        if (--this.turnsRemaining == 0) {
            pokemon.bc.sendToAll("pixelmon.abilities.slowstartend", pokemon.getNickname());
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }
}

