/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class ShieldsDown
extends AbstractAbility {
    @Override
    public boolean canBeIgnored() {
        return false;
    }

    @Override
    public boolean allowsStatus(StatusType status, PixelmonWrapper pw, PixelmonWrapper user) {
        if (status == StatusType.Burn || status == StatusType.Freeze || status == StatusType.Paralysis || status == StatusType.Poison || status == StatusType.PoisonBadly || status == StatusType.Sleep || status == StatusType.Yawn || status == StatusType.Frostbite) {
            return !pw.getSpecies().is(PixelmonSpecies.MINIOR) || !pw.getForm().isForm("meteor");
        }
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        this.tryFormChange(pw);
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        this.tryFormChange(newPokemon);
    }

    @Override
    public void applyEndOfBattleEffect(PixelmonWrapper pw) {
        ParticipantType type = pw.getParticipant().getType();
        if (type == ParticipantType.WildPokemon && pw.pokemon.getOriginalTrainer() == null) {
            pw.setForm("meteor");
        } else {
            pw.setForm("core");
        }
    }

    private void tryFormChange(PixelmonWrapper pw) {
        if (pw.getSpecies().is(PixelmonSpecies.MINIOR)) {
            if (!pw.getForm().isForm("meteor")) {
                if (pw.getHealthPercent() > 50.0f) {
                    pw.setForm("meteor");
                    pw.bc.sendToAll("pixelmon.abilities.changeform", pw.getNickname());
                }
            } else if (pw.getForm().isForm("meteor") && pw.getHealthPercent() < 50.0f) {
                pw.setForm("core");
                pw.bc.sendToAll("pixelmon.abilities.changeform", pw.getNickname());
            }
        }
    }
}

