/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public abstract class Redirect
extends AbstractAbility {
    Element type;
    String langImmune;
    String langRedirect;

    public Redirect(Element type, String langImmune, String langRedirect) {
        this.type = type;
        this.langImmune = langImmune;
        this.langRedirect = langRedirect;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        newPokemon.bc.timedAbilityStarted(newPokemon);
    }

    @Override
    public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        if (a.getType() == this.type && !AbilityRegistry.ignoreAbility(user, pokemon)) {
            if (a.getTypeEffectiveness(user, pokemon) == 0.0) {
                pokemon.bc.sendToAll("pixelmon.battletext.noeffect", pokemon.getNickname());
                return false;
            }
            pokemon.bc.sendToAll(this.langImmune, pokemon.getNickname());
            if (pokemon.getBattleStats().modifyStat(1, BattleStatsType.SPECIAL_ATTACK)) {
                a.moveResult.weightMod -= 25.0f;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean redirectAttack(PixelmonWrapper attacker, PixelmonWrapper abilityUser, Attack attack) {
        if (attacker != abilityUser && attack.getType() == this.type && !attack.isAttack(AttackRegistry.SNIPE_SHOT) && !attacker.getBattleAbility().preventsRedirection(attacker, attack) && !AbilityRegistry.ignoreAbility(attacker, abilityUser) && this.inRedirectRange(attacker, abilityUser, attack)) {
            abilityUser.bc.sendToAll(this.langRedirect, abilityUser.getNickname());
            return true;
        }
        return false;
    }

    protected boolean inRedirectRange(PixelmonWrapper attacker, PixelmonWrapper abilityUser, Attack attack) {
        return attack.isMax && attacker.bc.arePokemonAdjacent(attacker, abilityUser) || attack.canReachTarget(attacker, abilityUser);
    }
}

