/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.PickupEvent;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.items.HeldItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public class Pickup
extends AbstractAbility {
    private HeldItem consumedItem = PixelmonItems.no_item;
    private PixelmonWrapper consumer;

    @Override
    public void onItemConsumed(PixelmonWrapper pokemon, PixelmonWrapper consumer, HeldItem heldItem) {
        if (pokemon != consumer && !pokemon.bc.simulateMode) {
            this.consumedItem = heldItem;
            this.consumer = consumer;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        if (pokemon != this.consumer && !pokemon.bc.simulateMode) {
            if (!pokemon.hasHeldItem() && this.consumedItem != PixelmonItems.no_item && this.consumer != null && this.consumer.getConsumedItem() != PixelmonItems.no_item && pokemon.bc.getActivePokemon().contains(this.consumer)) {
                pokemon.setHeldItem(this.consumedItem);
                this.consumer.setConsumedItem(null);
                pokemon.bc.sendToAll("pixelmon.abilities.pickup", pokemon.getNickname(), this.consumedItem.getLocalizedName());
                pokemon.enableReturnHeldItem();
            }
            this.consumedItem = null;
            this.consumer = null;
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }

    public static void pickupItem(PlayerParticipant player) {
        if (PixelmonConfigProxy.getBattle().getPickupRate() > 0) {
            for (PixelmonWrapper pw : player.allPokemon) {
                int rand;
                if (!(pw.getAbility() instanceof Pickup) || pw.hasHeldItem() || !player.bc.getRandomChance(1.0f / (float)PixelmonConfigProxy.getBattle().getPickupRate())) continue;
                int level = pw.getPokemonLevelNum();
                ItemStack foundItem = level <= 50 ? DropItemRegistry.getTier1Drop() : (level <= 80 ? ((rand = RandomHelper.getRandomNumberBetween(1, 100)) < 91 ? DropItemRegistry.getTier1Drop() : DropItemRegistry.getTier2Drop()) : ((rand = RandomHelper.getRandomNumberBetween(1, 100)) < 80 ? DropItemRegistry.getTier1Drop() : (rand < 100 ? DropItemRegistry.getTier2Drop() : DropItemRegistry.getTier3Drop())));
                if (foundItem == null) continue;
                ItemStack itemCopy = foundItem.m_41777_();
                itemCopy.m_41764_(1);
                PickupEvent event = new PickupEvent(pw, player, itemCopy);
                if (Pixelmon.EVENT_BUS.post((Event)event)) continue;
                player.player.m_150109_().m_36054_(event.stack);
            }
        }
    }
}

