/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.ParadoxBoost;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.Locale;

public class ParadoxBoostAbility
extends AbstractAbility {
    public void activateViaItem(PixelmonWrapper pw) {
        if (!this.isActualAbility(pw)) {
            return;
        }
        pw.bc.sendToAll("pixelmon.abilities.paradoxbooster", new Object[0]);
        pw.enableReturnHeldItem();
        pw.writeToNBT();
        pw.removeHeldItem();
        pw.bc.sendToAll("pixelmon.abilities." + this.getName().toLowerCase(Locale.ROOT) + "booster", pw.getNickname());
        this.activate(pw, true);
    }

    public void activateViaAbility(PixelmonWrapper pw) {
        if (!pw.hasStatus(StatusType.ParadoxBoost) && this.isActualAbility(pw)) {
            pw.bc.sendToAll("pixelmon.abilities." + this.getName().toLowerCase(Locale.ROOT), pw.getNickname());
            this.activate(pw, false);
        }
    }

    public void deactivate(PixelmonWrapper pw) {
        ParadoxBoost boost = (ParadoxBoost)pw.getStatus(StatusType.ParadoxBoost);
        if (boost != null && !boost.itemBased) {
            pw.removeStatus(StatusType.ParadoxBoost);
            pw.bc.sendToAll("pixelmon.abilities.paradoxfade", pw.getNickname(), this.getLocalizedName());
        }
    }

    private void activate(PixelmonWrapper pw, boolean extended) {
        ParadoxBoost boost;
        if (pw.hasStatus(StatusType.ParadoxBoost)) {
            pw.removeStatus(StatusType.ParadoxBoost, false);
        }
        if (pw.addStatus(boost = new ParadoxBoost(pw, extended), pw)) {
            String statname = boost.boostedStat.getLocalizedName();
            pw.bc.sendToAll("pixelmon.abilities.paradoxstat", pw.getNickname(), statname);
        }
    }

    public boolean isActualAbility(PixelmonWrapper pw) {
        return pw.getAbility() instanceof ParadoxBoostAbility;
    }
}

