/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.OfRuinStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public abstract class OfRuin
extends AbstractAbility {
    private final BattleStatsType stat;

    public OfRuin(BattleStatsType stat) {
        this.stat = stat;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        newPokemon.bc.sendToAll("pixelmon.abilities.ofruin", newPokemon.getNickname(), this.getLocalizedName(), this.stat.getTranslatedName());
        OfRuinStatus status = (OfRuinStatus)newPokemon.bc.globalStatusController.getGlobalStatus(StatusType.OfRuinTracker);
        if (status == null) {
            status = new OfRuinStatus();
            newPokemon.bc.globalStatusController.addGlobalStatus(newPokemon, status);
        }
        status.checkForActiveOfRuinAbilities(newPokemon);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pw) {
        this.recalculateReductions(pw);
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.recalculateReductions(oldPokemon);
    }

    @Override
    public void onSelfFaint(PixelmonWrapper pokemon, PixelmonWrapper source) {
        this.recalculateReductions(pokemon);
    }

    private void recalculateReductions(PixelmonWrapper pw) {
        OfRuinStatus status = (OfRuinStatus)pw.bc.globalStatusController.getGlobalStatus(StatusType.OfRuinTracker);
        if (status != null) {
            status.checkForActiveOfRuinAbilities(pw);
        }
    }

    public BattleStatsType getStat() {
        return this.stat;
    }
}

