/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.GuardDog;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.InnerFocus;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Oblivious;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.OwnTempo;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Rattled;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Scrappy;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.controller.BattlePriorityHelper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import java.util.ArrayList;

public class Intimidate
extends AbstractAbility {
    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        boolean sentMessage = false;
        ArrayList<PixelmonWrapper> opponents = newPokemon.bc.getOpponentPokemon(newPokemon);
        for (PixelmonWrapper pw : BattlePriorityHelper.getTurnOrder(opponents)) {
            if (!sentMessage) {
                this.sendActivatedMessage(newPokemon);
                sentMessage = true;
            }
            if (pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.adrenalineOrb && pw.getBattleStats().getStage(BattleStatsType.SPEED) < 6) {
                pw.getBattleStats().modifyStat(1, BattleStatsType.SPEED, pw, false);
                pw.consumeItem();
                pw.bc.sendToAll("pixelmon.helditems.adrenalineorb", pw.getNickname());
            }
            if (pw.getBattleAbility() instanceof InnerFocus || pw.getAbility() instanceof Oblivious || pw.getAbility() instanceof Scrappy || pw.getAbility() instanceof OwnTempo) continue;
            if (pw.getBattleAbility().isAbility((Class<? extends Ability>)GuardDog.class)) {
                ((GuardDog)pw.getBattleAbility()).activate(pw);
            } else {
                pw.getBattleStats().modifyStat(-1, BattleStatsType.ATTACK, newPokemon, false);
            }
            if (!pw.getBattleAbility().isAbility((Class<? extends Ability>)Rattled.class)) continue;
            ((Rattled)pw.getBattleAbility()).activate(pw);
        }
    }
}

