/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;

public class EmergencyExit
extends AbstractAbility {
    @Override
    public void tookDamageTargetAfterMove(PixelmonWrapper user, PixelmonWrapper target, Attack a, float damage) {
        if (user == target || user.bc.simulateMode) {
            return;
        }
        this.handleSwitch(user, target);
    }

    @Override
    public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
        if (user.bc.simulateMode || damagetype != DamageTypeEnum.STATUS) {
            return;
        }
        this.handleSwitch(user, pokemon);
    }

    private void handleSwitch(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.getHealthPercent(target.getBeginingOfTurnHP()) >= 50.0f && target.getHealthPercent() <= 50.0f && !target.isFainted()) {
            if (target.stopsForcedSwitches(target)) {
                return;
            }
            if (target.getParticipant() instanceof WildPixelmonParticipant) {
                user.willTryFlee = true;
                target.bc.endBattle(BattleEndCause.FLEE);
            } else {
                BattleParticipant targetParticipant = target.getParticipant();
                ParticipantType targetType = targetParticipant.getType();
                if (!targetParticipant.hasMorePokemonReserve()) {
                    return;
                }
                target.bc.sendToAll("pixelmon.effect.escape", target.getNickname());
                target.setUpSwitchMove();
                if (targetType == ParticipantType.Player) {
                    NetworkHelper.sendPacket(new EnforcedSwitchTask(target.bc.getPositionOfPokemon(target, targetParticipant), target.nextSwitchIsMove), target.getPlayerOwner());
                } else {
                    target.bc.switchPokemon(target.getPokemonUUID(), target.getBattleAI().getNextSwitch(target), true);
                }
            }
        }
    }
}

