/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Sunny;

public class DesolateLand
extends AbstractAbility {
    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.globalStatusController.canWeatherChange(new Sunny(true))) {
            newPokemon.addGlobalStatus(new Sunny(true));
            newPokemon.bc.sendToAll("pixelmon.abilities.desolateland", newPokemon.getNickname());
        }
    }

    private void checkForRemoval(PixelmonWrapper pokemon) {
        if (pokemon.bc.globalStatusController.getWeatherIgnoreAbility() instanceof Sunny && pokemon.bc.globalStatusController.getWeatherIgnoreAbility().extreme) {
            for (PixelmonWrapper pw : pokemon.bc.getActivePokemon()) {
                if (pw == pokemon || !(pw.getBattleAbility() instanceof DesolateLand)) continue;
                return;
            }
            pokemon.bc.globalStatusController.removeGlobalStatus(StatusType.Sunny);
            pokemon.bc.globalStatusController.triggerWeatherChange(null);
            pokemon.bc.sendToAll("pixelmon.status.sunlightfaded", new Object[0]);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.checkForRemoval(oldPokemon);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.checkForRemoval(pokemon);
    }

    @Override
    public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
        if (pokemon.isFainted()) {
            this.checkForRemoval(pokemon);
        }
    }

    @Override
    public boolean canBeIgnored() {
        return false;
    }
}

