/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability;

import com.google.common.collect.Maps;
import com.pixelmonmod.api.registry.RegistryManager;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.AngerPoint;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MoldBreaker;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MyceliumMight;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.NeutralizingGas;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Teravolt;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Turboblaze;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class AbilityRegistry {
    private static final Map<String, AbilityData> REGISTERED_ABILITIES = Maps.newConcurrentMap();
    public static final RegistryValue<Ability> ADAPTABILITY = RegistryValue.of(Ability.class, "adaptability");
    public static final RegistryValue<Ability> AERILATE = RegistryValue.of(Ability.class, "aerilate");
    public static final RegistryValue<Ability> AFTERMATH = RegistryValue.of(Ability.class, "aftermath");
    public static final RegistryValue<Ability> AIR_LOCK = RegistryValue.of(Ability.class, "airlock");
    public static final RegistryValue<Ability> ANALYTIC = RegistryValue.of(Ability.class, "analytic");
    public static final RegistryValue<Ability> ANGER_POINT = RegistryValue.of(Ability.class, "angerpoint");
    public static final RegistryValue<Ability> ANGER_SHELL = RegistryValue.of(Ability.class, "angershell");
    public static final RegistryValue<Ability> ANTICIPATION = RegistryValue.of(Ability.class, "anticipation");
    public static final RegistryValue<Ability> ARENA_TRAP = RegistryValue.of(Ability.class, "arenatrap");
    public static final RegistryValue<Ability> ARMOR_TAIL = RegistryValue.of(Ability.class, "armortail");
    public static final RegistryValue<Ability> AROMA_VEIL = RegistryValue.of(Ability.class, "aromaveil");
    public static final RegistryValue<Ability> AS_ONE = RegistryValue.of(Ability.class, "asone");
    public static final RegistryValue<Ability> AURA_BREAK = RegistryValue.of(Ability.class, "aurabreak");
    public static final RegistryValue<Ability> BAD_DREAMS = RegistryValue.of(Ability.class, "baddreams");
    public static final RegistryValue<Ability> BALL_FETCH = RegistryValue.of(Ability.class, "ballfetch");
    public static final RegistryValue<Ability> BATTERY = RegistryValue.of(Ability.class, "battery");
    public static final RegistryValue<Ability> BATTLE_ARMOUR = RegistryValue.of(Ability.class, "battlearmour");
    public static final RegistryValue<Ability> BATTLE_BOND = RegistryValue.of(Ability.class, "battlebond");
    public static final RegistryValue<Ability> BEADS_OF_RUIN = RegistryValue.of(Ability.class, "beadsofruin");
    public static final RegistryValue<Ability> BEAST_BOOST = RegistryValue.of(Ability.class, "beastboost");
    public static final RegistryValue<Ability> BERSERK = RegistryValue.of(Ability.class, "berserk");
    public static final RegistryValue<Ability> BIG_PECKS = RegistryValue.of(Ability.class, "bigpecks");
    public static final RegistryValue<Ability> BLAZE = RegistryValue.of(Ability.class, "blaze");
    public static final RegistryValue<Ability> BULLETPROOF = RegistryValue.of(Ability.class, "bulletproof");
    public static final RegistryValue<Ability> CHEEK_POUCH = RegistryValue.of(Ability.class, "cheekpouch");
    public static final RegistryValue<Ability> CHILLING_NEIGH = RegistryValue.of(Ability.class, "chillingneigh");
    public static final RegistryValue<Ability> CHLOROPHYLL = RegistryValue.of(Ability.class, "chlorophyll");
    public static final RegistryValue<Ability> CLEAR_BODY = RegistryValue.of(Ability.class, "clearbody");
    public static final RegistryValue<Ability> CLOUD_NINE = RegistryValue.of(Ability.class, "cloudnine");
    public static final RegistryValue<Ability> COLOR_CHANGE = RegistryValue.of(Ability.class, "colorchange");
    public static final RegistryValue<Ability> COMATOSE = RegistryValue.of(Ability.class, "comatose");
    public static final RegistryValue<Ability> COMING_SOON = RegistryValue.of(Ability.class, "comingsoon");
    public static final RegistryValue<Ability> COMMANDER = RegistryValue.of(Ability.class, "commander");
    public static final RegistryValue<Ability> COMPETITIVE = RegistryValue.of(Ability.class, "competitive");
    public static final RegistryValue<Ability> COMPOUND_EYES = RegistryValue.of(Ability.class, "compoundeyes");
    public static final RegistryValue<Ability> CONTRARY = RegistryValue.of(Ability.class, "contrary");
    public static final RegistryValue<Ability> CORROSION = RegistryValue.of(Ability.class, "corrosion");
    public static final RegistryValue<Ability> COSTAR = RegistryValue.of(Ability.class, "costar");
    public static final RegistryValue<Ability> COTTON_DOWN = RegistryValue.of(Ability.class, "cottondown");
    public static final RegistryValue<Ability> CUD_CHEW = RegistryValue.of(Ability.class, "cudchew");
    public static final RegistryValue<Ability> CURIOUS_MEDICINE = RegistryValue.of(Ability.class, "curiousmedicine");
    public static final RegistryValue<Ability> CURSED_BODY = RegistryValue.of(Ability.class, "cursedbody");
    public static final RegistryValue<Ability> CUTE_CHARM = RegistryValue.of(Ability.class, "cutecharm");
    public static final RegistryValue<Ability> DAMP = RegistryValue.of(Ability.class, "damp");
    public static final RegistryValue<Ability> DANCER = RegistryValue.of(Ability.class, "dancer");
    public static final RegistryValue<Ability> DARK_AURA = RegistryValue.of(Ability.class, "darkaura");
    public static final RegistryValue<Ability> DAUNTLESS_SHIELD = RegistryValue.of(Ability.class, "dauntlessshield");
    public static final RegistryValue<Ability> DAZZLING = RegistryValue.of(Ability.class, "dazzling");
    public static final RegistryValue<Ability> DEFEATIST = RegistryValue.of(Ability.class, "defeatist");
    public static final RegistryValue<Ability> DEFIANT = RegistryValue.of(Ability.class, "defiant");
    public static final RegistryValue<Ability> DELTA_STREAM = RegistryValue.of(Ability.class, "deltastream");
    public static final RegistryValue<Ability> DESOLATE_LAND = RegistryValue.of(Ability.class, "desolateland");
    public static final RegistryValue<Ability> DISGUISE = RegistryValue.of(Ability.class, "disguise");
    public static final RegistryValue<Ability> DOWNLOAD = RegistryValue.of(Ability.class, "download");
    public static final RegistryValue<Ability> DRAGONS_MAW = RegistryValue.of(Ability.class, "dragonsmaw");
    public static final RegistryValue<Ability> DRIZZLE = RegistryValue.of(Ability.class, "drizzle");
    public static final RegistryValue<Ability> DROUGHT = RegistryValue.of(Ability.class, "drought");
    public static final RegistryValue<Ability> DRY_SKIN = RegistryValue.of(Ability.class, "dryskin");
    public static final RegistryValue<Ability> EARLY_BIRD = RegistryValue.of(Ability.class, "earlybird");
    public static final RegistryValue<Ability> EARTH_EATER = RegistryValue.of(Ability.class, "eartheater");
    public static final RegistryValue<Ability> EFFECT_SPORE = RegistryValue.of(Ability.class, "effectspore");
    public static final RegistryValue<Ability> ELECTRIC_SURGE = RegistryValue.of(Ability.class, "electricsurge");
    public static final RegistryValue<Ability> ELECTROMORPHOSIS = RegistryValue.of(Ability.class, "electromorphosis");
    public static final RegistryValue<Ability> EMERGENCY_EXIT = RegistryValue.of(Ability.class, "emergencyexit");
    public static final RegistryValue<Ability> ERROR = RegistryValue.of(Ability.class, "error");
    public static final RegistryValue<Ability> FAIRY_AURA = RegistryValue.of(Ability.class, "fairyaura");
    public static final RegistryValue<Ability> FILTER = RegistryValue.of(Ability.class, "filter");
    public static final RegistryValue<Ability> FLAME_BODY = RegistryValue.of(Ability.class, "flamebody");
    public static final RegistryValue<Ability> FLARE_BOOST = RegistryValue.of(Ability.class, "flareboost");
    public static final RegistryValue<Ability> FLASH_FIRE = RegistryValue.of(Ability.class, "flashfire");
    public static final RegistryValue<Ability> FLOWER_GIFT = RegistryValue.of(Ability.class, "flowergift");
    public static final RegistryValue<Ability> FLOWER_VEIL = RegistryValue.of(Ability.class, "flowerveil");
    public static final RegistryValue<Ability> FLUFFY = RegistryValue.of(Ability.class, "fluffy");
    public static final RegistryValue<Ability> FORECAST = RegistryValue.of(Ability.class, "forecast");
    public static final RegistryValue<Ability> FOREWARN = RegistryValue.of(Ability.class, "forewarn");
    public static final RegistryValue<Ability> FRIEND_GUARD = RegistryValue.of(Ability.class, "friendguard");
    public static final RegistryValue<Ability> FRISK = RegistryValue.of(Ability.class, "frisk");
    public static final RegistryValue<Ability> FULL_METAL_BODY = RegistryValue.of(Ability.class, "fullmetalbody");
    public static final RegistryValue<Ability> FUR_COAT = RegistryValue.of(Ability.class, "furcoat");
    public static final RegistryValue<Ability> GALE_WINGS = RegistryValue.of(Ability.class, "galewings");
    public static final RegistryValue<Ability> GALVANIZE = RegistryValue.of(Ability.class, "galvanize");
    public static final RegistryValue<Ability> GLUTTONY = RegistryValue.of(Ability.class, "gluttony");
    public static final RegistryValue<Ability> GOOD_AS_GOLD = RegistryValue.of(Ability.class, "goodasgold");
    public static final RegistryValue<Ability> GOOEY = RegistryValue.of(Ability.class, "gooey");
    public static final RegistryValue<Ability> GORILLA_TACTICS = RegistryValue.of(Ability.class, "gorillatactics");
    public static final RegistryValue<Ability> GRASS_PELT = RegistryValue.of(Ability.class, "grasspelt");
    public static final RegistryValue<Ability> GRASSY_SURGE = RegistryValue.of(Ability.class, "grassysurge");
    public static final RegistryValue<Ability> GRIM_NEIGH = RegistryValue.of(Ability.class, "grimneigh");
    public static final RegistryValue<Ability> GUARD_DOG = RegistryValue.of(Ability.class, "guarddog");
    public static final RegistryValue<Ability> GULP_MISSILE = RegistryValue.of(Ability.class, "gulpmissile");
    public static final RegistryValue<Ability> GUTS = RegistryValue.of(Ability.class, "guts");
    public static final RegistryValue<Ability> HADRON_ENGINE = RegistryValue.of(Ability.class, "hadronengine");
    public static final RegistryValue<Ability> HARVEST = RegistryValue.of(Ability.class, "harvest");
    public static final RegistryValue<Ability> HEALER = RegistryValue.of(Ability.class, "healer");
    public static final RegistryValue<Ability> HEATPROOF = RegistryValue.of(Ability.class, "heatproof");
    public static final RegistryValue<Ability> HEAVY_METAL = RegistryValue.of(Ability.class, "heavymetal");
    public static final RegistryValue<Ability> HONEY_GATHER = RegistryValue.of(Ability.class, "honeygather");
    public static final RegistryValue<Ability> HOSPITALITY = RegistryValue.of(Ability.class, "hospitality");
    public static final RegistryValue<Ability> HUGE_POWER = RegistryValue.of(Ability.class, "hugepower");
    public static final RegistryValue<Ability> HUNGER_SWITCH = RegistryValue.of(Ability.class, "hungerswitch");
    public static final RegistryValue<Ability> HUSTLE = RegistryValue.of(Ability.class, "hustle");
    public static final RegistryValue<Ability> HYDRATION = RegistryValue.of(Ability.class, "hydration");
    public static final RegistryValue<Ability> HYPER_CUTTER = RegistryValue.of(Ability.class, "hypercutter");
    public static final RegistryValue<Ability> ICE_BODY = RegistryValue.of(Ability.class, "icebody");
    public static final RegistryValue<Ability> ICE_FACE = RegistryValue.of(Ability.class, "iceface");
    public static final RegistryValue<Ability> ICE_SCALES = RegistryValue.of(Ability.class, "icescales");
    public static final RegistryValue<Ability> ILLUMINATE = RegistryValue.of(Ability.class, "illuminate");
    public static final RegistryValue<Ability> ILLUSION = RegistryValue.of(Ability.class, "illusion");
    public static final RegistryValue<Ability> IMMUNITY = RegistryValue.of(Ability.class, "immunity");
    public static final RegistryValue<Ability> IMPOSTER = RegistryValue.of(Ability.class, "imposter");
    public static final RegistryValue<Ability> INFILTRATOR = RegistryValue.of(Ability.class, "infiltrator");
    public static final RegistryValue<Ability> INNARDS_OUT = RegistryValue.of(Ability.class, "innardsout");
    public static final RegistryValue<Ability> INNER_FOCUS = RegistryValue.of(Ability.class, "innerfocus");
    public static final RegistryValue<Ability> INSOMNIA = RegistryValue.of(Ability.class, "insomnia");
    public static final RegistryValue<Ability> INTIMIDATE = RegistryValue.of(Ability.class, "intimidate");
    public static final RegistryValue<Ability> INTREPID_SWORD = RegistryValue.of(Ability.class, "intrepidsword");
    public static final RegistryValue<Ability> IRON_BARBS = RegistryValue.of(Ability.class, "ironbarbs");
    public static final RegistryValue<Ability> IRON_FIST = RegistryValue.of(Ability.class, "ironfist");
    public static final RegistryValue<Ability> JUSTIFIED = RegistryValue.of(Ability.class, "justified");
    public static final RegistryValue<Ability> KEEN_EYE = RegistryValue.of(Ability.class, "keeneye");
    public static final RegistryValue<Ability> KLUTZ = RegistryValue.of(Ability.class, "klutz");
    public static final RegistryValue<Ability> LEAF_GUARD = RegistryValue.of(Ability.class, "leafguard");
    public static final RegistryValue<Ability> LEVITATE = RegistryValue.of(Ability.class, "levitate");
    public static final RegistryValue<Ability> LIBERO = RegistryValue.of(Ability.class, "libero");
    public static final RegistryValue<Ability> LIGHT_METAL = RegistryValue.of(Ability.class, "lightmetal");
    public static final RegistryValue<Ability> LIGHTNING_ROD = RegistryValue.of(Ability.class, "lightningrod");
    public static final RegistryValue<Ability> LIMBER = RegistryValue.of(Ability.class, "limber");
    public static final RegistryValue<Ability> LINGERING_AROMA = RegistryValue.of(Ability.class, "lingeringaroma");
    public static final RegistryValue<Ability> LIQUID_OOZE = RegistryValue.of(Ability.class, "liquidooze");
    public static final RegistryValue<Ability> LIQUID_VOICE = RegistryValue.of(Ability.class, "liquidvoice");
    public static final RegistryValue<Ability> LONG_REACH = RegistryValue.of(Ability.class, "longreach");
    public static final RegistryValue<Ability> MAGIC_BOUNCE = RegistryValue.of(Ability.class, "magicbounce");
    public static final RegistryValue<Ability> MAGIC_GUARD = RegistryValue.of(Ability.class, "magicguard");
    public static final RegistryValue<Ability> MAGICIAN = RegistryValue.of(Ability.class, "magician");
    public static final RegistryValue<Ability> MAGMA_ARMOR = RegistryValue.of(Ability.class, "magmaarmor");
    public static final RegistryValue<Ability> MAGNET_PULL = RegistryValue.of(Ability.class, "magnetpull");
    public static final RegistryValue<Ability> MARVEL_SCALE = RegistryValue.of(Ability.class, "marvelscale");
    public static final RegistryValue<Ability> MEGA_LAUNCHER = RegistryValue.of(Ability.class, "megalauncher");
    public static final RegistryValue<Ability> MERCILESS = RegistryValue.of(Ability.class, "merciless");
    public static final RegistryValue<Ability> MIMICRY = RegistryValue.of(Ability.class, "mimicry");
    public static final RegistryValue<Ability> MINDS_EYE = RegistryValue.of(Ability.class, "mindseye");
    public static final RegistryValue<Ability> MINUS = RegistryValue.of(Ability.class, "minus");
    public static final RegistryValue<Ability> MIRROR_ARMOR = RegistryValue.of(Ability.class, "mirrorarmor");
    public static final RegistryValue<Ability> MISTY_SURGE = RegistryValue.of(Ability.class, "mistysurge");
    public static final RegistryValue<Ability> MOLD_BREAKER = RegistryValue.of(Ability.class, "moldbreaker");
    public static final RegistryValue<Ability> MOODY = RegistryValue.of(Ability.class, "moody");
    public static final RegistryValue<Ability> MOTOR_DRIVE = RegistryValue.of(Ability.class, "motordrive");
    public static final RegistryValue<Ability> MOXIE = RegistryValue.of(Ability.class, "moxie");
    public static final RegistryValue<Ability> MULTISCALE = RegistryValue.of(Ability.class, "multiscale");
    public static final RegistryValue<Ability> MULTITYPE = RegistryValue.of(Ability.class, "multitype");
    public static final RegistryValue<Ability> MUMMY = RegistryValue.of(Ability.class, "mummy");
    public static final RegistryValue<Ability> MYCELIUM_MIGHT = RegistryValue.of(Ability.class, "myceliummight");
    public static final RegistryValue<Ability> NATURAL_CURE = RegistryValue.of(Ability.class, "naturalcure");
    public static final RegistryValue<Ability> NEUROFORCE = RegistryValue.of(Ability.class, "neuroforce");
    public static final RegistryValue<Ability> NEUTRALIZING_GAS = RegistryValue.of(Ability.class, "neutralizinggas");
    public static final RegistryValue<Ability> NO_GUARD = RegistryValue.of(Ability.class, "noguard");
    public static final RegistryValue<Ability> NORMALIZE = RegistryValue.of(Ability.class, "normalize");
    public static final RegistryValue<Ability> OBLIVIOUS = RegistryValue.of(Ability.class, "oblivious");
    public static final RegistryValue<Ability> OPPORTUNIST = RegistryValue.of(Ability.class, "opportunist");
    public static final RegistryValue<Ability> ORICHALCUM_PULSE = RegistryValue.of(Ability.class, "orichalcumpulse");
    public static final RegistryValue<Ability> OVERCOAT = RegistryValue.of(Ability.class, "overcoat");
    public static final RegistryValue<Ability> OVERGROW = RegistryValue.of(Ability.class, "overgrow");
    public static final RegistryValue<Ability> OWN_TEMPO = RegistryValue.of(Ability.class, "owntempo");
    public static final RegistryValue<Ability> PARENTAL_BOND = RegistryValue.of(Ability.class, "parentalbond");
    public static final RegistryValue<Ability> PASTEL_VEIL = RegistryValue.of(Ability.class, "pastelveil");
    public static final RegistryValue<Ability> PERISH_BODY = RegistryValue.of(Ability.class, "perishbody");
    public static final RegistryValue<Ability> PICKPOCKET = RegistryValue.of(Ability.class, "pickpocket");
    public static final RegistryValue<Ability> PICKUP = RegistryValue.of(Ability.class, "pickup");
    public static final RegistryValue<Ability> PIXILATE = RegistryValue.of(Ability.class, "pixilate");
    public static final RegistryValue<Ability> PLUS = RegistryValue.of(Ability.class, "plus");
    public static final RegistryValue<Ability> POISON_HEAL = RegistryValue.of(Ability.class, "poisonheal");
    public static final RegistryValue<Ability> POISON_POINT = RegistryValue.of(Ability.class, "poisonpoint");
    public static final RegistryValue<Ability> POISON_TOUCH = RegistryValue.of(Ability.class, "poisontouch");
    public static final RegistryValue<Ability> POWER_CONSTRUCT = RegistryValue.of(Ability.class, "powerconstruct");
    public static final RegistryValue<Ability> POWER_OF_ALCHEMY = RegistryValue.of(Ability.class, "powerofalchemy");
    public static final RegistryValue<Ability> POWER_SPOT = RegistryValue.of(Ability.class, "powerspot");
    public static final RegistryValue<Ability> PRANKSTER = RegistryValue.of(Ability.class, "prankster");
    public static final RegistryValue<Ability> PRESSURE = RegistryValue.of(Ability.class, "pressure");
    public static final RegistryValue<Ability> PRIMORDIAL_SEA = RegistryValue.of(Ability.class, "primordialsea");
    public static final RegistryValue<Ability> PRISM_ARMOR = RegistryValue.of(Ability.class, "prismarmor");
    public static final RegistryValue<Ability> PROPELLER_TAIL = RegistryValue.of(Ability.class, "propellertail");
    public static final RegistryValue<Ability> PROTOSYNTHESIS = RegistryValue.of(Ability.class, "protosynthesis");
    public static final RegistryValue<Ability> PROTEAN = RegistryValue.of(Ability.class, "protean");
    public static final RegistryValue<Ability> PSYCHIC_SURGE = RegistryValue.of(Ability.class, "psychicsurge");
    public static final RegistryValue<Ability> PUNK_ROCK = RegistryValue.of(Ability.class, "punkrock");
    public static final RegistryValue<Ability> PURE_POWER = RegistryValue.of(Ability.class, "purepower");
    public static final RegistryValue<Ability> QUARK_DRIVE = RegistryValue.of(Ability.class, "quarkdrive");
    public static final RegistryValue<Ability> PURIFYING_SALT = RegistryValue.of(Ability.class, "purifyingsalt");
    public static final RegistryValue<Ability> QUEENLY_MAJESTY = RegistryValue.of(Ability.class, "queenlymajesty");
    public static final RegistryValue<Ability> QUICK_DRAW = RegistryValue.of(Ability.class, "quickdraw");
    public static final RegistryValue<Ability> QUICK_FEET = RegistryValue.of(Ability.class, "quickfeet");
    public static final RegistryValue<Ability> RAIN_DISH = RegistryValue.of(Ability.class, "raindish");
    public static final RegistryValue<Ability> RATTLED = RegistryValue.of(Ability.class, "rattled");
    public static final RegistryValue<Ability> RECEIVER = RegistryValue.of(Ability.class, "receiver");
    public static final RegistryValue<Ability> RECKLESS = RegistryValue.of(Ability.class, "reckless");
    public static final RegistryValue<Ability> REFRIGERATE = RegistryValue.of(Ability.class, "refrigerate");
    public static final RegistryValue<Ability> REGENERATOR = RegistryValue.of(Ability.class, "regenerator");
    public static final RegistryValue<Ability> RIPEN = RegistryValue.of(Ability.class, "ripen");
    public static final RegistryValue<Ability> RIVALRY = RegistryValue.of(Ability.class, "rivalry");
    public static final RegistryValue<Ability> R_K_S_SYSTEM = RegistryValue.of(Ability.class, "rkssystem");
    public static final RegistryValue<Ability> ROCK_HEAD = RegistryValue.of(Ability.class, "rockhead");
    public static final RegistryValue<Ability> ROCKY_PAYLOAD = RegistryValue.of(Ability.class, "rockypayload");
    public static final RegistryValue<Ability> ROUGH_SKIN = RegistryValue.of(Ability.class, "roughskin");
    public static final RegistryValue<Ability> RUN_AWAY = RegistryValue.of(Ability.class, "runaway");
    public static final RegistryValue<Ability> SAND_FORCE = RegistryValue.of(Ability.class, "sandforce");
    public static final RegistryValue<Ability> SAND_RUSH = RegistryValue.of(Ability.class, "sandrush");
    public static final RegistryValue<Ability> SAND_SPIT = RegistryValue.of(Ability.class, "sandspit");
    public static final RegistryValue<Ability> SAND_STREAM = RegistryValue.of(Ability.class, "sandstream");
    public static final RegistryValue<Ability> SAND_VEIL = RegistryValue.of(Ability.class, "sandveil");
    public static final RegistryValue<Ability> SAP_SIPPER = RegistryValue.of(Ability.class, "sapsipper");
    public static final RegistryValue<Ability> SCHOOLING = RegistryValue.of(Ability.class, "schooling");
    public static final RegistryValue<Ability> SCRAPPY = RegistryValue.of(Ability.class, "scrappy");
    public static final RegistryValue<Ability> SCREEN_CLEANER = RegistryValue.of(Ability.class, "screencleaner");
    public static final RegistryValue<Ability> SERENE_GRACE = RegistryValue.of(Ability.class, "serenegrace");
    public static final RegistryValue<Ability> SEED_SOWER = RegistryValue.of(Ability.class, "seedsower");
    public static final RegistryValue<Ability> SHADOW_SHIELD = RegistryValue.of(Ability.class, "shadowshield");
    public static final RegistryValue<Ability> SHADOW_TAG = RegistryValue.of(Ability.class, "shadowtag");
    public static final RegistryValue<Ability> SHARPNESS = RegistryValue.of(Ability.class, "sharpness");
    public static final RegistryValue<Ability> SHED_SKIN = RegistryValue.of(Ability.class, "shedskin");
    public static final RegistryValue<Ability> SHEER_FORCE = RegistryValue.of(Ability.class, "sheerforce");
    public static final RegistryValue<Ability> SHELL_ARMOUR = RegistryValue.of(Ability.class, "shellarmour");
    public static final RegistryValue<Ability> SHIELD_DUST = RegistryValue.of(Ability.class, "shielddust");
    public static final RegistryValue<Ability> SHIELDS_DOWN = RegistryValue.of(Ability.class, "shieldsdown");
    public static final RegistryValue<Ability> SIMPLE = RegistryValue.of(Ability.class, "simple");
    public static final RegistryValue<Ability> SKILL_LINK = RegistryValue.of(Ability.class, "skilllink");
    public static final RegistryValue<Ability> SLOW_START = RegistryValue.of(Ability.class, "slowstart");
    public static final RegistryValue<Ability> SLUSH_RUSH = RegistryValue.of(Ability.class, "slushrush");
    public static final RegistryValue<Ability> SNIPER = RegistryValue.of(Ability.class, "sniper");
    public static final RegistryValue<Ability> SNOW_CLOAK = RegistryValue.of(Ability.class, "snowcloak");
    public static final RegistryValue<Ability> SNOW_WARNING = RegistryValue.of(Ability.class, "snowwarning");
    public static final RegistryValue<Ability> SOLAR_POWER = RegistryValue.of(Ability.class, "solarpower");
    public static final RegistryValue<Ability> SOLID_ROCK = RegistryValue.of(Ability.class, "solidrock");
    public static final RegistryValue<Ability> SOUL_HEART = RegistryValue.of(Ability.class, "soulheart");
    public static final RegistryValue<Ability> SOUNDPROOF = RegistryValue.of(Ability.class, "soundproof");
    public static final RegistryValue<Ability> SPEED_BOOST = RegistryValue.of(Ability.class, "speedboost");
    public static final RegistryValue<Ability> STAKEOUT = RegistryValue.of(Ability.class, "stakeout");
    public static final RegistryValue<Ability> STALL = RegistryValue.of(Ability.class, "stall");
    public static final RegistryValue<Ability> STALWART = RegistryValue.of(Ability.class, "stalwart");
    public static final RegistryValue<Ability> STAMINA = RegistryValue.of(Ability.class, "stamina");
    public static final RegistryValue<Ability> STANCE_CHANGE = RegistryValue.of(Ability.class, "stancechange");
    public static final RegistryValue<Ability> STATIC = RegistryValue.of(Ability.class, "static");
    public static final RegistryValue<Ability> STEADFAST = RegistryValue.of(Ability.class, "steadfast");
    public static final RegistryValue<Ability> STEAM_ENGINE = RegistryValue.of(Ability.class, "steamengine");
    public static final RegistryValue<Ability> STEELWORKER = RegistryValue.of(Ability.class, "steelworker");
    public static final RegistryValue<Ability> STEELY_SPIRIT = RegistryValue.of(Ability.class, "steelyspirit");
    public static final RegistryValue<Ability> STENCH = RegistryValue.of(Ability.class, "stench");
    public static final RegistryValue<Ability> STICKY_HOLD = RegistryValue.of(Ability.class, "stickyhold");
    public static final RegistryValue<Ability> STORM_DRAIN = RegistryValue.of(Ability.class, "stormdrain");
    public static final RegistryValue<Ability> STRONG_JAW = RegistryValue.of(Ability.class, "strongjaw");
    public static final RegistryValue<Ability> STURDY = RegistryValue.of(Ability.class, "sturdy");
    public static final RegistryValue<Ability> SUCTION_CUPS = RegistryValue.of(Ability.class, "suctioncups");
    public static final RegistryValue<Ability> SUPER_LUCK = RegistryValue.of(Ability.class, "superluck");
    public static final RegistryValue<Ability> SUPREME_OVERLORD = RegistryValue.of(Ability.class, "supremeoverlord");
    public static final RegistryValue<Ability> SURGE_SURFER = RegistryValue.of(Ability.class, "surgesurfer");
    public static final RegistryValue<Ability> SUPERSWEET_SYRUP = RegistryValue.of(Ability.class, "supersweet_syrup");
    public static final RegistryValue<Ability> SWARM = RegistryValue.of(Ability.class, "swarm");
    public static final RegistryValue<Ability> SWEET_VEIL = RegistryValue.of(Ability.class, "sweetveil");
    public static final RegistryValue<Ability> SWIFT_SWIM = RegistryValue.of(Ability.class, "swiftswim");
    public static final RegistryValue<Ability> SWORD_OF_RUIN = RegistryValue.of(Ability.class, "swordofruin");
    public static final RegistryValue<Ability> SYMBIOSIS = RegistryValue.of(Ability.class, "symbiosis");
    public static final RegistryValue<Ability> SYNCHRONIZE = RegistryValue.of(Ability.class, "synchronize");
    public static final RegistryValue<Ability> TABLETS_OF_RUIN = RegistryValue.of(Ability.class, "tabletsofruin");
    public static final RegistryValue<Ability> TANGLED_FEET = RegistryValue.of(Ability.class, "tangledfeet");
    public static final RegistryValue<Ability> TANGLING_HAIR = RegistryValue.of(Ability.class, "tanglinghair");
    public static final RegistryValue<Ability> TECHNICIAN = RegistryValue.of(Ability.class, "technician");
    public static final RegistryValue<Ability> TELEPATHY = RegistryValue.of(Ability.class, "telepathy");
    public static final RegistryValue<Ability> TERAVOLT = RegistryValue.of(Ability.class, "teravolt");
    public static final RegistryValue<Ability> THERMAL_EXCHANGE = RegistryValue.of(Ability.class, "thermalexchange");
    public static final RegistryValue<Ability> THICK_FAT = RegistryValue.of(Ability.class, "thickfat");
    public static final RegistryValue<Ability> TINTED_LENS = RegistryValue.of(Ability.class, "tintedlens");
    public static final RegistryValue<Ability> TORRENT = RegistryValue.of(Ability.class, "torrent");
    public static final RegistryValue<Ability> TOUGH_CLAWS = RegistryValue.of(Ability.class, "toughclaws");
    public static final RegistryValue<Ability> TOXIC_CHAIN = RegistryValue.of(Ability.class, "toxicchain");
    public static final RegistryValue<Ability> TOXIC_BOOST = RegistryValue.of(Ability.class, "toxicboost");
    public static final RegistryValue<Ability> TOXIC_DEBRIS = RegistryValue.of(Ability.class, "toxicdebris");
    public static final RegistryValue<Ability> TRACE = RegistryValue.of(Ability.class, "trace");
    public static final RegistryValue<Ability> TRANSISTOR = RegistryValue.of(Ability.class, "transistor");
    public static final RegistryValue<Ability> TRIAGE = RegistryValue.of(Ability.class, "triage");
    public static final RegistryValue<Ability> TRUANT = RegistryValue.of(Ability.class, "truant");
    public static final RegistryValue<Ability> TURBOBLAZE = RegistryValue.of(Ability.class, "turboblaze");
    public static final RegistryValue<Ability> UNAWARE = RegistryValue.of(Ability.class, "unaware");
    public static final RegistryValue<Ability> UNBURDEN = RegistryValue.of(Ability.class, "unburden");
    public static final RegistryValue<Ability> UNNERVE = RegistryValue.of(Ability.class, "unnerve");
    public static final RegistryValue<Ability> UNSEEN_FIST = RegistryValue.of(Ability.class, "unseenfist");
    public static final RegistryValue<Ability> VESSEL_OF_RUIN = RegistryValue.of(Ability.class, "vesselofruin");
    public static final RegistryValue<Ability> VICTORY_STAR = RegistryValue.of(Ability.class, "victorystar");
    public static final RegistryValue<Ability> VITAL_SPIRIT = RegistryValue.of(Ability.class, "vitalspirit");
    public static final RegistryValue<Ability> VOLT_ABSORB = RegistryValue.of(Ability.class, "voltabsorb");
    public static final RegistryValue<Ability> WANDERING_SPIRIT = RegistryValue.of(Ability.class, "wanderingspirit");
    public static final RegistryValue<Ability> WATER_ABSORB = RegistryValue.of(Ability.class, "waterabsorb");
    public static final RegistryValue<Ability> WATER_BUBBLE = RegistryValue.of(Ability.class, "waterbubble");
    public static final RegistryValue<Ability> WATER_COMPACTION = RegistryValue.of(Ability.class, "watercompaction");
    public static final RegistryValue<Ability> WATER_VEIL = RegistryValue.of(Ability.class, "waterveil");
    public static final RegistryValue<Ability> WEAK_ARMOR = RegistryValue.of(Ability.class, "weakarmor");
    public static final RegistryValue<Ability> WELL_BAKED_BODY = RegistryValue.of(Ability.class, "wellbakedbody");
    public static final RegistryValue<Ability> WHITE_SMOKE = RegistryValue.of(Ability.class, "whitesmoke");
    public static final RegistryValue<Ability> WIMP_OUT = RegistryValue.of(Ability.class, "wimpout");
    public static final RegistryValue<Ability> WIND_RIDER = RegistryValue.of(Ability.class, "windrider");
    public static final RegistryValue<Ability> WIND_POWER = RegistryValue.of(Ability.class, "windpower");
    public static final RegistryValue<Ability> WONDER_GUARD = RegistryValue.of(Ability.class, "wonderguard");
    public static final RegistryValue<Ability> WONDER_SKIN = RegistryValue.of(Ability.class, "wonderskin");
    public static final RegistryValue<Ability> ZEN_MODE = RegistryValue.of(Ability.class, "zenmode");
    public static final RegistryValue<Ability> ZERO_TO_HERO = RegistryValue.of(Ability.class, "zerotohero");
    public static final RegistryValue<Ability> REVENANT = RegistryValue.of(Ability.class, "revenant");

    public static void register(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, Pixelmon.class.getClassLoader());
            if (!Ability.class.isAssignableFrom(clazz)) {
                Pixelmon.LOGGER.error("Failed to load ability at `" + className + "`. This class doesn't extend Ability interface");
                return;
            }
            Supplier<Ability> constructor = AbilityRegistry.findConstructor(className, clazz);
            if (constructor == null) {
                return;
            }
            Ability defaultInstance = constructor.get();
            String key = defaultInstance.getName().toLowerCase(Locale.ROOT);
            RegistryManager.register(key, defaultInstance, Ability.class);
            REGISTERED_ABILITIES.put(key, new AbilityData(defaultInstance.getName(), className, constructor, defaultInstance));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Pixelmon.LOGGER.error("Failed to load ability at `" + className + "`. Skipping load for error:");
            e.printStackTrace();
        }
    }

    private static Supplier<Ability> findConstructor(String className, Class<?> clazz) throws NoSuchMethodException {
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        if (constructor == null) {
            Pixelmon.LOGGER.error("Failed to load ability at `" + className + "`. This class doesn't have an empty constructor!");
            return null;
        }
        return () -> {
            try {
                return (Ability)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Pixelmon.LOGGER.error("There was an error during construction of " + className);
                e.printStackTrace();
                return null;
            }
        };
    }

    public static Optional<Ability> getAbility(String name) {
        if (!REGISTERED_ABILITIES.containsKey(name.toLowerCase(Locale.ROOT))) {
            return Optional.empty();
        }
        return Optional.ofNullable(REGISTERED_ABILITIES.get(name.toLowerCase(Locale.ROOT)).getInstance());
    }

    public static Optional<Ability> getNewAbility(String name) {
        AbilityData instance = REGISTERED_ABILITIES.get(name.toLowerCase(Locale.ROOT));
        if (instance == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(instance.getConstructor().get());
    }

    public static boolean ignoreAbility(PixelmonWrapper pokemon, BattleController bc) {
        NeutralizingGas neutralizingGas;
        if (pokemon == null) {
            return false;
        }
        if (bc == null) {
            return pokemon.hasStatus(StatusType.GastroAcid);
        }
        Optional<Ability> optionalNeutralizingGas = bc.getAbilityIfPresent(NeutralizingGas.class);
        if (optionalNeutralizingGas.isPresent() && !(neutralizingGas = (NeutralizingGas)optionalNeutralizingGas.get()).isSuppressed() && NeutralizingGas.isAbilityDisabled(pokemon.getBattleAbility(false))) {
            return true;
        }
        return pokemon.hasStatus(StatusType.GastroAcid);
    }

    public static boolean ignoreAbility(PixelmonWrapper user, PixelmonWrapper opponent) {
        if (AbilityRegistry.ignoreAbility(opponent, opponent.bc)) {
            return true;
        }
        if (opponent.getBattleAbility(false) != null && !opponent.getBattleAbility(false).canBeIgnored()) {
            return false;
        }
        if (user == null) {
            return false;
        }
        Ability userAbility = user.getBattleAbility();
        if (user.attack != null && user.attack.getMove().getIgnoresAbilities() && !user.isTempAttack && user != opponent) {
            return true;
        }
        if (userAbility instanceof MoldBreaker && opponent.getBattleAbility(false) instanceof AngerPoint) {
            return false;
        }
        return userAbility instanceof MoldBreaker || userAbility instanceof Teravolt || userAbility instanceof Turboblaze || userAbility instanceof MyceliumMight && user.attack != null && user.attack.getAttackCategory().equals((Object)AttackCategory.STATUS);
    }

    public static void writeToBuffer(FriendlyByteBuf buf) {
        buf.writeInt(REGISTERED_ABILITIES.size());
        for (AbilityData ability : REGISTERED_ABILITIES.values()) {
            ability.writeToBuffer(buf);
        }
    }

    public static void readFromBuffer(FriendlyByteBuf buf) {
        AbilityRegistry.reset();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            AbilityRegistry.register(buf.m_130277_());
        }
    }

    private static void reset() {
        REGISTERED_ABILITIES.clear();
    }

    public static final class AbilityData {
        private final String name;
        private final String classPath;
        private final Supplier<Ability> constructor;
        private final Ability instance;

        public AbilityData(String name, String classPath, Supplier<Ability> constructor, Ability instance) {
            this.name = name;
            this.classPath = classPath;
            this.constructor = constructor;
            this.instance = instance;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<Ability> getConstructor() {
            return this.constructor;
        }

        public Ability getInstance() {
            return this.instance;
        }

        public void writeToBuffer(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.classPath);
        }
    }
}

