/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Defeatist;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.SlowStart;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Truant;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.RarityTweak;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.ArrayHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.StatsEffect;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.tools.MutableBoolean;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public interface Ability
extends ITranslatable,
RarityTweak {
    public String getName();

    default public void startMove(PixelmonWrapper user) {
    }

    default public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        return true;
    }

    default public int modifyDamageUser(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return damage;
    }

    default public int modifyDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return damage;
    }

    default public int modifyDamageIncludeFixed(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return damage;
    }

    default public int modifySelfDamage(int damage, PixelmonWrapper pw, Attack a) {
        return damage;
    }

    default public int modifyConfusionDamage(int damage, PixelmonWrapper pw) {
        return damage;
    }

    default public int modifyDamage(int damage, PixelmonWrapper user, PixelmonWrapper target, DamageTypeEnum type, @Nullable Attack attack, @Nullable Ability ability) {
        return damage;
    }

    default public int modifyDamageTeammate(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return damage;
    }

    default public void tookDamageUser(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
    }

    default public void tookDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
    }

    default public void tookDamageTargetAfterMove(PixelmonWrapper user, PixelmonWrapper target, Attack a, float damage) {
    }

    default public int[] modifyPowerAndAccuracyUser(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return new int[]{power, accuracy};
    }

    default public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return new int[]{power, accuracy};
    }

    default public int[] modifyPowerAndAccuracyTeammate(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return new int[]{power, accuracy};
    }

    default public void modifyMoveEffects(PixelmonWrapper user, PixelmonWrapper target, List<EffectBase> effects) {
    }

    default public void modifyMoveEffectChanceUser(PixelmonWrapper user, PixelmonWrapper target, List<EffectBase> effects) {
    }

    default public void modifyMoveEffectChanceTarget(PixelmonWrapper user, PixelmonWrapper target, List<EffectBase> effects) {
    }

    default public void beforeSwitch(PixelmonWrapper newPokemon) {
    }

    default public void applySwitchInEffect(PixelmonWrapper newPokemon) {
    }

    default public void applyPostSwitchEffect(PixelmonWrapper newPokemon) {
    }

    default public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
    }

    default public void applyFoeSwitchInEffect(PixelmonWrapper user, PixelmonWrapper target, PixelmonWrapper former) {
    }

    default public void applyAllySwitchInEffect(PixelmonWrapper user, PixelmonWrapper target) {
    }

    default public void applySwitchReplaceEffect(PixelmonWrapper newPokemon, PixelmonWrapper oldPokemon) {
    }

    default public void applyDynamaxEffect(PixelmonWrapper pokemon) {
    }

    default public void applyEndOfBattleEffect(PixelmonWrapper pokemon) {
    }

    default public boolean doesContactAttackMakeContact(PixelmonWrapper user, Attack a) {
        return true;
    }

    default public boolean preventsItemRemoval(PixelmonWrapper thief, PixelmonWrapper target) {
        return false;
    }

    default public void applyStartOfBattleHeadOfPartyEffect(PixelmonWrapper user, PixelmonWrapper target) {
    }

    default public void applyStartOfBattleEffect(PixelmonWrapper user) {
    }

    default public void applyEffectOnContactUser(PixelmonWrapper user, PixelmonWrapper target) {
    }

    default public void applyEffectOnContactTarget(PixelmonWrapper user, PixelmonWrapper target) {
    }

    default public void applyEffectOnContactTargetLate(PixelmonWrapper user, PixelmonWrapper target) {
    }

    default public void onStatIncrease(PixelmonWrapper pokemon, PixelmonWrapper affected, int amount, BattleStatsType stat) {
    }

    default public void onStatDecrease(PixelmonWrapper pokemon, PixelmonWrapper affected, int amount, BattleStatsType stat) {
    }

    default public void applyEffectOnStatModified(PixelmonWrapper pokemon, PixelmonWrapper affected) {
    }

    default public double preProcessAttackStatBeforeDamageCalc(PixelmonWrapper attacker, double attackStat) {
        return attackStat;
    }

    default public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        return stats;
    }

    default public int[] modifyStatsTeammate(PixelmonWrapper pokemon, int[] stats) {
        return stats;
    }

    default public int[] modifyStatsOther(PixelmonWrapper pokemon, int[] stats) {
        return stats;
    }

    default public int[] modifyStatsCancellable(PixelmonWrapper user, int[] stats) {
        return stats;
    }

    default public int[] modifyStatsCancellableTeammate(PixelmonWrapper pokemon, int[] stats) {
        return stats;
    }

    default public int[] modifyStatsCancellableOther(PixelmonWrapper user, PixelmonWrapper target, int[] stats) {
        return stats;
    }

    default public void applyRepeatedEffect(PixelmonWrapper pokemon) {
    }

    default public void applyRepeatedEffectAfterStatus(PixelmonWrapper pokemon) {
    }

    default public boolean allowsStatChange(PixelmonWrapper pokemon, PixelmonWrapper user, StatsEffect e) {
        return true;
    }

    default public boolean allowsStatChangeTeammate(PixelmonWrapper pokemon, PixelmonWrapper target, PixelmonWrapper user, StatsEffect e) {
        return true;
    }

    default public boolean allowsAttack(PixelmonWrapper pokemon, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return true;
    }

    default public boolean allowsOutgoingAttack(PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        return true;
    }

    default public boolean allowsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
        return true;
    }

    default public boolean allowsIncomingAttackTeammate(PixelmonWrapper pokemon, PixelmonWrapper target, PixelmonWrapper user, Attack a) {
        return true;
    }

    default public void allowsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
    }

    default public void preProcessAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
    }

    default public void preProcessAttackUser(PixelmonWrapper pokemon, PixelmonWrapper target, Attack a) {
    }

    default public void postProcessAttackUser(PixelmonWrapper pokemon, PixelmonWrapper target, Attack a) {
    }

    default public void postProcessAttack(PixelmonWrapper pokemon, PixelmonWrapper user, Attack a) {
    }

    default public void postProcessAttackOther(PixelmonWrapper pokemon, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
    }

    default public void postProcessAttackUserHitOrMiss(PixelmonWrapper pokemon, PixelmonWrapper target, Attack a) {
    }

    default public boolean doesAttackUserIgnoreProtect(PixelmonWrapper pokemon, PixelmonWrapper target, Attack a) {
        return false;
    }

    default public float adjustCriticalHitChance(PixelmonWrapper pokemon, PixelmonWrapper target, Attack a, float critChance) {
        return critChance;
    }

    default public boolean preventsCriticalHits(PixelmonWrapper opponent) {
        return false;
    }

    default public boolean allowsStatus(StatusType status, PixelmonWrapper pokemon, PixelmonWrapper user) {
        return true;
    }

    default public boolean allowsStatusTeammate(StatusType status, PixelmonWrapper pokemon, PixelmonWrapper target, PixelmonWrapper user) {
        return true;
    }

    default public double modifyStab(double stab) {
        return stab;
    }

    default public Element modifyType(PixelmonWrapper pw, Attack attack) {
        return null;
    }

    default public float modifyPriority(PixelmonWrapper pokemon, float priority, MutableBoolean triggered) {
        return priority;
    }

    default public boolean stopsSwitching(PixelmonWrapper user, PixelmonWrapper opponent) {
        return false;
    }

    default public boolean stopsForcedSwitches(PixelmonWrapper user, PixelmonWrapper cause) {
        return false;
    }

    default public float modifyWeight(float initWeight) {
        return initWeight;
    }

    default public List<Element> getEffectiveTypes(PixelmonWrapper user, PixelmonWrapper target) {
        return target.type;
    }

    default public void onStatusAdded(StatusBase status, PixelmonWrapper user, PixelmonWrapper opponent) {
    }

    default public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
    }

    default public boolean ignoreWeather() {
        return false;
    }

    default public boolean redirectAttack(PixelmonWrapper user, PixelmonWrapper targetAlly, Attack attack) {
        return false;
    }

    default public boolean preventsRedirection(PixelmonWrapper user, Attack attack) {
        return false;
    }

    default public void onItemConsumed(PixelmonWrapper pokemon, PixelmonWrapper consumer, HeldItem heldItem) {
    }

    default public void onBerryEaten(PixelmonWrapper pokemon, PixelmonWrapper consumer, HeldItem heldItem) {
    }

    default public void onAbilityLost(PixelmonWrapper pokemon) {
    }

    default public void onAllyFaint(PixelmonWrapper pokemon, PixelmonWrapper fainted, PixelmonWrapper source) {
    }

    default public void onSelfFaint(PixelmonWrapper pokemon, PixelmonWrapper source) {
    }

    default public void onFoeFaint(PixelmonWrapper pokemon, PixelmonWrapper fainted, PixelmonWrapper source) {
    }

    default public boolean needNewInstance() {
        return false;
    }

    default public boolean isNegativeAbility() {
        return this instanceof Defeatist || this instanceof SlowStart || this instanceof Truant;
    }

    default public void onWeatherChange(PixelmonWrapper pw, Weather weather) {
    }

    default public void onTerrainSwitch(BattleController bc, PixelmonWrapper user, Terrain terrain) {
    }

    default public boolean canBeIgnored() {
        return true;
    }

    default public boolean canBeCopied() {
        return true;
    }

    default public boolean canBeDisabled() {
        return true;
    }

    default public boolean canPerish() {
        return true;
    }

    default public boolean isAbility(Class<? extends Ability> ability) {
        return ability != null && ability.isInstance(this);
    }

    default public boolean isAbility(Ability ability) {
        return ability != null && this.isAbility((Class<? extends Ability>)ability.getClass());
    }

    default public boolean isAbility(Class<? extends Ability> ... abilities) {
        return ArrayHelper.contains(abilities, this.getClass());
    }

    default public boolean isAbility(Optional<Ability> ... abilities) {
        for (Optional<Ability> ability : abilities) {
            if (!ability.isPresent() || !Objects.equals(ability.get(), this)) continue;
            return true;
        }
        return false;
    }

    default public boolean isAbility(RegistryValue<Ability> ... abilities) {
        for (RegistryValue<Ability> ability : abilities) {
            if (!ability.isInitialized() || !Objects.equals(ability.get(), this)) continue;
            return true;
        }
        return false;
    }

    public Ability getNewInstance();

    default public void sendActivatedMessage(PixelmonWrapper pw) {
        pw.bc.sendToAll("pixelmon.abilities.activated", pw.getNickname(), this.getTranslatedName());
    }

    default public void onItemChanged(PixelmonWrapper pw, HeldItem newItem) {
    }

    @Override
    default public float getMultiplier(AbstractSpawner spawner, SpawnInfo spawnInfo, float sum, float rarity) {
        return 1.0f;
    }

    default public int onHealed(PixelmonWrapper pw, int heal) {
        return heal;
    }

    default public boolean alwaysConsideredDamaged(PixelmonWrapper pw) {
        return false;
    }
}

