/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public interface PokemonProxy<T extends Pokemon> {
    public T create(UUID var1);

    default public T create(Species species) {
        Pokemon pokemon = new Pokemon();
        pokemon.setSpecies(species, false);
        pokemon.initialize(InitializeCategory.INTRINSIC_FORCEFUL, InitializeCategory.SPECIES);
        return (T)pokemon;
    }

    default public T create(PokemonSpecification spec) {
        return (T)spec.create();
    }

    default public T create(CompoundTag nbt) {
        UUID uuid = null;
        uuid = nbt.m_128441_("UUID") ? nbt.m_128342_("UUID") : UUID.randomUUID();
        T pokemon = this.create(uuid);
        ((Pokemon)pokemon).readFromNBT(nbt);
        return pokemon;
    }

    default public T copy(Pokemon pokemon) {
        return (T)PokemonBuilder.copy(pokemon).build();
    }
}

