/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class PokemonBase
implements ITranslatable {
    public static final DataSync<? extends AbstractBaseEntity, PokemonBase> SYNC_POKEMON_BASE = new DataSync<AbstractBaseEntity, PokemonBase>(AbstractBaseEntity.class, PixelmonDataSerializers.POKEMON_BASE, (abstractBaseEntity, pokemonBase) -> {
        abstractBaseEntity.getPokemon().species = pokemonBase.species;
        abstractBaseEntity.getPokemon().form = pokemonBase.form;
        abstractBaseEntity.getPokemon().gender = pokemonBase.gender;
        abstractBaseEntity.getPokemon().palette = pokemonBase.palette;
        abstractBaseEntity.getPokemon().ball = pokemonBase.ball;
        abstractBaseEntity.getPokemon().eggCycles = pokemonBase.eggCycles;
    }, (pokemon, pokemonBase) -> {
        pokemon.species = pokemonBase.species;
        pokemon.form = pokemonBase.form;
        pokemon.gender = pokemonBase.gender;
        pokemon.palette = pokemonBase.palette;
        pokemon.ball = pokemonBase.ball;
        pokemon.eggCycles = pokemonBase.eggCycles;
    });
    protected Species species = PixelmonSpecies.MISSINGNO.getValueUnsafe();
    protected Stats form = null;
    protected Gender gender = null;
    protected PaletteProperties palette = null;
    protected PokeBall ball = PokeBallRegistry.POKE_BALL.getValueUnsafe();
    protected int eggCycles = -1;

    public PokemonBase() {
    }

    public PokemonBase(Pokemon pokemon) {
        this(pokemon.species, pokemon.form, pokemon.palette, pokemon.gender, pokemon.eggCycles, pokemon.ball);
    }

    public PokemonBase(Species pokemon) {
        this(pokemon, pokemon.getDefaultForm());
    }

    public PokemonBase(Species species, Stats form) {
        this(species, form, form.getDefaultGender());
    }

    public PokemonBase(Species species, Stats form, Gender gender) {
        this(species, form, form.getGenderProperties(gender).getDefaultPalette(), gender);
    }

    public PokemonBase(Species species, Stats form, PaletteProperties palette, Gender gender) {
        this(species, form, palette, gender, -1, PokeBallRegistry.POKE_BALL.getValueUnsafe());
    }

    public PokemonBase(Species species, Stats form, PaletteProperties palette, Gender gender, PokeBall ball) {
        this(species, form, palette, gender, -1, ball);
    }

    public PokemonBase(Species species, Stats form, PaletteProperties palette, Gender gender, int eggCycles, PokeBall ball) {
        this.species = species;
        this.form = form;
        this.palette = palette;
        this.gender = gender;
        this.eggCycles = eggCycles;
        this.ball = ball;
    }

    public Species getSpecies() {
        return this.species;
    }

    public Stats getForm() {
        return this.form;
    }

    public boolean isDefaultForm() {
        return this.form.isDefault();
    }

    public boolean isDefaultPalette() {
        return this.getGenderProperties().isDefaultPalette(this.palette);
    }

    public Gender getGender() {
        return this.gender;
    }

    public GenderProperties getGenderProperties() {
        if (this.form == null) {
            this.form = this.species.getDefaultForm();
        }
        return this.form.getGenderProperties(this.gender);
    }

    public PaletteProperties getPalette() {
        return this.palette;
    }

    public boolean hasPalette(String palette) {
        return this.gender.hasPalette(this.form, palette);
    }

    public boolean isPalette(String palette) {
        return this.palette != null && this.palette.getName().equalsIgnoreCase(palette);
    }

    public boolean isShiny() {
        return this.isPalette("shiny");
    }

    public boolean isPokemon(Species ... species) {
        for (Species specie : species) {
            if (!Objects.equals(this.species, specie)) continue;
            return true;
        }
        return false;
    }

    public boolean isPokemon(Collection<Species> species) {
        for (Species specie : species) {
            if (!Objects.equals(this.species, specie)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isPokemonOptional(Optional<Species> ... species) {
        for (Optional<Species> specie : species) {
            if (!specie.isPresent() || !this.isPokemon(specie.get())) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isPokemonOptional(RegistryValue<Species> ... species) {
        for (RegistryValue<Species> specie : species) {
            if (!specie.isInitialized() || !this.isPokemon(specie.getValueUnsafe())) continue;
            return true;
        }
        return false;
    }

    public final boolean isPokemonOptional(Collection<Optional<Species>> species) {
        for (Optional<Species> specie : species) {
            if (!specie.isPresent() || !this.isPokemon(specie.get())) continue;
            return true;
        }
        return false;
    }

    public final boolean isPokemonValue(Collection<RegistryValue<Species>> species) {
        for (RegistryValue<Species> specie : species) {
            if (!specie.isInitialized() || !this.isPokemon(specie.getValueUnsafe())) continue;
            return true;
        }
        return false;
    }

    public PokeBall getBall() {
        return this.ball;
    }

    public void setBall(PokeBall ball) {
        this.ball = ball;
    }

    public void setForm(Stats form) {
        this.form = form;
    }

    public boolean setForm(String form) {
        Stats found = this.species.getForm(form);
        if (found == null) {
            return false;
        }
        this.setForm(found);
        return true;
    }

    public PokemonBase makeEgg() {
        Stats bs = this.getForm();
        this.eggCycles = bs.getEggCycles() <= 0 ? 21 : bs.getEggCycles();
        return this;
    }

    public boolean isEgg() {
        return this.eggCycles != -1;
    }

    public int getEggCycles() {
        return this.eggCycles;
    }

    public void setEggCycles(Integer eggCycles) {
        this.setEggCycles(eggCycles, true);
    }

    public void setEggCycles(Integer eggCycles, boolean event) {
        this.eggCycles = eggCycles;
        if (this.getEggCycles() < 0) {
            this.eggCycles = -1;
        }
    }

    public boolean setPalette(PaletteProperties palette) {
        this.palette = palette;
        return true;
    }

    public ResourceLocation getSprite() {
        if (this.isEgg()) {
            return Resources.getEggSprite(this.species, this.eggCycles);
        }
        if (this.getPalette() == null) {
            return PixelmonSpecies.MISSINGNO.getValueUnsafe().getFirstForm().getDefaultGenderProperties().getDefaultPalette().getSprite();
        }
        return this.getPalette().getSprite();
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("ndex", this.species.getDex());
        nbt.m_128359_("Variant", this.form.getName());
        nbt.m_128344_("Gender", (byte)this.getGender().ordinal());
        nbt.m_128359_("palette", this.palette == null ? this.getGenderProperties().getDefaultPalette().getName() : this.palette.getName());
        nbt.m_128359_("CaughtBall", this.ball == null ? "" : this.ball.getName());
        nbt.m_128405_("eggCycles", this.eggCycles);
        return nbt;
    }

    public static PokemonBase fromNBT(CompoundTag nbt) {
        String ball;
        PokemonBase base = new PokemonBase();
        if (nbt.m_128441_("ndex")) {
            base.species = PixelmonSpecies.fromNationalDex(nbt.m_128451_("ndex"));
        }
        base.form = nbt.m_128441_("Variant") ? base.species.getForm(nbt.m_128461_("Variant")) : base.species.getDefaultForm();
        base.gender = nbt.m_128441_("Gender") ? Gender.getGender(nbt.m_128445_("Gender")) : Gender.NONE;
        base.palette = nbt.m_128441_("palette") ? base.getGenderProperties().getPalette(nbt.m_128461_("palette")) : base.getGenderProperties().getDefaultPalette();
        base.ball = nbt.m_128441_("CaughtBall") ? ((ball = nbt.m_128461_("CaughtBall")).isEmpty() ? (nbt.m_128451_("CaughtBall") > -1 ? PokeBallRegistry.STRANGE_BALL.getValueUnsafe() : null) : PokeBallRegistry.getPokeBall(ball).orElse(PokeBallRegistry.POKE_BALL.getValueUnsafe())) : null;
        base.eggCycles = nbt.m_128441_("eggCycles") ? nbt.m_128451_("eggCycles") : -1;
        return base;
    }

    public boolean hasChild(Species species) {
        return this.getForm().hasChild(species);
    }

    public void invalidate() {
    }

    @Override
    public String getTranslationKey() {
        return this.species.getTranslationKey();
    }

    public Pokemon toPokemon() {
        Pokemon pokemon = new Pokemon();
        pokemon.species = this.species;
        pokemon.form = this.form;
        pokemon.gender = this.gender;
        pokemon.palette = this.palette;
        pokemon.eggCycles = this.eggCycles;
        pokemon.ball = this.ball;
        return pokemon;
    }
}

