/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.events.EggHatchEvent;
import com.pixelmonmod.pixelmon.api.events.HeldItemChangedEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonFaintEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.events.pokemon.SetLevellingEvent;
import com.pixelmonmod.pixelmon.api.events.storage.ChangeStorageEvent;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.MutableRibbonData;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.Ribbon;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.RibbonRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.event.RibbonEvent;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.RibbonType;
import com.pixelmonmod.pixelmon.api.pokemon.ribbon.type.impl.DeveloperRibbonType;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.abilities.Abilities;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BonusStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.EVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.ExtraStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PokemonLevel;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.pokemon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.BlocksWalkedOutsideBallStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MoveUsesStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.RecoilStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.ShearableStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.render.shader.ShaderParameters;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBaseEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractBattleEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Pokemon
extends PokemonBase {
    public static final DataSync<? extends AbstractBaseEntity, EnumGrowth> SYNC_GROWTH = new DataSync<AbstractBaseEntity, EnumGrowth>(AbstractBaseEntity.class, PixelmonDataSerializers.GROWTH, (abstractBaseEntity, growth) -> {
        abstractBaseEntity.getPokemon().growth = growth;
    }, (pokemon, enumGrowth) -> {
        pokemon.growth = enumGrowth;
    });
    public static final DataSync<? extends AbstractBaseEntity, Integer> SYNC_LEVEL = new DataSync<AbstractBaseEntity, Integer>(AbstractBaseEntity.class, EntityDataSerializers.f_135028_, (abstractBaseEntity, level) -> {
        abstractBaseEntity.getPokemon().level = level;
    }, (pokemon, integer) -> {
        pokemon.level = integer;
    });
    public static final DataSync<? extends AbstractBaseEntity, Integer> SYNC_EXP = new DataSync<AbstractBaseEntity, Integer>(AbstractBaseEntity.class, EntityDataSerializers.f_135028_, (abstractBaseEntity, exp) -> {
        abstractBaseEntity.getPokemon().experience = exp;
    }, (pokemon, integer) -> {
        pokemon.experience = integer;
    });
    public static final DataSync<? extends AbstractBaseEntity, Optional<UUID>> SYNC_ENTITY_UUID = new DataSync<AbstractBaseEntity, Optional>(AbstractBaseEntity.class, EntityDataSerializers.f_135041_, (abstractBaseEntity, uuid) -> uuid.ifPresent(actualUuid -> {
        abstractBaseEntity.getPokemon().uuid = actualUuid;
    }), (pokemon, uuid1) -> uuid1.ifPresent(uuid2 -> {
        pokemon.uuid = uuid2;
    }));
    public static final DataSync<? extends AbstractBaseEntity, Component> SYNC_NICK_NAME = new DataSync<AbstractBaseEntity, Component>(AbstractBaseEntity.class, EntityDataSerializers.f_135031_, (abstractBaseEntity, nickName) -> {
        abstractBaseEntity.getPokemon().nickname = nickName;
    }, (pokemon, s) -> {
        pokemon.nickname = s;
    });
    public static final DataSync<? extends AbstractBaseEntity, Ribbon> SYNC_RIBBON = new DataSync<AbstractBaseEntity, Ribbon>(AbstractBaseEntity.class, PixelmonDataSerializers.RIBBON_TYPE, (abstractBaseEntity, ribbon) -> {
        abstractBaseEntity.getPokemon().displayedRibbon = ribbon;
    }, (pokemon, enumRibbonType) -> {
        pokemon.displayedRibbon = enumRibbonType;
    });
    public static final DataSync<? extends AbstractBaseEntity, Float> SYNC_HEALTH = new DataSync<AbstractBaseEntity, Float>(AbstractBaseEntity.class, LivingEntity.f_20961_, (abstractBaseEntity, health) -> {
        abstractBaseEntity.getPokemon().health = health.intValue();
    }, (pokemon, f) -> {
        pokemon.health = f.intValue();
    });
    public static final DataSync<? extends AbstractBaseEntity, String[]> SYNC_FLAGS = new DataSync<AbstractBaseEntity, String[]>(AbstractBaseEntity.class, PixelmonDataSerializers.STRING_ARRAY, (abstractBaseEntity, flags) -> {
        abstractBaseEntity.getPokemon().flags = Lists.newArrayList((Object[])flags);
    }, (pokemon, f) -> {
        pokemon.flags = Lists.newArrayList((Object[])f);
    });
    private static final EnumUpdateType[] HP = new EnumUpdateType[]{EnumUpdateType.HP};
    public static final EnumUpdateType[] STATS = new EnumUpdateType[]{EnumUpdateType.Stats};
    public static final EnumUpdateType[] ABILITY = new EnumUpdateType[]{EnumUpdateType.Ability};
    public static final EnumUpdateType[] FORM = new EnumUpdateType[]{EnumUpdateType.Form};
    public static final EnumUpdateType[] EMPTY = new EnumUpdateType[0];
    public static final Component EGG = Component.m_237115_((String)"pixelmon.egg");
    protected UUID uuid;
    protected Moveset moveset = new Moveset().withPokemon(this);
    protected Nature nature = null;
    protected int slot = -1;
    protected boolean ha = false;
    protected Nature mintNature = null;
    protected EnumGrowth growth = null;
    protected int friendship;
    protected PokemonLevel pokemonLevelContainer = new PokemonLevel(new DelegateLink(this));
    protected int level = -1;
    protected int experience = 0;
    protected int dynamaxLevel = 0;
    protected boolean gigantamaxFactor = false;
    protected PermanentStats permanentStats = new PermanentStats().withPokemon(this);
    protected BonusStats bonusStats = new BonusStats(0, 0, 0, 0, 0, 0, 0);
    protected Integer eggSteps = null;
    protected ItemStack heldItem = ItemStack.f_41583_;
    protected StatusPersist status = NoStatus.noStatus;
    protected ExtraStats extraStats;
    protected Component nickname = Component.m_237119_();
    protected String originalTrainerName = null;
    protected UUID originalTrainerUUID = null;
    protected Pokerus pokerus = null;
    protected int health = -1;
    protected boolean doesLevel = true;
    protected volatile HashMap<String, Tuple<Long, Long>> moveSkillCooldownData = new HashMap();
    protected List<String> flags = new ArrayList<String>();
    protected List<Ribbon> ribbons = Lists.newArrayList();
    protected Ribbon displayedRibbon = null;
    protected CompoundTag persistentData = new CompoundTag();
    public int lastBattleCrits = 0;
    protected transient ResourceKey<Level> dimension = null;
    protected transient int entityID = -1;
    protected transient PokemonStorage storage = null;
    protected transient StoragePosition position = null;

    protected Pokemon() {
        this.uuid = UUID.randomUUID();
    }

    protected Pokemon(UUID uuid) {
        this.uuid = uuid;
    }

    protected Pokemon(UUID uuid, Species species) {
        super(species, species.getDefaultForm(), null);
        this.uuid = uuid;
    }

    public Optional<PixelmonEntity> getPixelmonEntity() {
        Entity entity;
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return Optional.empty();
        }
        ServerLevel ServerLevel2 = ServerLifecycleHooks.getCurrentServer().m_129880_(this.dimension);
        if (ServerLevel2 != null && (entity = ServerLevel2.m_8791_(this.uuid)) instanceof PixelmonEntity) {
            return Optional.of((PixelmonEntity)entity);
        }
        return Optional.empty();
    }

    public Optional<PixelmonWrapper> getPixelmonWrapper() {
        return this.getPixelmonEntity().map(AbstractBattleEntity::getPixelmonWrapper);
    }

    @Deprecated
    public Optional<PixelmonWrapper> getPixelmonWrapperFromPlayer() {
        ServerPlayer owner = this.getOwnerPlayer();
        if (owner == null) {
            return Optional.empty();
        }
        BattleController bc = BattleRegistry.getBattle((Player)owner);
        if (bc == null) {
            return Optional.empty();
        }
        BattleParticipant participant = bc.getParticipantForEntity((LivingEntity)owner);
        if (participant == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(participant.getPokemonFromUUID(this.getUUID()));
    }

    public PixelmonEntity getOrSpawnPixelmon(Level world, double x, double y, double z, float rotationYaw, float rotationPitch) {
        PixelmonEntity pixelmon = this.getPixelmonEntity().orElse(null);
        if (pixelmon != null && world != null && pixelmon.m_20193_() != world) {
            pixelmon.m_6089_();
            pixelmon = null;
            this.entityID = -1;
        }
        if (pixelmon == null) {
            if (world == null) {
                return null;
            }
            pixelmon = new PixelmonEntity(world, this);
            pixelmon.m_19890_(x, y, z, rotationPitch, rotationYaw);
            if (!world.m_7967_((Entity)pixelmon)) {
                return null;
            }
            this.dimension = world.m_46472_();
            this.entityID = pixelmon.m_19879_();
        }
        return pixelmon;
    }

    public PixelmonEntity getOrSpawnPixelmon(Level world, double x, double y, double z) {
        return this.getOrSpawnPixelmon(world, x, y, z, RandomHelper.getRandom().nextInt(360), 0.0f);
    }

    public PixelmonEntity getOrSpawnPixelmon(Entity parent) {
        if (parent == null) {
            return this.getOrSpawnPixelmon(null, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        return this.getOrSpawnPixelmon(parent.f_19853_, parent.m_20185_(), parent.m_20186_(), parent.m_20189_(), parent.f_19857_, parent.f_19858_);
    }

    public PixelmonEntity getOrCreatePixelmon(Level world, double x, double y, double z, float rotationYaw, float rotationPitch) {
        PixelmonEntity pixelmon = this.getPixelmonEntity().orElse(null);
        if (pixelmon != null && world != null && pixelmon.m_20193_() != world) {
            pixelmon.m_6089_();
            pixelmon = null;
            this.entityID = -1;
        }
        if (pixelmon == null) {
            if (world == null) {
                world = ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_);
            }
            pixelmon = new PixelmonEntity(world, this);
            pixelmon.m_19890_(x, y, z, rotationPitch, rotationYaw);
            this.dimension = world.m_46472_();
            this.entityID = pixelmon.m_19879_();
        }
        return pixelmon;
    }

    public PixelmonEntity getOrCreatePixelmon(Level world, double x, double y, double z) {
        return this.getOrCreatePixelmon(world, x, y, z, RandomHelper.getRandom().nextInt(360), 0.0f);
    }

    public PixelmonEntity getOrCreatePixelmon() {
        return this.getOrCreatePixelmon(null);
    }

    public PixelmonEntity getOrCreatePixelmon(Entity parent) {
        if (parent == null) {
            return this.getOrCreatePixelmon(null, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        return this.getOrCreatePixelmon(parent.f_19853_, parent.m_20185_(), parent.m_20186_(), parent.m_20189_(), parent.f_19857_, parent.f_19858_);
    }

    public void updateDimensionAndEntityID(ResourceKey<Level> dimension, int entityID) {
        this.dimension = dimension;
        this.entityID = entityID;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public Level getWorld() {
        ServerLevel world;
        if (this.dimension != null && (world = ServerLifecycleHooks.getCurrentServer().m_129880_(this.dimension)) != null) {
            return world;
        }
        return null;
    }

    public boolean ifEntityExists(Consumer<PixelmonEntity> action) {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return false;
        }
        PixelmonEntity pixelmon = this.getPixelmonEntity().orElse(null);
        if (pixelmon == null) {
            return false;
        }
        action.accept(pixelmon);
        return true;
    }

    public Pokemon initialize(InitializeCategory ... initializeCategories) {
        Stats oldForm = this.getForm();
        boolean initializeIntrinsic = false;
        boolean initializeSpecies = false;
        boolean forceful = false;
        if (initializeCategories == null || initializeCategories.length == 0) {
            initializeSpecies = true;
            initializeIntrinsic = true;
        } else {
            for (InitializeCategory initializeCategory : initializeCategories) {
                if (initializeCategory == InitializeCategory.INTRINSIC) {
                    initializeIntrinsic = true;
                    continue;
                }
                if (initializeCategory == InitializeCategory.SPECIES) {
                    initializeSpecies = true;
                    continue;
                }
                if (initializeCategory != InitializeCategory.INTRINSIC_FORCEFUL) continue;
                forceful = true;
                initializeIntrinsic = true;
            }
        }
        if (this.gender == null && this.form != null) {
            this.gender = this.form.getDefaultGender();
        }
        if (initializeIntrinsic) {
            float rate;
            if (this.form == null || forceful) {
                this.setForm(this.species.getDefaultForm());
                if (this.gender == null) {
                    this.gender = this.form.getDefaultGender();
                }
            }
            if (!this.form.isPossibleGender(this.gender)) {
                this.gender = this.form.getDefaultGender();
            }
            if (this.nature == null || forceful) {
                this.setNature(Nature.getRandomNature());
            }
            if (this.palette == null || forceful) {
                this.setPalette(this.getGenderProperties().getDefaultPalette());
            }
            if (this.growth == null || forceful) {
                this.setGrowth(EnumGrowth.getRandomGrowth());
            }
            if (this.getIVs().hasAnyIVBeenSet()) {
                this.getIVs().clearUnsetIVs();
            } else if (this.form.getTags().isLegendary() || this.form.getTags().isUltraBeast() || this.form.getTags().hasTag("threeivs")) {
                this.getIVs().copyIVs(IVStore.createNewIVs3Perfect());
            } else {
                this.getIVs().copyIVs(IVStore.createRandomNewIVs());
            }
            if (forceful) {
                this.getEVs().fillFromArray(0, 0, 0, 0, 0, 0);
            }
            Stats stats = this.getForm();
            if (this.level == -1 || forceful) {
                this.getPokemonLevelContainer().setLevel(Math.min(RandomHelper.getRandomNumberBetween(stats.getSpawn().getSpawnLevel(), Math.max(stats.getSpawn().getSpawnLevel(), Math.min(PixelmonConfigProxy.getGeneral().getMaxLevel(), stats.getSpawn().getSpawnLevel() + stats.getSpawn().getSpawnLevelRange()))), PixelmonConfigProxy.getGeneral().getMaxLevel()));
            }
            if (stats.getGigantamax().canHaveFactor() && (rate = PixelmonConfigProxy.getSpawning().getGigantamaxFactorRate(this.dimension)) > 0.0f && RandomHelper.getRandomChance(1.0f / rate)) {
                this.gigantamaxFactor = true;
            }
            if (this.moveset == null || this.moveset.isEmpty() || forceful) {
                this.moveset = stats.getMoves().loadMoveset(this.level, this.moveset == null ? null : this.moveset.getAbility()).withPokemon(this);
            }
            this.permanentStats.setLevelStats(this.nature, stats, this.level);
            if (this.friendship == -1 || forceful) {
                this.friendship = stats.getSpawn().getBaseFriendship();
            }
            this.health = this.getMaxHealth();
            if (this.moveset.getAbility() == null || forceful) {
                if (forceful) {
                    this.slot = -1;
                }
                this.resetAbility();
            }
            if (this.storage == null && PixelmonConfigProxy.getGeneral().getPokerus().shouldCatchPokerus()) {
                this.setPokerus(new Pokerus(PokerusStrain.getRandomType()));
            }
        }
        if (initializeSpecies) {
            float healthPercentage = 100.0f;
            int healthDeficit = 0;
            if (this.health != -1 && this.permanentStats != null) {
                healthPercentage = this.getHealthPercentage();
                healthDeficit = this.getMaxHealth() - this.getHealth();
            }
            Stats stats = this.getForm();
            ExtraStats newExtraStats = ExtraStats.getExtraStats(this.species);
            if (this.extraStats == null && newExtraStats != null || newExtraStats == null && this.extraStats != null || this.extraStats != null && newExtraStats != null && this.extraStats.getClass() != newExtraStats.getClass()) {
                this.extraStats = newExtraStats;
            }
            if (forceful) {
                this.gender = Gender.NONE;
            }
            if (stats == null) {
                stats = this.species.getDefaultForm();
            }
            if (this.gender == null || this.getGender() == Gender.MALE && stats.isFemaleOnly() || this.getGender() == Gender.FEMALE && stats.isMaleOnly() || this.getGender() == Gender.NONE && !stats.isGenderless()) {
                this.setGender(Gender.getRandomGender(stats));
            }
            if (this.getGender() != Gender.NONE && stats.isGenderless()) {
                this.setGender(Gender.NONE);
            }
            if (this.form == null) {
                this.setForm(this.species.getDefaultForm());
            }
            stats = this.getForm();
            Ability oldAbility = this.getAbility();
            if (this.moveset == null || oldForm == null) {
                this.moveset = stats.getMoves().loadMoveset(this.level);
            } else {
                if (forceful && !this.getPixelmonWrapper().isPresent()) {
                    this.moveset.removeIllegalMoves();
                }
                if (forceful || oldAbility == null) {
                    if (this.moveset.getTempAbility() != null) {
                        Ability ability = stats.getAbilities().getAbilityByName(this.moveset.getTempAbility());
                        this.setAbility(ability);
                        this.moveset.setTempAbility(null);
                    } else {
                        if (stats.isTemporary()) {
                            this.moveset.setTempAbility(this.getAbilityName());
                        }
                        this.resetAbility();
                    }
                }
            }
            if (this.getAbility() == null) {
                this.setAbility(oldAbility);
            }
            this.permanentStats.setLevelStats(this.getNature(), stats, this.level);
            if (this.form.isForm("complete") && this.species.is(PixelmonSpecies.ZYGARDE)) {
                this.setHealth(this.getMaxHealth() - healthDeficit);
            } else {
                this.setHealth(Math.round(healthPercentage / 100.0f * (float)this.getMaxHealth()));
            }
            if (this.extraStats != null && this.extraStats.hasSpecialSetup()) {
                this.extraStats.specialPrep(this);
            }
        }
        this.markDirty(EnumUpdateType.CLIENT);
        this.ifEntityExists(AbstractClientEntity::resetDataWatchers);
        return this;
    }

    @Override
    public Pokemon makeEgg() {
        this.setLevel(1);
        super.makeEgg();
        this.setEggSteps(0);
        this.markDirty(EnumUpdateType.Egg);
        return this;
    }

    public void evolve(PokemonSpecification to) {
        this.getPixelmonEntity().ifPresent(pixelmon -> {
            ShaderParameters shaderProperties = pixelmon.getShaderParameters();
            float oldHP = this.getMaxHealth();
            float oldHealth = pixelmon.m_21223_();
            to.apply(this);
            if (pixelmon != null) {
                pixelmon.m_21153_(oldHealth / oldHP * (float)this.getMaxHealth());
            }
            this.initialize(InitializeCategory.SPECIES);
            pixelmon.setShaderParameters(shaderProperties);
            UUID playerUUID = this.getOwnerPlayerUUID();
            if (playerUUID != null) {
                PlayerPartyStorage storage = StorageProxy.getPartyNow(playerUUID);
                PokedexEvent.Pre preEvent = new PokedexEvent.Pre(playerUUID, this, PokedexRegistrationStatus.CAUGHT, "evolution");
                if (!Pixelmon.EVENT_BUS.post((Event)preEvent)) {
                    storage.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                    storage.playerPokedex.update();
                    ServerPlayer player = this.getOwnerPlayer();
                    if (player != null) {
                        storage.playerPokedex.update();
                    }
                    Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(playerUUID, preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
                }
            }
            if (this.getNickname() != null && Objects.equals(this.getNickname(), this.getSpecies().getLocalizedName())) {
                this.removeNickname();
            }
        });
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Pokemon setUUID(UUID uuid) {
        SYNC_ENTITY_UUID.set(this, Optional.of(uuid));
        this.markDirty(new EnumUpdateType[0]);
        return this;
    }

    public UUID getOwnerTrainerUUID() {
        if (this.storage == null || !(this.storage instanceof TrainerPartyStorage)) {
            return null;
        }
        return this.storage.uuid;
    }

    public NPCTrainer getOwnerTrainer() {
        NPCTrainer trainer;
        if (this.storage instanceof TrainerPartyStorage && trainer.f_19853_.m_6815_((trainer = ((TrainerPartyStorage)this.storage).getTrainer()).m_19879_()) != null) {
            return trainer;
        }
        return null;
    }

    public UUID getOwnerPlayerUUID() {
        PCStorage pc;
        if (this.storage == null) {
            return null;
        }
        if (this.storage instanceof PlayerPartyStorage) {
            return this.storage.uuid;
        }
        if (this.storage instanceof TrainerPartyStorage) {
            return null;
        }
        PCStorage pCStorage = this.storage instanceof PCBox ? ((PCBox)this.storage).pc : (pc = this.storage instanceof PCStorage ? (PCStorage)this.storage : null);
        if (pc != null) {
            return pc.playerUUID;
        }
        return null;
    }

    public ServerPlayer getOwnerPlayer() {
        UUID playerUUID = this.getOwnerPlayerUUID();
        if (playerUUID == null) {
            return null;
        }
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(playerUUID);
    }

    @Deprecated
    public String getDisplayName() {
        if (this.isEgg()) {
            return EGG.getString();
        }
        return this.nickname == null || Objects.equals(this.nickname, Component.m_237119_()) || !PixelmonConfigProxy.getGeneral().isAllowPokemonNicknames() ? this.getLocalizedName() : this.nickname.getString() + ChatFormatting.RESET;
    }

    public Component getFormattedDisplayName() {
        if (this.isEgg()) {
            return EGG;
        }
        return this.nickname == null || Objects.equals(this.nickname, Component.m_237119_()) || !PixelmonConfigProxy.getGeneral().isAllowPokemonNicknames() ? this.getTranslatedName() : this.nickname;
    }

    public Component getDisplayNameWithRibbon() {
        if (this.isEgg()) {
            return EGG;
        }
        if (this.getDisplayedRibbon() == null) {
            return this.getFormattedDisplayName();
        }
        MutableRibbonData ribbonData = this.getDisplayedRibbon().getRibbonData();
        MutableComponent name = this.getFormattedDisplayName().m_6881_();
        if (ribbonData != null) {
            if (ribbonData.getPrefix() != null) {
                name = ribbonData.getPrefix().m_6881_().m_130946_(" ").m_7220_(this.getFormattedDisplayName());
            }
            if (ribbonData.getSuffix() != null) {
                name = this.getFormattedDisplayName().m_6881_().m_130946_(" ").m_7220_(ribbonData.getSuffix());
            }
        }
        return name;
    }

    @Deprecated
    @Nullable
    public String getNickname() {
        return this.nickname == null ? "" : this.nickname.getString();
    }

    public Component getFormattedNickname() {
        return this.nickname;
    }

    public void removeNickname() {
        this.setNickname((Component)Component.m_237119_());
    }

    @Deprecated
    public void setNickname(String nickname) {
        SYNC_NICK_NAME.set(this, (Object)TextHelper.colour(nickname));
        this.markDirty(EnumUpdateType.Nickname);
    }

    public void setNickname(Component nickname) {
        SYNC_NICK_NAME.set(this, (Object)nickname);
        this.markDirty(EnumUpdateType.Nickname);
    }

    public String getOwnerName() {
        NPCTrainer trainer = this.getOwnerTrainer();
        ServerPlayer player = this.getOwnerPlayer();
        if (trainer != null) {
            return trainer.m_7755_().getString();
        }
        if (player != null) {
            return player.m_7755_().getString();
        }
        return this.getDisplayName();
    }

    public void setSpecies(RegistryValue<Species> species, boolean doSpeciesInitialization) {
        if (species.isInitialized()) {
            GenderProperties genderProperties;
            Species s = species.getValueUnsafe();
            Stats form = this.form != null ? s.getForm(this.form.getName()) : s.getDefaultForm();
            if (form == null) {
                form = s.getDefaultForm();
            }
            if (this.gender == null) {
                this.gender = form.getDefaultGender();
            }
            if ((genderProperties = form.getGenderProperties(this.gender)) == null) {
                genderProperties = form.getDefaultGenderProperties();
            }
            PaletteProperties palette = this.getPalette() == null || genderProperties.getPalette(this.getPalette().getName()) == null ? genderProperties.getDefaultPalette() : genderProperties.getPalette(this.getPalette().getName());
            PokemonBase.SYNC_POKEMON_BASE.set(this, (Object)new PokemonBase(s, form, palette, this.gender, this.eggCycles, this.ball));
            if (doSpeciesInitialization) {
                this.initialize(InitializeCategory.SPECIES);
            }
        }
    }

    public void setSpecies(Species species, boolean doSpeciesInitialization) {
        this.setSpecies(species.getRegistryValue(), doSpeciesInitialization);
    }

    @Override
    public void setForm(Stats form) {
        Stats previous = this.getForm();
        GenderProperties genderProperties = form.getGenderProperties(this.gender);
        if (genderProperties == null) {
            genderProperties = form.getDefaultGenderProperties();
        }
        PaletteProperties palette = this.getPalette() == null || genderProperties.getPalette(this.getPalette().getName()) == null ? genderProperties.getDefaultPalette() : genderProperties.getPalette(this.getPalette().getName());
        PokemonBase.SYNC_POKEMON_BASE.set(this, (Object)new PokemonBase(this.species, form, palette, this.gender, this.eggCycles, this.ball));
        this.initialize(InitializeCategory.SPECIES);
        this.markDirty(EnumUpdateType.Form);
    }

    @Override
    public boolean setForm(String form) {
        if (this.species.getForm(form) == null) {
            return false;
        }
        this.setForm(this.species.getForm(form));
        return true;
    }

    public void setGender(Gender gender) {
        if (this.getForm() == null) {
            PokemonBase.SYNC_POKEMON_BASE.set(this, (Object)new PokemonBase(this.species, this.form, this.palette, gender, this.eggCycles, this.ball));
            this.markDirty(FORM);
            return;
        }
        GenderProperties genderProperties = this.getForm().getGenderProperties(gender);
        if (genderProperties == null) {
            genderProperties = this.getForm().getDefaultGenderProperties();
        }
        PaletteProperties palette = this.getPalette() == null || genderProperties.getPalette(this.getPalette().getName()) == null ? genderProperties.getDefaultPalette() : genderProperties.getPalette(this.getPalette().getName());
        PokemonBase.SYNC_POKEMON_BASE.set(this, (Object)new PokemonBase(this.species, this.form, palette, gender, this.eggCycles, this.ball));
        this.markDirty(FORM);
    }

    @Override
    public void setEggCycles(Integer eggCycles, boolean event) {
        boolean wasEgg = this.isEgg();
        if (!event) {
            wasEgg = false;
        }
        if (eggCycles < -1) {
            eggCycles = -1;
        }
        PokemonBase.SYNC_POKEMON_BASE.set(this, (Object)new PokemonBase(this.species, this.form, this.palette, this.gender, eggCycles, this.ball));
        if (wasEgg && !this.isEgg()) {
            this.hatchEgg(true);
        } else {
            if (!wasEgg && this.isEgg()) {
                this.setLevel(1);
            }
            this.markDirty(EnumUpdateType.Egg);
        }
    }

    public int getEggSteps() {
        return this.eggSteps == null ? 0 : this.eggSteps;
    }

    public void setEggSteps(Integer eggSteps) {
        this.eggSteps = eggSteps;
        this.markDirty(new EnumUpdateType[0]);
    }

    public void addEggSteps(int steps, int cycleMultiplier) {
        this.setEggSteps(this.getEggSteps() + steps);
        if (this.getEggSteps() >= PixelmonConfigProxy.getBreeding().getStepsPerEggCycle()) {
            this.setEggSteps(0);
            this.setEggCycles(this.getEggCycles() - Math.max(1, cycleMultiplier));
            this.markDirty(new EnumUpdateType[0]);
        } else {
            this.markDirty(new EnumUpdateType[0]);
        }
    }

    public void hatchEgg() {
        this.hatchEgg(false);
    }

    public void hatchEgg(boolean force) {
        ServerPlayer player = this.getOwnerPlayer();
        if (player != null) {
            this.setOriginalTrainer((Player)player);
        } else {
            this.setOriginalTrainer(this.getOwnerPlayerUUID(), null);
        }
        if (!this.isEgg() && !force) {
            return;
        }
        this.setEggCycles(-1, false);
        PlayerPartyStorage party = null;
        if (this.storage instanceof PlayerPartyStorage) {
            PokedexEvent.Pre preEvent;
            party = (PlayerPartyStorage)this.storage;
            if (party.playerPokedex.get(this.species.getDex()) != PokedexRegistrationStatus.CAUGHT && !Pixelmon.EVENT_BUS.post((Event)(preEvent = new PokedexEvent.Pre(party.getIdentifier(), this, PokedexRegistrationStatus.CAUGHT, "egg")))) {
                party.playerPokedex.set(preEvent.getPokemon(), preEvent.getNewStatus());
                party.playerPokedex.update();
                Pixelmon.EVENT_BUS.post((Event)new PokedexEvent.Post(preEvent.getPlayerUUID(), preEvent.getOldStatus(), preEvent.getPokemon(), preEvent.getNewStatus(), preEvent.getCause()));
            }
            party.getDayCare().updateHistory(this);
        }
        MutableComponent message = Component.m_237110_((String)"pixelmon.egg.hatching", (Object[])new Object[]{this.species.getLocalizedName()});
        message.m_130940_(ChatFormatting.GREEN);
        EggHatchEvent.Pre preEvent = new EggHatchEvent.Pre(player, this.getStorage(), this, (Component)message);
        Pixelmon.EVENT_BUS.post((Event)preEvent);
        if (player != null && preEvent.getMessage() != null && force) {
            player.m_213846_(preEvent.getMessage());
        }
        if (this.getStorage() instanceof PlayerPartyStorage && !((PlayerPartyStorage)this.getStorage()).guiOpened) {
            OpenScreenPacket.open((Player)player, EnumGuiScreen.EggHatch, this.getPosition().order);
        }
        this.moveset.addCurrentMovesToReminder();
        this.markDirty(EnumUpdateType.Egg, EnumUpdateType.OriginalTrainer, EnumUpdateType.Moveset);
        Pixelmon.EVENT_BUS.post((Event)new EggHatchEvent.Post(player, this.getStorage(), this));
    }

    public String getEggDescription() {
        int cycles = this.getEggCycles();
        if (cycles < 5) {
            return "pixelmon.egg.stage1";
        }
        if (cycles < 10) {
            return "pixelmon.egg.stage2";
        }
        if (cycles < 40) {
            return "pixelmon.egg.stage3";
        }
        return "pixelmon.egg.stage4";
    }

    @Nonnull
    public ItemStack getHeldItem() {
        return this.heldItem == null ? ItemStack.f_41583_ : this.heldItem;
    }

    @Nonnull
    public HeldItem getHeldItemAsItemHeld() {
        return HeldItem.getItemHeld(this.heldItem);
    }

    public boolean setHeldItem(ItemStack stack) {
        if (stack == null || stack.m_41619_() || stack.m_41720_() == PixelmonItems.no_item) {
            stack = ItemStack.f_41583_;
        }
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            HeldItemChangedEvent.Pre event = new HeldItemChangedEvent.Pre(this.getOwnerPlayer(), this, stack);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            stack = event.getHeldItem();
        }
        this.heldItem = stack;
        this.markDirty(EnumUpdateType.HeldItem);
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            Pixelmon.EVENT_BUS.post((Event)new HeldItemChangedEvent.Post(this.getOwnerPlayer(), this, this.heldItem));
        }
        return true;
    }

    public EnumGrowth getGrowth() {
        return this.growth;
    }

    public void setGrowth(EnumGrowth growth) {
        this.growth = growth;
        this.markDirty(FORM);
    }

    public Nature getNature() {
        return this.mintNature != null ? this.mintNature : this.nature;
    }

    public Nature getBaseNature() {
        return this.nature;
    }

    public Nature getMintNature() {
        return this.mintNature;
    }

    public void setNature(Nature nature) {
        this.nature = nature;
        this.permanentStats.setLevelStats(this.mintNature != null ? this.mintNature : nature, this.getForm(), this.getPokemonLevel());
        this.markDirty(STATS);
    }

    public void setMintNature(Nature nature) {
        this.mintNature = nature;
        this.setNature(this.nature);
    }

    public Pokerus getPokerus() {
        return this.pokerus;
    }

    public void setPokerus(Pokerus pokerus) {
        this.pokerus = pokerus;
        this.markDirty(EnumUpdateType.Pokerus);
    }

    public Ability getAbility() {
        return this.moveset.getAbility();
    }

    public String getAbilityName() {
        Ability ability = this.getAbility();
        if (ability == null) {
            return "";
        }
        return ability instanceof ComingSoon ? ((ComingSoon)ability).getTrueAbility() : ability.getName();
    }

    public void setAbility(Ability ability) {
        this.recordAbilitySlot(ability);
        this.moveset.setAbility(ability);
        this.markDirty(ABILITY);
    }

    public void setAbility(Optional<Ability> ability) {
        ability.ifPresent(this::setAbility);
    }

    public void setAbility(RegistryValue<Ability> ability) {
        ability.ifPresent(this::setAbility);
    }

    public IVStore getIVs() {
        return this.permanentStats.getIVs();
    }

    public EVStore getEVs() {
        return this.permanentStats.getEVs();
    }

    public BonusStats getBonusStats() {
        return this.bonusStats;
    }

    public void setBonusStats(BonusStats bonusStats) {
        this.bonusStats = bonusStats;
    }

    public int getHighestOffensiveStat() {
        return Math.max(this.getStat(BattleStatsType.ATTACK), this.getStat(BattleStatsType.SPECIAL_ATTACK));
    }

    public int getStat(BattleStatsType stat) {
        return this.permanentStats.get(stat);
    }

    public PermanentStats getStats() {
        return this.permanentStats;
    }

    public ExtraStats getExtraStats() {
        if (this.extraStats == null && this.species != null && ExtraStats.getExtraStats(this.species) != null) {
            this.extraStats = ExtraStats.getExtraStats(this.species);
        }
        return this.extraStats;
    }

    public <T extends ExtraStats> Optional<T> getExtraStats(Class<T> type) {
        ExtraStats stats = this.getExtraStats();
        if (type.isInstance(stats)) {
            return Optional.of(stats);
        }
        return Optional.empty();
    }

    public void setExperience(int experience) {
        this.experience = experience;
        this.getPokemonLevelContainer().updateExpToNextLevel();
        this.markDirty(EnumUpdateType.Experience);
    }

    public int getExperience() {
        return this.experience;
    }

    public int getExperienceToLevelUp() {
        if (this.getPokemonLevel() == PixelmonServerConfig.maxLevel) {
            return 1;
        }
        this.getPokemonLevelContainer().updateExpToNextLevel();
        return this.getPokemonLevelContainer().expToNextLevel;
    }

    public float getExperienceFraction() {
        return (float)this.getExperience() / (float)this.getExperienceToLevelUp();
    }

    @Nonnull
    public StatusPersist getStatus() {
        return this.status == null ? (this.status = NoStatus.noStatus) : this.status;
    }

    public void setStatus(StatusPersist status) {
        this.status = status == null ? NoStatus.noStatus : status;
        this.markDirty(EnumUpdateType.Status);
    }

    public int getPokemonLevel() {
        return this.level;
    }

    public PokemonLevel getPokemonLevelContainer() {
        return this.pokemonLevelContainer;
    }

    public void setLevelNum(int level) {
        SYNC_LEVEL.set(this, (Object)level);
        this.markDirty(STATS);
    }

    public void setLevel(int level) {
        if (level > PixelmonServerConfig.maxLevel) {
            level = PixelmonServerConfig.maxLevel;
        }
        if (level < 1) {
            level = 1;
        }
        this.getPokemonLevelContainer().setLevel(level);
        this.setExperience(0);
    }

    public int getDynamaxLevel() {
        return this.dynamaxLevel;
    }

    public void setDynamaxLevel(int dynamaxLevel) {
        this.dynamaxLevel = dynamaxLevel;
        this.markDirty(EnumUpdateType.Stats);
    }

    public void changeDynamaxLevel(int dynamaxLevel) {
        this.dynamaxLevel += dynamaxLevel;
        this.markDirty(EnumUpdateType.Stats);
    }

    public boolean hasGigantamaxFactor() {
        return this.gigantamaxFactor;
    }

    public boolean canGigantamax() {
        return this.hasGigantamaxFactor() && this.getForm().getGigantamax().canGigantamax();
    }

    public void setGigantamaxFactor(boolean gigantamaxFactor) {
        this.gigantamaxFactor = this.getForm().getGigantamax().canHaveFactor() ? gigantamaxFactor : false;
        this.markDirty(EnumUpdateType.Stats);
    }

    public boolean canBattle() {
        return !this.isEgg() && !this.isFainted();
    }

    public boolean isLegendary() {
        return this.isLegendary(false);
    }

    public boolean isLegendary(boolean excludeMythicals) {
        return this.getForm().getTags().isLegendary() || !excludeMythicals && this.isMythical();
    }

    public boolean isMythical() {
        return this.getForm().getTags().isMythical();
    }

    public boolean isUltraBeast() {
        return this.getForm().getTags().isUltraBeast();
    }

    public boolean isMega() {
        return this.getForm().getTags().hasTag("mega");
    }

    @Override
    public boolean setPalette(PaletteProperties paletteProperties) {
        return this.setPalette(paletteProperties.getName());
    }

    public boolean setPalette(String palette) {
        return this.setPalette(palette, true);
    }

    public boolean setPalette(String palette, boolean sync) {
        if (this.gender == null) {
            return false;
        }
        if (!this.gender.hasPalette(this.getForm(), palette)) {
            return false;
        }
        PokemonBase.SYNC_POKEMON_BASE.set(this, (Object)new PokemonBase(this.species, this.form, this.form.getGenderProperties(this.gender).getPalette(palette), this.gender, this.eggCycles, this.ball));
        if (sync) {
            this.markDirty(EMPTY);
        }
        return true;
    }

    public boolean setShiny() {
        return this.setShiny(true);
    }

    public boolean setShiny(boolean shiny) {
        if (this.isShiny() && !shiny) {
            return this.setPalette(this.getGenderProperties().getDefaultPalette());
        }
        if (shiny) {
            return this.setPalette("shiny");
        }
        return false;
    }

    public Moveset getMoveset() {
        return this.moveset;
    }

    public void setHA(boolean isHiddenAbility) {
        this.ha = isHiddenAbility;
    }

    public void setAbilitySlot(int abilitySlot) {
        this.slot = abilitySlot;
    }

    public int getFriendship() {
        return this.friendship;
    }

    public void setFriendship(int friendship) {
        this.friendship = friendship > 255 ? 255 : Math.max(friendship, 0);
        this.markDirty(EnumUpdateType.Friendship);
    }

    public void increaseFriendship(int amount) {
        if (this.getHeldItemAsItemHeld().getHeldItemType() == EnumHeldItems.sootheBell) {
            amount = (int)((double)amount * 1.5);
        }
        this.setFriendship(this.getFriendship() + Math.abs(amount));
    }

    public void decreaseFriendship(int amount) {
        this.setFriendship(this.getFriendship() - Math.abs(amount));
    }

    public boolean isFriendshipHighEnoughToEvolve() {
        return this.getFriendship() >= 220;
    }

    @Nullable
    public String getOriginalTrainer() {
        return this.originalTrainerName;
    }

    @Nullable
    public UUID getOriginalTrainerUUID() {
        return this.originalTrainerUUID;
    }

    public void setOriginalTrainer(UUID originalTrainerUUID, String originalTrainerName) {
        this.originalTrainerUUID = originalTrainerUUID;
        this.originalTrainerName = originalTrainerName;
        this.markDirty(EnumUpdateType.OriginalTrainer);
    }

    public void setOriginalTrainer(Player player) {
        if (player != null) {
            this.setOriginalTrainer(player.m_20148_(), player.m_7755_().getString());
        }
    }

    public boolean isOriginalTrainer(Player player) {
        if (this.originalTrainerUUID == null && this.originalTrainerName != null && (this.originalTrainerName.equals(player.m_7755_()) || ChatFormatting.m_126649_((String)this.originalTrainerName).equals(player.m_7755_()))) {
            this.setOriginalTrainer(player);
        }
        return player.m_20148_().equals(this.originalTrainerUUID);
    }

    @Override
    public void setBall(PokeBall caughtBall) {
        PokemonBase.SYNC_POKEMON_BASE.set(this, (Object)new PokemonBase(this.species, this.form, this.palette, this.gender, this.eggCycles, caughtBall));
        this.markDirty(EnumUpdateType.Ball);
    }

    public int getHealth() {
        return this.health;
    }

    public float getHealthPercentage() {
        return 1.0f * (float)this.health / (float)this.getMaxHealth() * 100.0f;
    }

    public void heal() {
        this.setHealthPercentage(100.0f);
        this.getMoveset().healAllPP();
        this.setStatus(NoStatus.noStatus);
    }

    public void setHealthCache(int health) {
        this.health = health;
    }

    public void setHealth(int health) {
        PixelmonFaintEvent.Pre pre;
        if (health <= 0 && Pixelmon.EVENT_BUS.post((Event)(pre = new PixelmonFaintEvent.Pre(this.getOwnerPlayer(), this)))) {
            return;
        }
        SYNC_HEALTH.set(this, (Object)Float.valueOf(health));
        this.markDirty(HP);
        if (health <= 0) {
            Pixelmon.EVENT_BUS.post((Event)new PixelmonFaintEvent.Post(this.getOwnerPlayer(), this));
        }
    }

    public void setHealthPercentage(float healthPercentage) {
        this.setHealth(Math.round((float)this.getMaxHealth() * healthPercentage / 100.0f));
    }

    public int getMaxHealth() {
        return this.getPixelmonWrapper().map(PixelmonWrapper::getMaxHealth).orElse(this.getStat(BattleStatsType.HP));
    }

    public boolean doesLevel() {
        return this.doesLevel;
    }

    public void setDoesLevel(boolean doesLevel) {
        SetLevellingEvent event = new SetLevellingEvent(this, doesLevel);
        if (!Pixelmon.EVENT_BUS.post((Event)event)) {
            this.doesLevel = event.doesLevel;
            this.markDirty(EnumUpdateType.CanLevel);
        }
    }

    public List<ImmutableAttack> getRelearnableMoves() {
        return this.moveset.getReminderMoves();
    }

    public <T extends Evolution> ArrayList<T> getEvolutions(Class<T> type) {
        ArrayList<Evolution> evolutions = new ArrayList<Evolution>();
        for (Evolution evo : this.getForm().getEvolutions()) {
            if (!type.isInstance(evo)) continue;
            evolutions.add((Evolution)type.cast(evo));
        }
        return evolutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForExistingEvolutionQuery() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                if (!EvolutionQueryList.queryList.get((int)i).pokemonUUID.equals(this.getUUID())) continue;
                return true;
            }
        }
        return false;
    }

    public void tryEvolution() {
        boolean hasEvolved = this.checkForExistingEvolutionQuery();
        if (!this.isFainted() && !hasEvolved) {
            boolean spawned = false;
            PixelmonEntity pixelmon = this.getPixelmonEntity().orElse(null);
            if (pixelmon == null) {
                pixelmon = this.getOrSpawnPixelmon((Entity)this.getOwnerPlayer());
                spawned = true;
            } else if (pixelmon.m_21223_() < 1.0f) {
                return;
            }
            if (pixelmon != null && !pixelmon.testLevelEvolution(this.getPokemonLevel()) && spawned) {
                pixelmon.retrieve("Forced");
            }
        }
    }

    public CompoundTag getPersistentData() {
        return this.persistentData;
    }

    public void retrieve(String pokemonRetrievedEventReason) {
        this.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve(pokemonRetrievedEventReason));
    }

    public void setStorage(PokemonStorage storage, StoragePosition position) {
        if (this.storage != null && this.position != null) {
            Pixelmon.EVENT_BUS.post((Event)new ChangeStorageEvent(this.storage, this.position, storage, position, this));
        }
        this.storage = storage;
        this.position = position;
    }

    @Nullable
    public PokemonStorage getStorage() {
        return this.position == null ? null : this.storage;
    }

    @Nullable
    public StoragePosition getPosition() {
        return this.storage == null ? null : this.position;
    }

    @Nullable
    public Tuple<PokemonStorage, StoragePosition> getStorageAndPosition() {
        if (this.storage == null || this.position == null) {
            return null;
        }
        return new Tuple((Object)this.storage, (Object)this.position);
    }

    public boolean isMoveSkillCoolingDown(MoveSkill moveSkill) {
        return this.getMoveSkillCooldownTicks(moveSkill) > 0;
    }

    public int getMoveSkillCooldownTicks(MoveSkill moveSkill) {
        Tuple<Long, Long> tup = this.moveSkillCooldownData.get(moveSkill.id);
        if (tup == null) {
            return -1;
        }
        long remaining = (Long)tup.m_14419_() - System.currentTimeMillis();
        if (remaining <= 0L) {
            this.moveSkillCooldownData.remove(moveSkill.id);
            this.markDirty(EnumUpdateType.MoveSkills);
            return -1;
        }
        return (int)Math.ceil((float)remaining / 50.0f);
    }

    public double getMoveSkillCooldownRatio(MoveSkill moveSkill) {
        Tuple<Long, Long> tup = this.moveSkillCooldownData.get(moveSkill.id);
        long cur = System.currentTimeMillis();
        if (tup == null || cur > (Long)tup.m_14419_()) {
            return 1.0;
        }
        return (double)(System.currentTimeMillis() - (Long)tup.m_14418_()) * 1.0 / (double)((Long)tup.m_14419_() - (Long)tup.m_14418_());
    }

    public void setMoveSkillCooldown(MoveSkill moveSkill, int cooldownTicks) {
        long cur = System.currentTimeMillis();
        long des = cur + (long)cooldownTicks * 50L;
        this.moveSkillCooldownData.put(moveSkill.id, (Tuple<Long, Long>)new Tuple((Object)cur, (Object)des));
        this.markDirty(EnumUpdateType.MoveSkills);
    }

    public void addFlag(String key) {
        if (!this.flags.contains(key)) {
            this.flags.add(key);
            SYNC_FLAGS.set(this, (Object)this.flags.toArray(new String[0]));
        }
    }

    public void removeFlag(String key) {
        if (this.flags.remove(key)) {
            SYNC_FLAGS.set(this, (Object)this.flags.toArray(new String[0]));
        }
    }

    public boolean hasFlag(String key) {
        return this.flags.contains(key);
    }

    public void markDirty(EnumUpdateType ... dataTypes) {
        if (this.storage == null || this.position == null || this.storage.get(this.position) != this) {
            return;
        }
        this.storage.setNeedsSaving();
        this.storage.notifyListeners(this.position, this, dataTypes);
    }

    public List<Ribbon> getRibbons() {
        return Collections.unmodifiableList(this.ribbons);
    }

    @Nullable
    public Ribbon getDisplayedRibbon() {
        return this.displayedRibbon;
    }

    public void setDisplayedRibbon(Ribbon ribbon) {
        RibbonEvent.SetDisplayedRibbon.Pre pre = new RibbonEvent.SetDisplayedRibbon.Pre(this, ribbon, this.getOwnerPlayer());
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        if (this.ribbons.contains(pre.getRibbon())) {
            SYNC_RIBBON.set(this, (Object)pre.getRibbon());
        } else {
            SYNC_RIBBON.set(this, null);
        }
        this.markDirty(EnumUpdateType.Ribbons);
        Pixelmon.EVENT_BUS.post((Event)new RibbonEvent.SetDisplayedRibbon.Post(this, pre.getRibbon(), pre.getPlayer()));
    }

    public boolean addRibbon(RibbonType ribbonType) {
        return this.addRibbon(ribbonType, true);
    }

    public boolean addRibbon(RibbonType ribbonType, boolean displayRibbon) {
        Ribbon ribbon = Ribbon.builder().type(ribbonType).receivedDate(System.currentTimeMillis()).receiver(this.getOwnerPlayer()).build();
        ribbon.refreshData(this);
        return this.addRibbon(ribbon, displayRibbon);
    }

    public boolean addRibbon(Ribbon ribbon) {
        return this.addRibbon(ribbon, true);
    }

    public boolean addRibbon(Ribbon ribbon, boolean shouldDisplayRibbon) {
        StackTraceElement e;
        if (ribbon.getType().getValueUnsafe() instanceof DeveloperRibbonType && !(e = Thread.currentThread().getStackTrace()[4]).getFileName().contains("InteractionDeveloper")) {
            return false;
        }
        RibbonEvent.ReceiveRibbon.Pre pre = new RibbonEvent.ReceiveRibbon.Pre(this, ribbon, shouldDisplayRibbon);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return false;
        }
        boolean isAdded = this.ribbons.add(pre.getRibbon());
        if (pre.isShouldDisplay()) {
            this.setDisplayedRibbon(pre.getRibbon());
        }
        this.markDirty(EnumUpdateType.Ribbons);
        Pixelmon.EVENT_BUS.post((Event)new RibbonEvent.ReceiveRibbon.Post(this, pre.getRibbon(), pre.isShouldDisplay()));
        return isAdded;
    }

    public boolean removeRibbon(Ribbon ribbon) {
        RibbonEvent.RemoveRibbon.Pre pre = new RibbonEvent.RemoveRibbon.Pre(this, ribbon, this.displayedRibbon == ribbon);
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return false;
        }
        boolean isRemoved = this.ribbons.remove(pre.getRibbon());
        if (pre.wasDisplayed()) {
            this.setDisplayedRibbon(null);
        }
        this.markDirty(EnumUpdateType.Ribbons);
        Pixelmon.EVENT_BUS.post((Event)new RibbonEvent.RemoveRibbon.Post(this, pre.getRibbon(), pre.wasDisplayed()));
        return isRemoved;
    }

    @Override
    public ResourceLocation getSprite() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::checkExtrasData);
        return super.getSprite();
    }

    @Override
    public PaletteProperties getPalette() {
        if (this.displayedRibbon != null && this.displayedRibbon.getRibbonData() != null && this.displayedRibbon.getRibbonData().getOverridePalette() != null) {
            return this.displayedRibbon.getRibbonData().getOverridePalette();
        }
        return super.getPalette();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void checkExtrasData() {
        if (this.isPalette("online") && this.getOwnerPlayerUUID() != null) {
            PlayerExtraDataStore.get(this.getOwnerPlayerUUID()).checkPokemon(this);
        }
    }

    public boolean isFainted() {
        return this.getHealth() <= 0;
    }

    public boolean isUnbreedable() {
        return this.isEgg() || this.hasFlag("unbreedable");
    }

    public boolean isUntradeable() {
        return this.hasFlag("untradeable");
    }

    public boolean isUncatchable() {
        return this.hasFlag("uncatchable");
    }

    public boolean isUnbattleable() {
        return this.hasFlag("unbattleable");
    }

    public boolean hasNoDrops() {
        return this.hasFlag("nodrops");
    }

    public void writeToByteBuffer(FriendlyByteBuf buf, EnumUpdateType ... data) {
        if (data == null || data.length == 0) {
            data = EnumUpdateType.ALL;
        }
        buf.m_130077_(this.uuid);
        block31: for (EnumUpdateType type : data) {
            switch (type) {
                case Name: {
                    buf.writeShort(this.species.getDex());
                    continue block31;
                }
                case Nickname: {
                    buf.m_130083_((Component)(this.nickname == null ? Component.m_237119_() : this.nickname));
                    continue block31;
                }
                case Form: {
                    PaletteProperties palette;
                    this.invalidate();
                    buf.m_130070_(this.getForm().getName());
                    buf.writeByte(this.getGender().ordinal());
                    buf.writeBoolean(this.growth != null);
                    if (this.growth != null) {
                        buf.writeByte(this.getGrowth().ordinal());
                    }
                    if ((palette = this.getPalette()) != null) {
                        buf.m_130070_(this.getPalette().getName());
                        continue block31;
                    }
                    buf.m_130070_(this.getGenderProperties().getDefaultPalette().getName());
                    continue block31;
                }
                case Experience: {
                    buf.writeInt(this.experience);
                    continue block31;
                }
                case Stats: {
                    buf.writeByte(this.nature.ordinal());
                    buf.writeBoolean(this.mintNature != null);
                    if (this.mintNature != null) {
                        buf.writeByte(this.mintNature.ordinal());
                    }
                    buf.writeShort(this.level);
                    buf.writeShort(this.dynamaxLevel);
                    buf.writeBoolean(this.gigantamaxFactor);
                    buf.writeShort(this.getStat(BattleStatsType.HP));
                    buf.writeShort(this.getStat(BattleStatsType.ATTACK));
                    buf.writeShort(this.getStat(BattleStatsType.DEFENSE));
                    buf.writeShort(this.getStat(BattleStatsType.SPECIAL_ATTACK));
                    buf.writeShort(this.getStat(BattleStatsType.SPECIAL_DEFENSE));
                    buf.writeShort(this.getStat(BattleStatsType.SPEED));
                    this.bonusStats.writeToByteBuffer((ByteBuf)buf);
                    continue block31;
                }
                case IVs: {
                    this.getIVs().writeToByteBuffer((ByteBuf)buf);
                    continue block31;
                }
                case EVs: {
                    this.getEVs().writeToByteBuffer((ByteBuf)buf);
                    continue block31;
                }
                case HP: {
                    buf.writeInt(this.health);
                    continue block31;
                }
                case Ball: {
                    buf.m_130070_(this.ball.getName());
                    continue block31;
                }
                case Moveset: {
                    Moveset moveset = this.getMoveset();
                    moveset.toBytes(buf);
                    continue block31;
                }
                case Status: {
                    if (this.status == NoStatus.noStatus) {
                        buf.writeShort(-1);
                        continue block31;
                    }
                    buf.writeShort(this.status.type.ordinal());
                    continue block31;
                }
                case CanLevel: {
                    buf.writeBoolean(this.doesLevel);
                    continue block31;
                }
                case Egg: {
                    buf.writeBoolean(this.isEgg());
                    if (!this.isEgg()) continue block31;
                    buf.writeInt(this.eggCycles);
                    continue block31;
                }
                case HeldItem: {
                    buf.m_130055_(this.heldItem == null ? ItemStack.f_41583_ : this.heldItem);
                    continue block31;
                }
                case Friendship: {
                    buf.writeShort(this.friendship);
                    continue block31;
                }
                case Ability: {
                    buf.m_130070_(this.getAbilityName());
                    continue block31;
                }
                case Pokerus: {
                    if (this.pokerus == null) {
                        buf.writeBoolean(false);
                        continue block31;
                    }
                    buf.writeBoolean(true);
                    PixelmonDataSerializers.POKERUS.m_6856_(new FriendlyByteBuf((ByteBuf)buf), (Object)this.pokerus);
                    continue block31;
                }
                case OriginalTrainer: {
                    buf.writeBoolean(this.originalTrainerName != null);
                    if (this.originalTrainerName == null) continue block31;
                    buf.m_130070_(this.originalTrainerName);
                    continue block31;
                }
                case Clones: {
                    boolean hasClones = this.getExtraStats() instanceof MewStats;
                    buf.writeBoolean(hasClones);
                    if (!hasClones) continue block31;
                    buf.writeInt(((MewStats)this.extraStats).numCloned);
                    continue block31;
                }
                case Wool_Growth: {
                    boolean hasGrowth = this.getExtraStats() instanceof ShearableStats;
                    buf.writeBoolean(hasGrowth);
                    if (!hasGrowth) continue block31;
                    buf.writeByte((int)((ShearableStats)this.extraStats).growthStage);
                    continue block31;
                }
                case Enchants: {
                    boolean hasEnchants = this.getExtraStats() instanceof LakeTrioStats;
                    buf.writeBoolean(hasEnchants);
                    if (!hasEnchants) continue block31;
                    buf.writeInt(((LakeTrioStats)this.extraStats).numEnchanted);
                    continue block31;
                }
                case Meltan_Stats: {
                    boolean hasStats = this.getExtraStats() instanceof MeltanStats;
                    buf.writeBoolean(hasStats);
                    if (!hasStats) continue block31;
                    buf.writeInt(((MeltanStats)this.extraStats).nuggetsFed);
                    continue block31;
                }
                case Recoil: {
                    boolean hasRecoil = this.getExtraStats() instanceof RecoilStats;
                    buf.writeBoolean(hasRecoil);
                    if (!hasRecoil) continue block31;
                    buf.writeInt(((RecoilStats)this.extraStats).recoil());
                    continue block31;
                }
                case MoveUses: {
                    boolean hasMoveUses = this.getExtraStats() instanceof MoveUsesStats;
                    buf.writeBoolean(hasMoveUses);
                    if (!hasMoveUses) continue block31;
                    buf.writeInt(((MoveUsesStats)this.extraStats).getMoveUses());
                    continue block31;
                }
                case BlocksWalkedOutsideBall: {
                    boolean hasBlocksWalkedOutsideBall = this.getExtraStats() instanceof BlocksWalkedOutsideBallStats;
                    buf.writeBoolean(hasBlocksWalkedOutsideBall);
                    if (!hasBlocksWalkedOutsideBall) continue block31;
                    buf.writeInt(((BlocksWalkedOutsideBallStats)this.extraStats).getBlocksWalked());
                    buf.writeFloat(((BlocksWalkedOutsideBallStats)this.extraStats).getPlayerStartWalkDistance());
                    continue block31;
                }
                case Appearance: {
                    boolean isEgg = this.isEgg();
                    buf.writeShort(this.species.getDex());
                    buf.writeBoolean(isEgg);
                    buf.m_130070_(isEgg ? this.species.getDefaultForm().getName() : this.getForm().getName());
                    buf.writeByte(isEgg ? Gender.NONE.ordinal() : this.getGender().ordinal());
                    buf.m_130070_(isEgg ? "" : this.getPalette().getName());
                    buf.m_130070_(this.getBall().getName());
                    continue block31;
                }
                case MoveSkills: {
                    buf.writeByte(this.moveSkillCooldownData.size());
                    for (Map.Entry entry : this.moveSkillCooldownData.entrySet()) {
                        buf.m_130070_((String)entry.getKey());
                        long difference = (Long)((Tuple)entry.getValue()).m_14419_() - System.currentTimeMillis();
                        buf.writeLong(difference);
                    }
                    continue block31;
                }
                case Flags: {
                    buf.writeShort(this.flags.size());
                    for (String string : this.flags) {
                        buf.m_130070_(string);
                    }
                    continue block31;
                }
                case Ribbons: {
                    buf.writeBoolean(this.displayedRibbon != null);
                    if (this.displayedRibbon != null) {
                        PixelmonDataSerializers.RIBBON_TYPE.m_6856_(buf, (Object)this.displayedRibbon);
                    }
                    buf.writeShort(this.ribbons.size());
                    for (Ribbon ribbon : this.ribbons) {
                        PixelmonDataSerializers.RIBBON_TYPE.m_6856_(buf, (Object)ribbon);
                    }
                    continue block31;
                }
            }
        }
    }

    public Pokemon readFromByteBuffer(FriendlyByteBuf buf, EnumUpdateType ... data) {
        if (data == null || data.length == 0) {
            data = EnumUpdateType.ALL;
        }
        this.uuid = buf.m_130259_();
        block31: for (EnumUpdateType type : data) {
            switch (type) {
                case Name: {
                    this.species = PixelmonSpecies.fromNationalDex(Integer.valueOf(buf.readShort()));
                    continue block31;
                }
                case Nickname: {
                    this.nickname = buf.m_130238_();
                    if (!this.nickname.equals("")) continue block31;
                    this.nickname = null;
                    continue block31;
                }
                case Form: {
                    this.form = this.species.getForm(buf.m_130277_());
                    this.gender = Gender.getGender(buf.readByte());
                    boolean hasGrowth = buf.readBoolean();
                    if (hasGrowth) {
                        this.growth = EnumGrowth.getGrowthFromIndex(buf.readByte());
                    }
                    this.palette = this.form.getGenderProperties(this.gender).getPalette(buf.m_130277_());
                    this.invalidate();
                    continue block31;
                }
                case Experience: {
                    this.experience = buf.readInt();
                    continue block31;
                }
                case Stats: {
                    this.nature = Nature.getNatureFromIndex(buf.readByte());
                    this.mintNature = buf.readBoolean() ? Nature.getNatureFromIndex(buf.readByte()) : null;
                    this.level = buf.readShort();
                    this.dynamaxLevel = buf.readShort();
                    this.gigantamaxFactor = buf.readBoolean();
                    this.permanentStats.setHP(buf.readShort());
                    this.permanentStats.setAttack(buf.readShort());
                    this.permanentStats.setDefense(buf.readShort());
                    this.permanentStats.setSpecialAttack(buf.readShort());
                    this.permanentStats.setSpecialDefense(buf.readShort());
                    this.permanentStats.setSpeed(buf.readShort());
                    this.bonusStats = new BonusStats((ByteBuf)buf);
                    continue block31;
                }
                case IVs: {
                    this.getIVs().readFromByteBuffer((ByteBuf)buf);
                    continue block31;
                }
                case EVs: {
                    this.getEVs().readFromByteBuffer((ByteBuf)buf);
                    continue block31;
                }
                case HP: {
                    this.health = buf.readInt();
                    continue block31;
                }
                case Ball: {
                    this.ball = PokeBallRegistry.getPokeBall(buf.m_130277_()).orElse(PokeBallRegistry.POKE_BALL.getValueUnsafe());
                    continue block31;
                }
                case Moveset: {
                    this.moveset = new Moveset().withPokemon(this);
                    this.moveset.fromBytes(buf);
                    continue block31;
                }
                case Status: {
                    short statusTypeOrdinal = buf.readShort();
                    if (statusTypeOrdinal == -1) {
                        this.status = NoStatus.noStatus;
                        continue block31;
                    }
                    this.status = StatusType.getEffectInstance(statusTypeOrdinal);
                    continue block31;
                }
                case CanLevel: {
                    this.doesLevel = buf.readBoolean();
                    continue block31;
                }
                case Egg: {
                    boolean isEgg = buf.readBoolean();
                    if (isEgg) {
                        this.eggCycles = buf.readInt();
                        continue block31;
                    }
                    this.eggCycles = -1;
                    continue block31;
                }
                case HeldItem: {
                    this.heldItem = buf.m_130267_();
                    continue block31;
                }
                case Friendship: {
                    this.friendship = buf.readShort();
                    continue block31;
                }
                case Ability: {
                    String abilityName = buf.m_130277_();
                    Ability newAbility = AbilityRegistry.getAbility(abilityName).orElse(new ComingSoon(abilityName));
                    this.moveset.setAbility(newAbility);
                    if (newAbility instanceof ComingSoon) continue block31;
                    this.overrideAbilitySlot();
                    continue block31;
                }
                case Pokerus: {
                    boolean hasPokerus = buf.readBoolean();
                    if (!hasPokerus) {
                        this.pokerus = null;
                        continue block31;
                    }
                    this.pokerus = (Pokerus)PixelmonDataSerializers.POKERUS.m_6709_(new FriendlyByteBuf((ByteBuf)buf));
                    continue block31;
                }
                case OriginalTrainer: {
                    if (buf.readBoolean()) {
                        this.originalTrainerName = buf.m_130277_();
                        continue block31;
                    }
                    this.originalTrainerName = null;
                    continue block31;
                }
                case Clones: {
                    if (!buf.readBoolean()) continue block31;
                    this.extraStats = new MewStats(buf.readInt());
                    continue block31;
                }
                case Wool_Growth: {
                    if (!buf.readBoolean()) continue block31;
                    this.extraStats = new ShearableStats(buf.readByte());
                    continue block31;
                }
                case Enchants: {
                    if (!buf.readBoolean()) continue block31;
                    this.extraStats = new LakeTrioStats(buf.readInt());
                    continue block31;
                }
                case Meltan_Stats: {
                    if (!buf.readBoolean()) continue block31;
                    this.extraStats = new MeltanStats(buf.readInt());
                    continue block31;
                }
                case Recoil: {
                    if (!buf.readBoolean()) continue block31;
                    this.extraStats = new RecoilStats(buf.readInt());
                    continue block31;
                }
                case MoveUses: {
                    if (!buf.readBoolean()) continue block31;
                    this.extraStats = new MoveUsesStats(buf.readInt());
                    continue block31;
                }
                case BlocksWalkedOutsideBall: {
                    if (!buf.readBoolean()) continue block31;
                    this.extraStats = new BlocksWalkedOutsideBallStats(buf.readInt(), buf.readFloat());
                    continue block31;
                }
                case Appearance: {
                    this.species = PixelmonSpecies.fromNationalDex(Integer.valueOf(buf.readShort()));
                    this.eggCycles = buf.readBoolean() ? 40 : -1;
                    this.form = this.species.getForm(buf.m_130277_());
                    this.gender = Gender.getGender(buf.readByte());
                    this.palette = this.form.getGenderProperties(this.gender).getPalette(buf.m_130277_());
                    this.ball = PokeBallRegistry.getPokeBall(buf.m_130277_()).orElse(PokeBallRegistry.POKE_BALL.getValueUnsafe());
                    continue block31;
                }
                case MoveSkills: {
                    int cooldowns = buf.readByte();
                    HashMap<String, Tuple> newCooldownData = new HashMap<String, Tuple>();
                    for (int i = 0; i < cooldowns; ++i) {
                        newCooldownData.put(buf.m_130277_(), new Tuple((Object)System.currentTimeMillis(), (Object)(System.currentTimeMillis() + buf.readLong())));
                    }
                    this.moveSkillCooldownData = newCooldownData;
                    continue block31;
                }
                case Flags: {
                    this.flags.clear();
                    int n = buf.readUnsignedShort();
                    for (int i = 0; i < n; ++i) {
                        this.flags.add(buf.m_130277_());
                    }
                    continue block31;
                }
                case Ribbons: {
                    this.displayedRibbon = buf.readBoolean() ? (Ribbon)PixelmonDataSerializers.RIBBON_TYPE.m_6709_(buf) : null;
                    this.ribbons.clear();
                    int c = buf.readShort();
                    for (int i = 0; i < c; ++i) {
                        this.ribbons.add((Ribbon)PixelmonDataSerializers.RIBBON_TYPE.m_6709_(buf));
                    }
                    continue block31;
                }
            }
        }
        return this;
    }

    public void readFromNBT(CompoundTag nbt) {
        Object disp;
        Object stack;
        SYNC_POKEMON_BASE.set(this, (Object)PokemonBase.fromNBT(nbt));
        byte NBT_VERSION = nbt.m_128445_("NBT_VERSION");
        if (nbt.m_128441_("UUID")) {
            this.setUUID(nbt.m_128342_("UUID"));
        } else {
            this.setUUID(UUID.randomUUID());
        }
        if (nbt.m_128441_("IsShiny")) {
            if (nbt.m_128471_("IsShiny")) {
                this.setPalette("shiny");
            } else {
                this.setPalette(this.getGenderProperties().getDefaultPalette());
            }
        } else {
            this.setPalette(nbt.m_128461_("palette"));
        }
        this.setNickname(nbt.m_128461_("Nickname"));
        this.setBall(nbt.m_128441_("CaughtBall") ? PokeBallRegistry.getPokeBall(nbt.m_128461_("CaughtBall")).orElse(PokeBallRegistry.POKE_BALL.getValueUnsafe()) : PokeBallRegistry.POKE_BALL.getValueUnsafe());
        this.setNature(Nature.getNatureFromIndex(nbt.m_128445_("Nature")));
        int mintNature = nbt.m_128441_("MintNature") ? (int)nbt.m_128445_("MintNature") : -1;
        Nature nature = this.mintNature = mintNature == -1 ? null : Nature.getNatureFromIndex(mintNature);
        if (NBT_VERSION == 0 && this.mintNature == Nature.HARDY) {
            this.mintNature = null;
        }
        if (nbt.m_128441_("Growth")) {
            this.setGrowth(EnumGrowth.getGrowthFromIndex(nbt.m_128445_("Growth")));
        }
        this.eggSteps = this.eggCycles != -1 && nbt.m_128441_("steps") ? nbt.m_128451_("steps") : -1;
        this.originalTrainerName = nbt.m_128461_("originalTrainer");
        if (nbt.m_128403_("originalTrainerUUID")) {
            this.originalTrainerUUID = nbt.m_128342_("originalTrainerUUID");
        }
        this.pokemonLevelContainer.setLevel(nbt.m_128451_("Level"));
        this.dynamaxLevel = nbt.m_128451_("DynamaxLevel");
        this.gigantamaxFactor = this.getForm().getGigantamax().canHaveFactor() ? nbt.m_128471_("GigantamaxFactor") : false;
        this.experience = nbt.m_128451_("EXP");
        this.setDoesLevel(nbt.m_128471_("DoesLevel"));
        this.setFriendship(nbt.m_128448_("Friendship"));
        this.moveset.readFromNBT(nbt);
        this.permanentStats.readFromNBT(nbt);
        this.bonusStats.readFromNBT(this, nbt);
        this.health = nbt.m_128451_("Health");
        if (this.getExtraStats() != null) {
            this.extraStats.readFromNBT(nbt);
        }
        if (nbt.m_128441_("PAbilitySlot")) {
            this.slot = nbt.m_128451_("PAbilitySlot");
            this.ha = nbt.m_128471_("PHiddenAbility");
        }
        if (nbt.m_128441_("AbilitySlot")) {
            this.moveset.setAbility(this.getForm().getAbilities().resolveFromOldStyleSlot(nbt.m_128445_("AbilitySlot")));
            this.overrideAbilitySlot();
        } else if (nbt.m_128441_("Ability")) {
            String abilityName = nbt.m_128461_("Ability");
            Optional<Ability> ability = AbilityRegistry.getAbility(abilityName);
            if (ability.isPresent()) {
                this.setAbility(ability.get());
            } else {
                this.resetAbility();
            }
        } else {
            this.resetAbility();
        }
        if (nbt.m_128441_("Pokerus")) {
            this.pokerus = Pokerus.deserializeFromNBT(nbt.m_128469_("Pokerus"));
        }
        this.status = StatusPersist.readStatusFromNBT(nbt);
        if (nbt.m_128441_("HeldItemStack")) {
            CompoundTag compound = nbt.m_128469_("HeldItemStack");
            stack = ItemStack.m_41712_((CompoundTag)compound);
            this.heldItem = stack.m_41619_() ? ItemStack.f_41583_ : stack;
        }
        this.persistentData = nbt.m_128469_("PersistentData");
        if (nbt.m_128441_("pixelmonID1")) {
            int[] id = new int[]{nbt.m_128451_("pixelmonID1"), nbt.m_128451_("pixelmonID2")};
            this.persistentData.m_128385_("OLD_pixelmonID", id);
        }
        if (nbt.m_128441_("ForgeData") && nbt.m_128441_("pixelmonID1")) {
            CompoundTag customEntityData = nbt.m_128469_("ForgeData");
            this.persistentData.m_128391_(customEntityData);
        }
        if (nbt.m_128441_("MoveSkillCooldown")) {
            ListTag moveSkillCooldowns = nbt.m_128437_("MoveSkillCooldown", 10);
            if (this.moveSkillCooldownData == null) {
                this.moveSkillCooldownData = Maps.newHashMap();
            }
            if (moveSkillCooldowns != null) {
                stack = moveSkillCooldowns.iterator();
                while (stack.hasNext()) {
                    Tag moveSkillCooldown = (Tag)stack.next();
                    CompoundTag moveSkillData = (CompoundTag)moveSkillCooldown;
                    MoveSkill moveSkill = MoveSkill.getMoveSkillByID(moveSkillData.m_128461_("MoveSkillCooldownId"));
                    long current = moveSkillData.m_128454_("MoveSkillCooldownCurrent");
                    long target = moveSkillData.m_128454_("MoveSkillCooldownTarget");
                    if (moveSkill == null) continue;
                    this.moveSkillCooldownData.put(moveSkill.id, (Tuple<Long, Long>)new Tuple((Object)current, (Object)target));
                }
            }
        }
        if (nbt.m_128441_("SpecFlags")) {
            for (Tag str : nbt.m_128437_("SpecFlags", 8)) {
                String s = str.m_7916_();
                this.flags.add(s);
            }
        }
        if (nbt.m_128441_("ribbon_display") && !((String)(disp = nbt.m_128461_("ribbon_display"))).equalsIgnoreCase("NONE")) {
            this.displayedRibbon = Ribbon.builder().type(RibbonRegistry.getRibbon((String)disp).getValueUnsafe()).receiver(this.getOwnerPlayer()).receivedDate(System.currentTimeMillis()).build();
        }
        if (nbt.m_128441_("ribbons")) {
            this.ribbons.clear();
            for (Tag str : nbt.m_128437_("ribbons", 8)) {
                String disp2 = str.m_7916_();
                RibbonRegistry.getRibbon(disp2).ifInitialized(ribbonType -> this.ribbons.add(Ribbon.builder().type((RibbonType)ribbonType).receiver(this.getOwnerPlayer()).receivedDate(System.currentTimeMillis()).build()));
            }
        }
        if (nbt.m_128441_("ribbon_display2")) {
            disp = nbt.m_128469_("ribbon_display2");
            this.displayedRibbon = Ribbon.fromNbt((CompoundTag)disp);
        }
        if (nbt.m_128441_("ribbons2")) {
            this.ribbons.clear();
            for (Tag tag : nbt.m_128437_("ribbons2", 10)) {
                CompoundTag compound = (CompoundTag)tag;
                this.ribbons.add(Ribbon.fromNbt(compound));
            }
        }
        if (this.displayedRibbon != null) {
            this.displayedRibbon.refreshData(this);
        }
        this.ribbons.forEach(ribbon -> ribbon.refreshData(this));
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.m_128344_("NBT_VERSION", (byte)2);
        nbt.m_128362_("UUID", this.uuid);
        if (this.nickname != null && !Objects.equals(this.nickname, Component.m_237119_())) {
            nbt.m_128359_("Nickname", this.nickname.getString());
        } else {
            nbt.m_128473_("Nickname");
        }
        if (this.ball != null) {
            nbt.m_128359_("CaughtBall", this.ball.getName());
        } else {
            nbt.m_128473_("CaughtBall");
        }
        nbt.m_128344_("Nature", (byte)this.nature.ordinal());
        if (this.mintNature != null) {
            nbt.m_128344_("MintNature", (byte)this.mintNature.ordinal());
        }
        if (this.growth != null) {
            nbt.m_128344_("Growth", (byte)this.growth.index);
        }
        if (this.eggCycles != -1) {
            nbt.m_128405_("steps", this.getEggSteps());
        }
        if (this.originalTrainerName != null && !this.originalTrainerName.isEmpty()) {
            nbt.m_128359_("originalTrainer", this.originalTrainerName);
        } else {
            nbt.m_128473_("originalTrainer");
        }
        if (this.originalTrainerUUID != null) {
            nbt.m_128362_("originalTrainerUUID", this.originalTrainerUUID);
        } else {
            nbt.m_128473_("originalTrainerUUID");
        }
        nbt.m_128405_("Level", this.level);
        nbt.m_128405_("DynamaxLevel", this.dynamaxLevel);
        nbt.m_128379_("GigantamaxFactor", this.gigantamaxFactor);
        nbt.m_128405_("EXP", this.experience);
        nbt.m_128379_("DoesLevel", this.doesLevel);
        nbt.m_128376_("Friendship", (short)this.friendship);
        this.moveset.writeToNBT(nbt);
        this.permanentStats.writeToNBT(nbt);
        this.bonusStats.writeToNBT(nbt);
        nbt.m_128405_("Health", this.health);
        if (this.getExtraStats() != null) {
            this.extraStats.writeToNBT(nbt);
        }
        nbt.m_128405_("PAbilitySlot", this.slot);
        nbt.m_128379_("PHiddenAbility", this.ha);
        if (this.moveset.getAbility() != null) {
            String abilityName = this.getAbilityName();
            nbt.m_128359_("Ability", abilityName);
        }
        if (this.pokerus != null) {
            nbt.m_128365_("Pokerus", (Tag)this.pokerus.serializeToNBT());
        }
        this.status.writeToNBT(nbt);
        if (this.heldItem != null && !this.heldItem.m_41619_()) {
            nbt.m_128365_("HeldItemStack", (Tag)this.heldItem.m_41739_(new CompoundTag()));
        } else {
            nbt.m_128473_("HeldItemStack");
        }
        nbt.m_128365_("PersistentData", (Tag)this.persistentData);
        ListTag moveSkillCooldowns = new ListTag();
        for (Map.Entry<String, Tuple<Long, Long>> entry : this.moveSkillCooldownData.entrySet()) {
            CompoundTag entryNBT = new CompoundTag();
            entryNBT.m_128359_("MoveSkillCooldownId", entry.getKey());
            entryNBT.m_128356_("MoveSkillCooldownCurrent", ((Long)entry.getValue().m_14418_()).longValue());
            entryNBT.m_128356_("MoveSkillCooldownTarget", ((Long)entry.getValue().m_14419_()).longValue());
            moveSkillCooldowns.add((Object)entryNBT);
        }
        if (moveSkillCooldowns.size() != 0) {
            nbt.m_128365_("MoveSkillCooldown", (Tag)moveSkillCooldowns);
        }
        ListTag specList = new ListTag();
        for (String specFlag : this.flags) {
            specList.add((Object)StringTag.m_129297_((String)specFlag));
        }
        nbt.m_128365_("SpecFlags", (Tag)specList);
        if (this.displayedRibbon != null) {
            nbt.m_128365_("ribbon_display2", (Tag)this.displayedRibbon.serialize());
        }
        ListTag listTag = new ListTag();
        for (Ribbon ribbon : this.ribbons) {
            listTag.add((Object)ribbon.serialize());
        }
        nbt.m_128365_("ribbons2", (Tag)listTag);
        return nbt;
    }

    public String toString() {
        return "Pokemon{" + this.getLocalizedName() + "}";
    }

    public boolean hasHiddenAbility() {
        if (this.ha) {
            return true;
        }
        for (Ability hiddenAbility : this.getForm().getAbilities().getHiddenAbilities()) {
            if (!Objects.equals(this.moveset.getAbility(), hiddenAbility)) continue;
            return true;
        }
        return false;
    }

    public int getAbilitySlot() {
        return this.slot;
    }

    public void recordAbilitySlot(Ability ability) {
        if (this.slot == -1) {
            this.findNewAbilitySlot(ability);
        }
    }

    public void overrideAbilitySlot() {
        this.findNewAbilitySlot(this.getAbility());
    }

    private void findNewAbilitySlot(Ability ability) {
        Abilities normalAbilities = this.getForm().getAbilities();
        this.slot = normalAbilities.getAbilitySlot(ability);
        this.ha = false;
        if (this.slot != -1) {
            return;
        }
        this.slot = normalAbilities.getHiddenAbilitySlot(ability);
        if (this.slot != -1) {
            this.ha = true;
        }
    }

    public void resetAbility() {
        if (this.slot == -1) {
            boolean isHidden = PixelmonConfigProxy.getSpawning().shouldHaveHiddenAbility(this.form, this.dimension);
            if ((isHidden || this.ha) && this.getForm().getAbilities().hasHiddenAbilities()) {
                this.setAbility(this.getForm().getAbilities().getRandomHiddenAbility());
            } else {
                this.setAbility(this.getForm().getAbilities().getRandomAbility());
            }
            if (isHidden) {
                this.ha = true;
            }
        } else {
            Ability newAbility = this.getForm().getAbilities().resolveAbility(this.slot, this.ha);
            this.setAbility(newAbility);
        }
    }

    public void setMoveset(Moveset moveset) {
        this.moveset = moveset.withPokemon(this);
    }

    public void rerollMoveset() {
        this.setMoveset(this.getForm().getMoves().loadMoveset(this.level));
    }

    public List<String> getFlags() {
        return Lists.newArrayList(this.flags);
    }
}

