/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.npc.TeachMoveEvent;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.AirSaver;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreenPacket;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class LearnMoveController {
    private static final ListMultimap<UUID, LearnMove> userMap = MultimapBuilder.hashKeys().arrayListValues().build();

    public static boolean canLearnMove(ServerPlayer player, UUID pokemon, ImmutableAttack move) {
        if (userMap.containsKey((Object)player.m_20148_())) {
            Iterator iterator = userMap.get((Object)player.m_20148_()).iterator();
            while (iterator.hasNext()) {
                LearnMove learnMove = (LearnMove)iterator.next();
                if (Pixelmon.EVENT_BUS.post((Event)new TeachMoveEvent.CanLearnMove((Player)player, StorageProxy.getPartyNow(player).get(learnMove.pokemon), move))) {
                    return false;
                }
                if (!Objects.equals(learnMove.pokemon, pokemon) || !Objects.equals(learnMove.move, move)) continue;
                iterator.remove();
                return learnMove.condition == null || learnMove.condition.test(player);
            }
        }
        return false;
    }

    public static boolean hasCondition(ServerPlayer player, UUID pokemon, ImmutableAttack move) {
        if (userMap.containsKey((Object)player.m_20148_())) {
            List learnMoves = userMap.get((Object)player.m_20148_());
            for (LearnMove learnMove : learnMoves) {
                if (!Objects.equals(learnMove.pokemon, pokemon) || !Objects.equals(learnMove.move, move) || learnMove.condition == null) continue;
                return true;
            }
        }
        return false;
    }

    public static void addLearnMove(ServerPlayer player, UUID pokemon, ImmutableAttack move) {
        userMap.put((Object)player.m_20148_(), (Object)new LearnMove(player.m_20148_(), pokemon, move));
    }

    public static void addLearnMove(ServerPlayer player, UUID pokemon, ImmutableAttack move, Predicate<ServerPlayer> condition) {
        userMap.put((Object)player.m_20148_(), (Object)new LearnMove(player.m_20148_(), pokemon, move, condition));
    }

    public static void sendLearnMove(ServerPlayer player, UUID pokemon, ImmutableAttack move) {
        LearnMoveController.addLearnMove(player, pokemon, move);
        NetworkHelper.sendPacket(player, new OpenReplaceMoveScreenPacket(pokemon, move));
    }

    public static void sendLearnMove(ServerPlayer player, UUID pokemon, ImmutableAttack move, boolean checkEvo) {
        LearnMoveController.addLearnMove(player, pokemon, move);
        NetworkHelper.sendPacket(player, new OpenReplaceMoveScreenPacket(pokemon, move, checkEvo));
    }

    public static void sendLearnMove(ServerPlayer player, UUID pokemon, ImmutableAttack move, Predicate<ServerPlayer> condition) {
        LearnMoveController.addLearnMove(player, pokemon, move, condition);
        NetworkHelper.sendPacket(player, new OpenReplaceMoveScreenPacket(pokemon, move));
    }

    public static void clearLearnMoves(ServerPlayer player) {
        userMap.removeAll((Object)player.m_20148_());
    }

    public static void clearLearnMoves(UUID player) {
        userMap.removeAll((Object)player);
    }

    public static Predicate<ServerPlayer> itemCostCondition(ItemStack cost) {
        return LearnMoveController.itemCostCondition(Sets.newHashSet((Object[])new ItemStack[]{cost}));
    }

    public static Predicate<ServerPlayer> itemCostCondition(Collection<ItemStack> costs) {
        return player -> {
            HashSet taken = Sets.newHashSet();
            for (ItemStack cost : costs) {
                if (LearnMoveController.takeItem((NonNullList<ItemStack>)player.m_150109_().f_35974_, cost) || LearnMoveController.takeItem((NonNullList<ItemStack>)player.m_150109_().f_35976_, cost)) {
                    taken.add(cost);
                    continue;
                }
                taken.forEach(arg_0 -> ((Inventory)player.m_150109_()).m_36054_(arg_0));
                ChatHandler.sendFormattedChat((CommandSource)player, ChatFormatting.RED, "pixelmon.npc.cantpay", new Object[0]);
                return false;
            }
            return true;
        };
    }

    private static boolean takeItem(NonNullList<ItemStack> inv, ItemStack cost) {
        for (ItemStack stack : inv) {
            if (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)cost) || stack.m_41613_() < cost.m_41613_()) continue;
            stack.m_41774_(cost.m_41613_());
            return true;
        }
        return false;
    }

    public static void tick(Level world) {
        for (LearnMove value : userMap.values()) {
            value.tick(world);
        }
    }

    public static class LearnMove {
        protected UUID player;
        protected UUID pokemon;
        protected ImmutableAttack move;
        protected Predicate<ServerPlayer> condition = null;
        protected final AirSaver airSaver;

        public LearnMove(UUID player, UUID pokemon, ImmutableAttack move) {
            this.player = player;
            this.pokemon = pokemon;
            this.move = move;
            this.airSaver = new AirSaver(ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.player));
        }

        public LearnMove(UUID player, UUID pokemon, ImmutableAttack move, Predicate<ServerPlayer> condition) {
            this(player, pokemon, move);
            this.condition = condition;
        }

        public void tick(Level world) {
            this.airSaver.tick();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LearnMove learnMove = (LearnMove)o;
            return this.player.equals(learnMove.player) && this.pokemon.equals(learnMove.pokemon) && this.move.equals(learnMove.move);
        }

        public int hashCode() {
            return Objects.hash(this.player, this.pokemon, this.move);
        }
    }
}

