/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Effectiveness;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;

public enum Element implements ITranslatable,
StringRepresentable
{
    NORMAL(0, "Normal", 0xDDDDDD, 8.0f, 520.0f),
    FIRE(1, "Fire", 0xFF8800, 8.0f, 264.0f),
    WATER(2, "Water", 5727743, 1288.0f, 520.0f),
    ELECTRIC(3, "Electric", 16118348, 776.0f, 8.0f),
    GRASS(4, "Grass", 54304, 776.0f, 264.0f),
    ICE(5, "Ice", 0xB0FFFF, 1288.0f, 264.0f),
    FIGHTING(6, "Fighting", 12189752, 1288.0f, 8.0f),
    POISON(7, "Poison", 13174256, 264.0f, 520.0f),
    GROUND(8, "Ground", 10053184, 1031.0f, 264.0f),
    FLYING(9, "Flying", 13424127, 264.0f, 264.0f),
    PSYCHIC(10, "Psychic", 16614535, 520.0f, 520.0f),
    BUG(11, "Bug", 11067475, 8.0f, 8.0f),
    ROCK(12, "Rock", 10712917, 775.0f, 519.0f),
    GHOST(13, "Ghost", 7089034, 520.0f, 264.0f),
    DRAGON(14, "Dragon", 2830540, 520.0f, 8.0f),
    DARK(15, "Dark", 0x404040, 264.0f, 8.0f),
    STEEL(16, "Steel", 0xBCBCC2, 1032.0f, 520.0f),
    MYSTERY(17, "Mystery", 3184256, 1544.0f, 8.0f),
    FAIRY(18, "Fairy", 16733419, 1032.0f, 8.0f);

    private int index;
    private String name;
    private int color;
    public float textureX;
    public float textureY;
    private static final Set<Element> ELEMENTS;

    private Element(int i, String s, int c, float texX, float texY) {
        this.index = i;
        this.name = s;
        this.color = c;
        this.textureX = texX;
        this.textureY = texY;
    }

    public static Set<Element> getElements() {
        return ELEMENTS;
    }

    public int getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTranslationKey() {
        return "type." + this.name.toLowerCase(Locale.ROOT);
    }

    @Override
    public String getLocalizedName() {
        return Component.m_237115_((String)this.getTranslationKey()).getString();
    }

    public static Element parseType(int index) {
        try {
            return Element.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return NORMAL;
        }
    }

    public static Element parseType(String name) {
        try {
            return Element.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            return NORMAL;
        }
    }

    public static Element parseOrNull(int index) {
        try {
            return Element.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static Element parseOrNull(String name) {
        try {
            return Element.valueOf(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Element> getAllTypes() {
        return Arrays.asList(Element.values());
    }

    public static float getTotalEffectiveness(List<Element> elements, Element attackType) {
        return Element.getTotalEffectiveness(elements, attackType, false);
    }

    public static float getTotalEffectiveness(List<Element> elements, Element attackType, boolean inverse) {
        float f = 1.0f;
        for (Element type : elements) {
            if (type == null) continue;
            f *= Element.getEffectiveness((Element)attackType, (Element)type, (boolean)inverse).value;
        }
        return f;
    }

    public static float inverseEffectiveness(float effectiveness) {
        return effectiveness == 0.0f ? 2.0f : 1.0f / effectiveness;
    }

    public static Effectiveness getEffectiveness(Element t, Element t1) {
        return Element.getEffectiveness(t, t1, false);
    }

    public static Effectiveness getEffectiveness(Element t, Element t1, boolean inverse) {
        if (t == MYSTERY || t1 == MYSTERY) {
            return Effectiveness.Normal;
        }
        Effectiveness e = Effectiveness.Normal;
        if (t == NORMAL) {
            if (t1 == ROCK || t1 == STEEL) {
                e = Effectiveness.Not;
            } else if (t1 == GHOST) {
                e = Effectiveness.None;
            }
        } else if (t == FIRE) {
            if (t1 == GRASS || t1 == ICE || t1 == BUG || t1 == STEEL) {
                e = Effectiveness.Super;
            } else if (t1 == FIRE || t1 == WATER || t1 == ROCK || t1 == DRAGON) {
                e = Effectiveness.Not;
            }
        } else if (t == WATER) {
            if (t1 == FIRE || t1 == GROUND || t1 == ROCK) {
                e = Effectiveness.Super;
            } else if (t1 == WATER || t1 == GRASS || t1 == DRAGON) {
                e = Effectiveness.Not;
            }
        } else if (t == ELECTRIC) {
            if (t1 == WATER || t1 == FLYING) {
                e = Effectiveness.Super;
            } else if (t1 == ELECTRIC || t1 == GRASS || t1 == DRAGON) {
                e = Effectiveness.Not;
            } else if (t1 == GROUND) {
                e = Effectiveness.None;
            }
        } else if (t == GRASS) {
            if (t1 == WATER || t1 == GROUND || t1 == ROCK) {
                e = Effectiveness.Super;
            } else if (t1 == FIRE || t1 == GRASS || t1 == POISON || t1 == FLYING || t1 == BUG || t1 == DRAGON || t1 == STEEL) {
                e = Effectiveness.Not;
            }
        } else if (t == ICE) {
            if (t1 == GRASS || t1 == GROUND || t1 == FLYING || t1 == DRAGON) {
                e = Effectiveness.Super;
            } else if (t1 == FIRE || t1 == WATER || t1 == ICE || t1 == STEEL) {
                e = Effectiveness.Not;
            }
        } else if (t == FIGHTING) {
            if (t1 == NORMAL || t1 == ICE || t1 == ROCK || t1 == DARK || t1 == STEEL) {
                e = Effectiveness.Super;
            } else if (t1 == POISON || t1 == FLYING || t1 == PSYCHIC | t1 == BUG || t1 == FAIRY) {
                e = Effectiveness.Not;
            } else if (t1 == GHOST) {
                e = Effectiveness.None;
            }
        } else if (t == POISON) {
            if (t1 == GRASS || t1 == FAIRY) {
                e = Effectiveness.Super;
            } else if (t1 == POISON || t1 == GROUND || t1 == ROCK || t1 == GHOST) {
                e = Effectiveness.Not;
            } else if (t1 == STEEL) {
                e = Effectiveness.None;
            }
        } else if (t == GROUND) {
            if (t1 == FIRE || t1 == ELECTRIC || t1 == POISON || t1 == ROCK || t1 == STEEL) {
                e = Effectiveness.Super;
            } else if (t1 == GRASS || t1 == BUG) {
                e = Effectiveness.Not;
            } else if (t1 == FLYING) {
                e = Effectiveness.None;
            }
        } else if (t == FLYING) {
            if (t1 == GRASS || t1 == FIGHTING || t1 == BUG) {
                e = Effectiveness.Super;
            } else if (t1 == ELECTRIC || t1 == ROCK || t1 == STEEL) {
                e = Effectiveness.Not;
            }
        } else if (t == PSYCHIC) {
            if (t1 == FIGHTING || t1 == POISON) {
                e = Effectiveness.Super;
            } else if (t1 == PSYCHIC || t1 == STEEL) {
                e = Effectiveness.Not;
            } else if (t1 == DARK) {
                e = Effectiveness.None;
            }
        } else if (t == BUG) {
            if (t1 == GRASS || t1 == PSYCHIC || t1 == DARK) {
                e = Effectiveness.Super;
            } else if (t1 == FIRE || t1 == FIGHTING || t1 == POISON || t1 == FLYING || t1 == GHOST || t1 == STEEL || t1 == FAIRY) {
                e = Effectiveness.Not;
            }
        } else if (t == ROCK) {
            if (t1 == FIRE || t1 == ICE || t1 == FLYING || t1 == BUG) {
                e = Effectiveness.Super;
            } else if (t1 == FIGHTING || t1 == GROUND || t1 == STEEL) {
                e = Effectiveness.Not;
            }
        } else if (t == GHOST) {
            if (t1 == PSYCHIC || t1 == GHOST) {
                e = Effectiveness.Super;
            } else if (t1 == DARK) {
                e = Effectiveness.Not;
            } else if (t1 == NORMAL) {
                e = Effectiveness.None;
            }
        } else if (t == DRAGON) {
            if (t1 == DRAGON) {
                e = Effectiveness.Super;
            } else if (t1 == STEEL) {
                e = Effectiveness.Not;
            } else if (t1 == FAIRY) {
                e = Effectiveness.None;
            }
        } else if (t == DARK) {
            if (t1 == PSYCHIC || t1 == GHOST) {
                e = Effectiveness.Super;
            } else if (t1 == FIGHTING || t1 == DARK || t1 == FAIRY) {
                e = Effectiveness.Not;
            }
        } else if (t == STEEL) {
            if (t1 == ICE || t1 == ROCK || t1 == FAIRY) {
                e = Effectiveness.Super;
            } else if (t1 == FIRE || t1 == WATER || t1 == ELECTRIC || t1 == STEEL) {
                e = Effectiveness.Not;
            }
        } else if (t == FAIRY) {
            if (t1 == DARK || t1 == DRAGON || t1 == FIGHTING) {
                e = Effectiveness.Super;
            } else if (t1 == FIRE || t1 == POISON || t1 == STEEL) {
                e = Effectiveness.Not;
            }
        }
        if (inverse) {
            if (e == Effectiveness.Super) {
                return Effectiveness.Not;
            }
            if (e == Effectiveness.Max) {
                return Effectiveness.Barely;
            }
            if (e == Effectiveness.Not) {
                return Effectiveness.Super;
            }
            if (e == Effectiveness.Barely) {
                return Effectiveness.Max;
            }
            if (e == Effectiveness.None) {
                return Effectiveness.Super;
            }
            return Effectiveness.Normal;
        }
        return e;
    }

    public int getIndex() {
        return this.index;
    }

    public List<Element> makeTypeList() {
        return Collections.singletonList(this);
    }

    public static boolean hasType(String name) {
        try {
            return Element.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<Element> ignoreType(List<Element> origTypes, Element ignoreType) {
        ArrayList elements = Lists.newArrayList();
        for (Element origType : origTypes) {
            if (origType == ignoreType) continue;
            elements.add(origType);
        }
        if (elements.isEmpty()) {
            elements.add(MYSTERY);
        }
        return elements;
    }

    public String m_7912_() {
        return this.name;
    }

    public static Element getRandomType(boolean mystery) {
        Element type;
        do {
            type = Element.values()[RandomHelper.getRandom().nextInt(Element.values().length)];
        } while (!mystery && type == MYSTERY);
        return type;
    }

    public static List<Element> getRandomTypes(int count, boolean mystery, boolean unique) {
        ArrayList possibleTypes = Lists.newArrayList((Object[])Element.values());
        if (!mystery) {
            possibleTypes.remove(MYSTERY);
        }
        ArrayList types = Lists.newArrayList();
        for (int i = 0; i < count && !possibleTypes.isEmpty(); ++i) {
            types.add(unique ? (Element)RandomHelper.removeRandomElementFromCollection(possibleTypes) : (Element)RandomHelper.getRandomElementFromCollection(possibleTypes));
        }
        return types;
    }

    public static String[] getTypeNames(boolean mystery) {
        String[] names = new String[mystery ? Element.values().length : Element.values().length - 1];
        int i = 0;
        for (Element type : Element.values()) {
            if (type == MYSTERY && !mystery) continue;
            names[i] = type.name();
            ++i;
        }
        return names;
    }

    static {
        ELEMENTS = new HashSet<Element>();
        for (Element e : Element.values()) {
            if (e == MYSTERY) continue;
            ELEMENTS.add(e);
        }
    }

    public static class TypeAdapter
    implements JsonSerializer<Element>,
    JsonDeserializer<Element> {
        public Element deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Element.valueOf(json.getAsString().toUpperCase());
        }

        public JsonElement serialize(Element src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.name());
        }
    }
}

