/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokedex;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.pixelmonmod.pixelmon.api.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexEntry;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.comm.ClientUpdatePokedexPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerPokedex {
    public UUID uuid;
    private Int2ObjectMap<PokedexRegistrationStatus> seenMap;
    public Table<Integer, Short, Short> formDex = HashBasedTable.create();

    public PlayerPokedex() {
        this(null);
    }

    public PlayerPokedex(UUID uuid) {
        this.uuid = uuid;
        this.seenMap = new Int2ObjectOpenHashMap();
    }

    public PlayerPokedex setUUID(UUID uuid) {
        this.uuid = uuid;
        return this;
    }

    public CompoundTag readFromNBT(CompoundTag nbt) {
        this.seenMap.clear();
        ListTag nbtl = nbt.m_128437_("Pokedex", 8);
        for (int i = 0; i < nbtl.size(); ++i) {
            String[] s = nbtl.m_128778_(i).split(":");
            this.seenMap.put(Integer.parseInt(s[0]), (Object)PokedexRegistrationStatus.get(Integer.parseInt(s[1])));
        }
        ListTag nbt2 = nbt.m_128437_("FormDex", 8);
        for (int i = 0; i < nbt2.size(); ++i) {
            try {
                String[] s = nbt2.m_128778_(i).split(":");
                this.formDex.put((Object)Integer.parseInt(s[0]), (Object)Short.parseShort(s[1]), (Object)Short.parseShort(s[2]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nbt;
    }

    public Map<Integer, PokedexRegistrationStatus> getSeenMap() {
        return this.seenMap;
    }

    public float getSeenCompletionPercentage() {
        return (float)this.countSeen() / ((float)Pokedex.pokedexSize + 0.0f) * 100.0f;
    }

    public float getCaughtCompletionPercentage() {
        return (float)this.countCaught() / ((float)Pokedex.pokedexSize + 0.0f) * 100.0f;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        ListTag nbtl = new ListTag();
        for (Map.Entry e : this.seenMap.entrySet()) {
            nbtl.add((Object)StringTag.m_129297_((String)(e.getKey() + ":" + ((PokedexRegistrationStatus)((Object)e.getValue())).ordinal())));
        }
        nbt.m_128365_("Pokedex", (Tag)nbtl);
        ListTag nbt2 = new ListTag();
        this.formDex.cellSet().forEach(cell -> nbt2.add((Object)StringTag.m_129297_((String)(cell.getRowKey() + ":" + cell.getColumnKey() + ":" + cell.getValue()))));
        nbt.m_128365_("FormDex", (Tag)nbt2);
        return nbt;
    }

    public void update() {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.uuid);
        if (player != null) {
            NetworkHelper.sendPacket(new ClientUpdatePokedexPacket(this), player);
        }
    }

    public boolean set(Pokemon pokemon, PokedexRegistrationStatus drs) {
        short id = (short)FormLogRegistry.getFirstIdFromPokemon(pokemon);
        if (id != -1) {
            Short aShort = (Short)this.formDex.get((Object)pokemon.getSpecies().getDex(), (Object)id);
            if (aShort == null) {
                aShort = 0;
            }
            this.formDex.put((Object)pokemon.getSpecies().getDex(), (Object)id, (Object)((short)(aShort + 1)));
        }
        return this.set(pokemon.getSpecies().getDex(), drs);
    }

    public boolean set(int id, PokedexRegistrationStatus drs) {
        if (this.seenMap.containsKey(id) && ((PokedexRegistrationStatus)((Object)this.seenMap.get(id))).ordinal() > drs.ordinal()) {
            return false;
        }
        if (id > 0) {
            this.seenMap.put(id, (Object)drs);
            return true;
        }
        this.checkForCharms();
        return false;
    }

    public static boolean set(UUID playerUUID, Pokemon id, PokedexRegistrationStatus drs) {
        PlayerPartyStorage storage = StorageProxy.getPartyNow(playerUUID);
        boolean bool = storage.playerPokedex.set(id, drs);
        storage.playerPokedex.update();
        return bool;
    }

    public void wipe() {
        this.seenMap.clear();
        this.update();
    }

    public PokedexRegistrationStatus get(int id) {
        PokedexRegistrationStatus d = (PokedexRegistrationStatus)((Object)this.seenMap.get(id));
        if (d == null) {
            d = PokedexRegistrationStatus.UNKNOWN;
        }
        return d;
    }

    public PokedexEntry getEntry(int id) {
        PokedexRegistrationStatus d = (PokedexRegistrationStatus)((Object)this.seenMap.get(id));
        if (d == null) {
            d = PokedexRegistrationStatus.UNKNOWN;
        }
        switch (d) {
            case CAUGHT: {
                return Pokedex.FULL_POKEDEX.get(id);
            }
            case SEEN: {
                return new PokedexEntry(id, Pokedex.FULL_POKEDEX.get(id).getName());
            }
        }
        return new PokedexEntry(id, "???");
    }

    public boolean isRegistered(Species species) {
        return this.get(species.getDex()) != PokedexRegistrationStatus.UNKNOWN;
    }

    public boolean hasSeen(Species species) {
        if (species == null) {
            return false;
        }
        PokedexRegistrationStatus d = this.get(species.getDex());
        return d == PokedexRegistrationStatus.SEEN || this.hasCaught(species);
    }

    public boolean hasCaught(Species species) {
        return species != null && this.get(species.getDex()) == PokedexRegistrationStatus.CAUGHT;
    }

    public int countCaught() {
        int count = 0;
        for (Species actualPokedex : Pokedex.actualPokedex) {
            if (!this.hasCaught(actualPokedex)) continue;
            ++count;
        }
        return count;
    }

    public int countCaught(int generation) {
        if (generation <= 0) {
            return this.countCaught();
        }
        int count = 0;
        for (Species actualPokedex : Pokedex.actualPokedex) {
            if (actualPokedex.getGeneration() != generation || !this.hasCaught(actualPokedex)) continue;
            ++count;
        }
        return count;
    }

    public int countSeen() {
        int count = 0;
        for (Species actualPokedex : Pokedex.actualPokedex) {
            if (!this.hasSeen(actualPokedex)) continue;
            ++count;
        }
        return count;
    }

    public int countSeen(int generation) {
        if (generation == 0) {
            return this.countSeen();
        }
        int count = 0;
        for (Species actualPokedex : Pokedex.actualPokedex) {
            if (actualPokedex.getGeneration() != generation || !this.hasSeen(actualPokedex)) continue;
            ++count;
        }
        return count;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSeenMap(Map<Integer, PokedexRegistrationStatus> seenMap) {
        this.seenMap = new Int2ObjectOpenHashMap(seenMap);
    }

    public Map<Short, Short> seenForms(Species species) {
        return this.formDex.row((Object)species.getDex());
    }

    public void checkForOvalCharm() {
        if (PixelmonConfigProxy.getGeneral().isAllowOvalCharmFromPokedex()) {
            for (int i = 1; i <= PixelmonSpecies.getGenerations().size(); ++i) {
                if (this.countCaught(i) != PixelmonSpecies.getGenerationDex(i).size()) continue;
                PlayerPartyStorage partyStorage = StorageProxy.getPartyNow(this.uuid);
                if (partyStorage.getOvalCharm() != EnumFeatureState.Disabled) break;
                partyStorage.setOvalCharm(EnumFeatureState.Active);
                OpenScreenPacket.open((Player)partyStorage.getPlayer(), EnumGuiScreen.OvalCharm, new int[0]);
                break;
            }
        }
    }

    public void checkForCharms() {
        this.checkForOvalCharm();
        this.checkForShinyCharm();
    }

    public void checkForShinyCharm() {
        PlayerPartyStorage partyStorage;
        if (PixelmonConfigProxy.getGeneral().isAllowShinyCharmFromPokedex() && this.countCaught() >= Pokedex.pokedexSize && (partyStorage = StorageProxy.getPartyNow(this.uuid)).getShinyCharm() == EnumFeatureState.Disabled) {
            partyStorage.setShinyCharm(EnumFeatureState.Active);
            OpenScreenPacket.open((Player)partyStorage.getPlayer(), EnumGuiScreen.ShinyCharm, new int[0]);
        }
    }

    public void setSeenList(HashMap<Integer, PokedexRegistrationStatus> data) {
        this.seenMap = new Int2ObjectOpenHashMap(data);
    }

    public static class PokedexSpawnData {
        private String biome;
        private List<WorldTime> times = Lists.newArrayList();
        private List<WeatherType> weathers = Lists.newArrayList();
        private Integer maxY;
        private Integer minY;

        public PokedexSpawnData(String biome) {
            this.biome = biome;
        }

        public String getBiome() {
            return this.biome;
        }

        public List<WorldTime> getTimes() {
            return this.times;
        }

        public List<WeatherType> getWeathers() {
            return this.weathers;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public int getMinY() {
            return this.minY;
        }

        public void setMaxY(int maxY) {
            this.maxY = maxY;
        }

        public void setMinY(int minY) {
            this.minY = minY;
        }

        public void addWeather(WeatherType weather) {
            this.weathers.add(weather);
        }

        public void addTime(WorldTime time) {
            this.times.add(time);
        }

        public void encryptTo(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.biome);
            buffer.writeInt(this.times.size());
            for (WorldTime time : this.times) {
                buffer.writeInt(time.ordinal());
            }
            buffer.writeInt(this.weathers.size());
            for (WeatherType weather : this.weathers) {
                buffer.writeInt(weather.ordinal());
            }
            buffer.writeBoolean(this.maxY != null);
            if (this.maxY != null) {
                buffer.writeInt(this.maxY.intValue());
            }
            buffer.writeBoolean(this.minY != null);
            if (this.minY != null) {
                buffer.writeInt(this.minY.intValue());
            }
        }

        public static PokedexSpawnData decryptFrom(FriendlyByteBuf buffer) {
            int i;
            PokedexSpawnData data = new PokedexSpawnData(buffer.m_130277_());
            int size = buffer.readInt();
            for (i = 0; i < size; ++i) {
                data.addTime(WorldTime.values()[buffer.readInt()]);
            }
            size = buffer.readInt();
            for (i = 0; i < size; ++i) {
                data.addWeather(WeatherType.values()[buffer.readInt()]);
            }
            if (buffer.readBoolean()) {
                data.maxY = buffer.readInt();
            }
            if (buffer.readBoolean()) {
                data.minY = buffer.readInt();
            }
            return data;
        }

        public String toString() {
            int i;
            StringBuilder sb = new StringBuilder();
            if (this.biome != null) {
                sb.append(this.biome);
            }
            if (!this.times.isEmpty()) {
                sb.append(" ").append(I18n.m_118938_((String)"gui.pokedex.spawning.times1", (Object[])new Object[0]));
                for (i = 0; i < this.times.size(); ++i) {
                    WorldTime time = this.times.get(i);
                    if (i == 0) {
                        sb.append(" ").append(time.getLocalizedName().toLowerCase(Locale.ROOT));
                        continue;
                    }
                    sb.append(", ");
                    if (i < this.times.size() - 1) {
                        sb.append(time.getLocalizedName().toLowerCase(Locale.ROOT));
                        continue;
                    }
                    sb.append(I18n.m_118938_((String)"gui.pokedex.spawning.times2", (Object[])new Object[0])).append(" ").append(time.getLocalizedName().toLowerCase(Locale.ROOT));
                }
            }
            if (!this.weathers.isEmpty()) {
                sb.append(" ").append(I18n.m_118938_((String)"gui.pokedex.spawning.weather1", (Object[])new Object[0]));
                for (i = 0; i < this.weathers.size(); ++i) {
                    WeatherType weather = this.weathers.get(i);
                    if (i == 0) {
                        sb.append(" ").append(weather.getLocalizedName().toLowerCase(Locale.ROOT));
                        continue;
                    }
                    sb.append(", ");
                    if (i < this.weathers.size() - 1) {
                        sb.append(weather.getLocalizedName().toLowerCase(Locale.ROOT));
                        continue;
                    }
                    sb.append(I18n.m_118938_((String)"gui.pokedex.spawning.weather2", (Object[])new Object[0])).append(" ").append(weather.getLocalizedName().toLowerCase(Locale.ROOT));
                }
            }
            if (this.minY != null) {
                sb.append(" ").append(I18n.m_118938_((String)"gui.pokedex.spawning.above", (Object[])new Object[0])).append(this.minY);
            }
            if (this.maxY != null) {
                sb.append(" ").append(I18n.m_118938_((String)"gui.pokedex.spawning.below", (Object[])new Object[0])).append(this.maxY);
            }
            return sb.toString();
        }
    }
}

