/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.overlay.scoreboard;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.BoardPosition;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.ScoreboardFactory;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.line.ScoreboardLine;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.line.entry.TextEntry;
import com.pixelmonmod.pixelmon.api.overlay.scoreboard.type.ScreenBoardPosition;
import com.pixelmonmod.pixelmon.api.util.TargetPoint;
import java.awt.Color;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class Scoreboard {
    private String identifier;
    private BoardPosition position;
    private List<ScoreboardLine> lines = Lists.newCopyOnWriteArrayList();

    public Scoreboard(String identifier, ScreenBoardPosition position) {
        this.position = position;
    }

    public Scoreboard() {
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ScoreboardLine newLine() {
        ScoreboardLine line = new ScoreboardLine();
        line.title(false);
        line.line(this.lines.size());
        line.showBackground();
        return line;
    }

    public ScoreboardLine textLine(Component text) {
        ScoreboardLine scoreboardLine = this.newLine();
        scoreboardLine.backgroundColor(Color.GRAY);
        scoreboardLine.height(20.0f);
        scoreboardLine.entry(TextEntry.of(text));
        scoreboardLine.wrapWidth(true);
        return scoreboardLine;
    }

    public ScoreboardLine titleLine(Component title) {
        ScoreboardLine scoreboardLine = this.newLine();
        scoreboardLine.backgroundColor(Color.GRAY);
        scoreboardLine.height(20.0f);
        scoreboardLine.entry(TextEntry.of(title));
        scoreboardLine.wrapWidth(true);
        scoreboardLine.title();
        return scoreboardLine;
    }

    public void setLine(int index, ScoreboardLine line) {
        this.lines.set(index, line);
    }

    public void insertLine(int index, ScoreboardLine line) {
        this.lines.add(index, line);
    }

    public int countLines() {
        return this.lines.size();
    }

    public float getHeightUpTo(int index) {
        float height = 0.0f;
        for (int i = 0; i < index; ++i) {
            for (ScoreboardLine line : this.lines) {
                height += line.getHeight();
            }
        }
        return height;
    }

    public void setPosition(ScreenBoardPosition position) {
        this.position = position;
    }

    public BoardPosition getPosition() {
        return this.position;
    }

    public List<ScoreboardLine> getLines() {
        return this.lines;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.identifier);
        this.position.encode(buffer);
        buffer.writeInt(this.countLines());
        for (ScoreboardLine line : this.lines) {
            line.encode(buffer);
        }
    }

    public void decode(FriendlyByteBuf buffer) {
        this.identifier = buffer.m_130277_();
        this.position = ScoreboardFactory.get(buffer.m_130277_(), buffer);
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ScoreboardLine line = new ScoreboardLine();
            line.decode(buffer);
            this.lines.add(line);
        }
    }

    public Scoreboard player(ServerPlayer player) {
        ScoreboardFactory.addPlayerBoard(player, this);
        return this;
    }

    public Scoreboard position(TargetPoint point) {
        ScoreboardFactory.addPositionBoard(point, this);
        return this;
    }
}

