/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.overlay.notice;

import com.google.common.base.Preconditions;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.pixelmon.api.overlay.notice.EnumOverlayLayout;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.OverlayGraphicType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.custom.overlays.CustomNoticePacketPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class NoticeOverlay {
    public static void hide(ServerPlayer player) {
        CustomNoticePacketPacket packet = new CustomNoticePacketPacket();
        packet.setEnabled(false);
        NetworkHelper.sendPacket(packet, player);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected List<Component> lines = null;
        protected EnumOverlayLayout layout = null;
        protected OverlayGraphicType type = null;
        protected PokemonSpecification spec = null;
        protected ItemStack itemStack = null;

        protected Builder() {
        }

        public Builder setPokemonSprite(PokemonSpecification spec) {
            this.spec = (PokemonSpecification)Preconditions.checkNotNull((Object)spec, (Object)"spec");
            this.type = OverlayGraphicType.PokemonSprite;
            return this;
        }

        public Builder setPokemon3D(PokemonSpecification spec) {
            this.spec = (PokemonSpecification)Preconditions.checkNotNull((Object)spec, (Object)"spec");
            this.type = OverlayGraphicType.Pokemon3D;
            return this;
        }

        public Builder setItemStack(ItemStack itemStack) {
            if (itemStack.m_41619_()) {
                return this.setEmpty();
            }
            this.itemStack = (ItemStack)Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack");
            this.type = OverlayGraphicType.ItemStack;
            return this;
        }

        public Builder setEmpty() {
            this.type = null;
            return this;
        }

        public Builder setLayout(EnumOverlayLayout layout) {
            this.layout = (EnumOverlayLayout)((Object)Preconditions.checkNotNull((Object)((Object)layout), (Object)"layout"));
            return this;
        }

        public Builder addLine(Component line) {
            this.lines.add((Component)Preconditions.checkNotNull((Object)line, (Object)"line"));
            return this;
        }

        public Builder addLines(List<Component> lines) {
            this.lines.addAll((Collection)Preconditions.checkNotNull(lines, (Object)"lines"));
            return this;
        }

        public Builder addLines(Component ... lines) {
            return this.addLines(Arrays.asList((Component[])Preconditions.checkNotNull((Object)lines, (Object)"lines")));
        }

        public Builder setLines(@Nullable List<Component> lines) {
            this.lines = lines == null || lines.isEmpty() ? null : new ArrayList<Component>(lines);
            return this;
        }

        public Builder setLines(Component ... lines) {
            this.lines = lines == null || lines.length == 0 ? null : new ArrayList<Component>(Arrays.asList(lines));
            return this;
        }

        public CustomNoticePacketPacket build() {
            CustomNoticePacketPacket packet = new CustomNoticePacketPacket();
            if (this.lines != null && !this.lines.isEmpty()) {
                packet.setLines(this.lines.toArray(new Component[0]));
            }
            if (this.type != null) {
                Preconditions.checkArgument((this.layout != null ? 1 : 0) != 0, (Object)"You must specify the layout when using a sprite.");
                switch (this.type) {
                    case PokemonSprite: {
                        packet.setPokemonSprite(this.spec, this.layout);
                        break;
                    }
                    case Pokemon3D: {
                        packet.setPokemon3D(this.spec, this.layout);
                        break;
                    }
                    case ItemStack: {
                        packet.setItemStack(this.itemStack, this.layout);
                    }
                }
            }
            return packet;
        }

        public void sendTo(ServerPlayer player) {
            NetworkHelper.sendPacket(this.build(), player);
        }
    }
}

