/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class JsonItemStack {
    public String itemID = "minecraft:stone";
    public Integer quantity = null;
    public String nbt = null;
    public Float percentChance = null;
    private transient ItemStack stack = null;

    public JsonItemStack() {
    }

    public JsonItemStack(Item item) {
        this.itemID = ForgeRegistries.ITEMS.getKey((Object)item).toString();
    }

    public ItemStack getItemStack() {
        if (this.stack == null) {
            Item item = null;
            if (this.itemID.contains(":")) {
                ResourceLocation resourceLocation = ResourceLocationHelper.of(this.itemID.split(":")[0], this.itemID.split(":")[1]);
                item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item == null) {
                    Pixelmon.LOGGER.error("Invalid item ID found in SpawnInfo: " + this.itemID + " is not a recognized item.");
                    return ItemStack.f_41583_;
                }
            } else {
                ArrayList matchingItems = new ArrayList();
                ForgeRegistries.ITEMS.forEach(testItem -> {
                    if (ForgeRegistries.ITEMS.getKey(testItem).m_135815_().equalsIgnoreCase(this.itemID)) {
                        matchingItems.add(testItem);
                    }
                });
                if (matchingItems.isEmpty()) {
                    Pixelmon.LOGGER.error("Invalid item ID found in SpawnInfo: " + this.itemID + " is not a recognized item.");
                    return ItemStack.f_41583_;
                }
                if (matchingItems.size() > 1) {
                    Pixelmon.LOGGER.error("Duplicate items found for item ID in SpawnInfo: " + this.itemID + ". Prefix this id with the resource domain, such as: 'minecraft:'");
                    return ItemStack.f_41583_;
                }
                item = (Item)matchingItems.get(0);
            }
            this.stack = new ItemStack((ItemLike)item, this.quantity == null ? 1 : this.quantity);
            CompoundTag deserializedNBT = null;
            if (this.nbt != null) {
                try {
                    deserializedNBT = TagParser.m_129359_((String)this.nbt);
                }
                catch (CommandSyntaxException e) {
                    Pixelmon.LOGGER.error("Bad NBT: " + this.nbt);
                    e.printStackTrace();
                }
            }
            if (deserializedNBT != null) {
                if (this.stack.m_41783_() == null) {
                    this.stack.m_41751_(new CompoundTag());
                }
                this.stack.m_41751_(deserializedNBT);
            }
        }
        return this.stack.m_41777_();
    }

    public static ItemStack choose(List<JsonItemStack> stacks) {
        float chosenPercentage;
        float percentSum = 0.0f;
        for (JsonItemStack stack : stacks) {
            if (stack.percentChance == null || !(stack.percentChance.floatValue() > 0.0f)) continue;
            if (percentSum + stack.percentChance.floatValue() > 100.0f) {
                Pixelmon.LOGGER.warn("Itemstack percent chance is above 100%. Overflowed to: " + (percentSum + stack.percentChance.floatValue()));
                break;
            }
            percentSum += stack.percentChance.floatValue();
        }
        if ((chosenPercentage = RandomHelper.getRandomNumberBetween(0.0f, 100.0f)) > percentSum) {
            return null;
        }
        percentSum = 0.0f;
        for (JsonItemStack stack : stacks) {
            if (stack.percentChance == null || !(stack.percentChance.floatValue() > 0.0f) || !((percentSum += stack.percentChance.floatValue()) >= chosenPercentage)) continue;
            return stack.getItemStack();
        }
        return null;
    }
}

