/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.screens;

import com.pixelmonmod.pixelmon.items.BadgeCaseItem;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class BadgeCaseEvent
extends Event {
    private final ServerPlayer player;
    private final boolean wasCustom;

    public BadgeCaseEvent(ServerPlayer player, boolean custom) {
        this.player = player;
        this.wasCustom = custom;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public boolean isCustom() {
        return this.wasCustom;
    }

    @Cancelable
    public static class Swap
    extends BadgeCaseEvent {
        private final int index1;
        private final int index2;

        public Swap(ServerPlayer player, boolean custom, int index1, int index2) {
            super(player, custom);
            this.index1 = index1;
            this.index2 = index2;
        }

        public int getIndex1() {
            return this.index1;
        }

        public int getIndex2() {
            return this.index2;
        }
    }

    @Cancelable
    public static class Remove
    extends BadgeCaseEvent {
        private final int index;

        public Remove(ServerPlayer player, boolean custom, int index) {
            super(player, custom);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Nullable
        public ItemStack getStack() {
            ItemStack hand;
            BadgeCaseItem.BadgeCase badgeCase;
            if (this.isCustom() && this.getPlayer().m_21205_().m_41720_() instanceof BadgeCaseItem && (badgeCase = BadgeCaseItem.BadgeCase.readFromItemStack(hand = this.getPlayer().m_21205_())) != null && this.index >= 0 && this.index < badgeCase.badges.size()) {
                ItemStack removed = badgeCase.badges.get(this.index);
                return removed != null ? removed : ItemStack.f_41583_;
            }
            return null;
        }
    }

    @Cancelable
    public static class Register
    extends BadgeCaseEvent {
        public Register(ServerPlayer player, boolean custom) {
            super(player, custom);
        }
    }
}

