/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class NPCTutorEvent
extends Event {
    protected final Player player;
    protected final NPCTutor npc;

    public NPCTutorEvent(Player player, NPCTutor npc) {
        this.player = player;
        this.npc = npc;
    }

    public Player getPlayer() {
        return this.player;
    }

    public NPCTutor getNpc() {
        return this.npc;
    }

    public static class CollectLearnableMoves
    extends NPCTutorEvent {
        protected final Pokemon pokemon;
        protected List<NPCTutor.LearnableMove> learnableMoves;

        public CollectLearnableMoves(Player player, NPCTutor npc, Pokemon pokemon, List<NPCTutor.LearnableMove> learnableMoves) {
            super(player, npc);
            this.pokemon = pokemon;
            this.learnableMoves = learnableMoves;
        }

        public Pokemon getPokemon() {
            return this.pokemon;
        }

        public List<NPCTutor.LearnableMove> getLearnableMoves() {
            return this.learnableMoves;
        }

        public static class Post
        extends CollectLearnableMoves {
            public Post(Player player, NPCTutor npc, Pokemon pokemon, List<NPCTutor.LearnableMove> learnableMoves) {
                super(player, npc, pokemon, learnableMoves);
            }
        }

        @Cancelable
        public static class Pre
        extends CollectLearnableMoves {
            public Pre(Player player, NPCTutor npc, Pokemon pokemon, List<NPCTutor.LearnableMove> learnableMoves) {
                super(player, npc, pokemon, learnableMoves);
            }

            public void addLearnableMoves(NPCTutor.LearnableMove ... moves) {
                this.learnableMoves.addAll(Arrays.asList(moves));
            }

            public void setLearnableMoves(List<NPCTutor.LearnableMove> learnableMoves) {
                this.learnableMoves = learnableMoves;
            }
        }
    }
}

