/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class NPCTraderEvent
extends Event {
    protected final Player player;
    protected final NPCEntity trader;

    public NPCTraderEvent(Player player, NPCEntity trader) {
        this.player = player;
        this.trader = trader;
    }

    public Player getPlayer() {
        return this.player;
    }

    public NPCEntity getTrader() {
        return this.trader;
    }

    public static class AcceptTrade
    extends NPCTraderEvent {
        protected final TradePair tradePair;
        protected final Pokemon playerPokemon;
        protected Pokemon tradedPokemon;
        protected boolean removeNPC;

        public AcceptTrade(Player player, NPCEntity trader, TradePair tradePair, Pokemon playerPokemon, Pokemon tradedPokemon, boolean removeNPC) {
            super(player, trader);
            this.tradePair = tradePair;
            this.playerPokemon = playerPokemon;
            this.tradedPokemon = tradedPokemon;
            this.removeNPC = removeNPC;
        }

        public TradePair getTradePair() {
            return this.tradePair;
        }

        public Pokemon getPlayerPokemon() {
            return this.playerPokemon;
        }

        public boolean isRemoveNPC() {
            return this.removeNPC;
        }

        public Pokemon getTradedPokemon() {
            return this.tradedPokemon;
        }

        public static class Post
        extends AcceptTrade {
            public Post(Player player, NPCEntity trader, TradePair tradePair, Pokemon playerPokemon, Pokemon tradedPokemon, boolean removeNPC) {
                super(player, trader, tradePair, playerPokemon, tradedPokemon, removeNPC);
            }
        }

        @Cancelable
        public static class Pre
        extends AcceptTrade {
            public Pre(Player player, NPCEntity trader, TradePair tradePair, Pokemon playerPokemon, Pokemon tradedPokemon, boolean removeNPC) {
                super(player, trader, tradePair, playerPokemon, tradedPokemon, removeNPC);
            }

            public void setRemoveNPC(boolean removeNPC) {
                this.removeNPC = removeNPC;
            }

            public void setTradedPokemon(Pokemon pokemon) {
                this.tradedPokemon = pokemon;
            }
        }
    }

    public static class ShowTrade
    extends NPCTraderEvent {
        protected TradePair trade;

        public ShowTrade(Player player, NPCEntity trader, TradePair trade) {
            super(player, trader);
            this.trade = trade;
        }

        public TradePair getTrade() {
            return this.trade;
        }

        public static class Post
        extends ShowTrade {
            public Post(Player player, NPCEntity trader, TradePair trade) {
                super(player, trader, trade);
            }
        }

        @Cancelable
        public static class Pre
        extends ShowTrade {
            public Pre(Player player, NPCEntity trader, TradePair trade) {
                super(player, trader, trade);
            }

            public void setTrade(TradePair trade) {
                this.trade = trade;
            }
        }
    }
}

