/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.legendary;

import com.pixelmonmod.pixelmon.blocks.tileentity.ArcChaliceTileEntity;
import com.pixelmonmod.pixelmon.blocks.tileentity.TimespaceAltarTileEntity;
import com.pixelmonmod.pixelmon.enums.EnumPlate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public abstract class ArceusEvent
extends Event {
    protected UUID playerUUID;

    public ArceusEvent(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Nullable
    public ServerPlayer getPlayer() {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.playerUUID);
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Cancelable
    public static class PlayFlute
    extends ArceusEvent {
        protected final ItemStack azureFlute;
        protected final TimespaceAltarTileEntity altar;

        public PlayFlute(ServerPlayer player, ItemStack azureFlute, TimespaceAltarTileEntity altar) {
            super(player.m_20148_());
            this.azureFlute = azureFlute;
            this.altar = altar;
        }

        public ItemStack getAzureFlute() {
            return this.azureFlute;
        }

        public TimespaceAltarTileEntity getAltar() {
            return this.altar;
        }
    }

    public static class CreateFlute
    extends ArceusEvent {
        private final ArcChaliceTileEntity chalice;
        private final ItemEntity azureFlute;

        public CreateFlute(UUID playerUUID, ArcChaliceTileEntity chalice, ItemEntity azureFlute) {
            super(playerUUID);
            this.chalice = chalice;
            this.azureFlute = azureFlute;
        }

        public ArcChaliceTileEntity getChalice() {
            return this.chalice;
        }

        public ItemEntity getAzureFlute() {
            return this.azureFlute;
        }
    }

    @Cancelable
    public static class AddPlate
    extends ArceusEvent {
        private final ArcChaliceTileEntity chalice;
        private final ItemStack stack;

        public AddPlate(ServerPlayer player, ArcChaliceTileEntity chalice, ItemStack stack) {
            super(player.m_20148_());
            this.chalice = chalice;
            this.stack = stack;
        }

        public EnumPlate getPlate() {
            return EnumPlate.getPlateForItem(this.stack.m_41720_());
        }

        public ArcChaliceTileEntity getChalice() {
            return this.chalice;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

