/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Event;

public class HiddenPowerCalculateEvent
extends Event {
    private final String cause;
    private final Pokemon pokemon;
    private Element calculatedValue;

    public HiddenPowerCalculateEvent(String cause, Pokemon pokemon, Element calculatedValue) {
        this.cause = cause;
        this.pokemon = pokemon;
        this.calculatedValue = calculatedValue;
    }

    public String getCause() {
        return this.cause;
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public Player getPlayer() {
        return this.pokemon.getOwnerPlayer();
    }

    public boolean isInternal() {
        return Constants.GAME_CAUSES.contains(this.getCause());
    }

    public Element getCalculatedValue() {
        return this.calculatedValue;
    }

    public void setCalculatedValue(Element calculatedValue) {
        this.calculatedValue = calculatedValue;
    }

    public Optional<PixelmonWrapper> getBattlePokemon() {
        return this.pokemon.getPixelmonWrapper();
    }

    public static class Constants {
        public static final String BATTLE = "Battle";
        public static final String COMMAND = "Command";
        public static final String OTHER = "Unknown";
        public static final List<String> GAME_CAUSES = Lists.newArrayList((Object[])new String[]{"Battle", "Command"});
    }
}

