/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BagSection;
import com.pixelmonmod.pixelmon.api.battles.BattleItemScanner;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEvent;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.items.ItemData;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;

public class BagItemEvent
extends BattleEvent {
    private final String identifier;
    private final ServerPlayer player;

    public BagItemEvent(BattleController battleController, String identifier, ServerPlayer player) {
        super(battleController);
        this.identifier = identifier;
        this.player = player;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isIdentifier(String identifier) {
        return this.identifier.equals(identifier);
    }

    public boolean isNormalBattle() {
        return this.identifier.isEmpty();
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public static class Identifiers {
        public static final String NORMAL = "";
        public static final String END_OF_RAID = "EndOfRaid";

        private Identifiers() {
            throw new IllegalStateException("Cannot instantiate this class");
        }
    }

    public static class SelectItem
    extends BagItemEvent {
        protected final ItemStack selectedItem;
        protected ItemStack foundItem;

        public SelectItem(BattleController battleController, String identifier, ServerPlayer player, ItemStack selectedItem, ItemStack foundItem) {
            super(battleController, identifier, player);
            this.selectedItem = selectedItem;
            this.foundItem = foundItem;
        }

        public ItemStack getSelectedItem() {
            return this.selectedItem;
        }

        public ItemStack getFoundItem() {
            return this.foundItem;
        }

        public static class Post
        extends SelectItem {
            public Post(BattleController battleController, String identifier, ServerPlayer player, ItemStack selectedItem, ItemStack foundItem) {
                super(battleController, identifier, player, selectedItem, foundItem);
            }
        }

        @Cancelable
        public static class Pre
        extends SelectItem {
            public Pre(BattleController battleController, String identifier, ServerPlayer player, ItemStack selectedItem, ItemStack foundItem) {
                super(battleController, identifier, player, selectedItem, foundItem);
            }

            public void setFoundItem(ItemStack foundItem) {
                this.foundItem = foundItem;
            }
        }
    }

    public static class CollectItems
    extends BagItemEvent {
        private final BagSection section;
        protected List<ItemData> items;

        public CollectItems(BattleController battleController, String identifier, ServerPlayer player, BagSection section, List<ItemData> items) {
            super(battleController, identifier, player);
            this.section = section;
            this.items = items;
        }

        public BagSection getSection() {
            return this.section;
        }

        public List<ItemData> getItems() {
            return this.items;
        }

        public static class Post
        extends CollectItems {
            public Post(BattleController battleController, String identifier, ServerPlayer player, BagSection section, List<ItemData> items) {
                super(battleController, identifier, player, section, items);
            }
        }

        @Cancelable
        public static class Pre
        extends CollectItems {
            public Pre(BattleController battleController, String identifier, ServerPlayer player, BagSection section, List<ItemData> items) {
                super(battleController, identifier, player, section, items);
            }

            public Pre(BattleController battleController, String identifier, ServerPlayer player, BagSection section) {
                this(battleController, identifier, player, section, BattleItemScanner.scan(player, section));
            }

            public void setItems(List<ItemData> itemData) {
                this.items = itemData;
            }

            public void addItems(ItemData ... itemData) {
                this.items.addAll(Lists.newArrayList((Object[])itemData));
            }
        }
    }
}

