/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events.battles;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.Effectiveness;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;

public abstract class AttackEvent
extends BattleEvent {
    public final PixelmonWrapper user;
    public final PixelmonWrapper target;

    protected AttackEvent(BattleController battleController, PixelmonWrapper user, PixelmonWrapper target) {
        super(battleController);
        this.user = user;
        this.target = target;
    }

    public Attack getAttack() {
        return this.user.attack;
    }

    public boolean isSelf() {
        return this.user == this.target;
    }

    public static class Recoil
    extends AttackEvent {
        private final double recoil;
        private final boolean fatal;

        public Recoil(BattleController battleController, PixelmonWrapper user, double recoil, boolean fatal) {
            super(battleController, user, user);
            this.recoil = recoil;
            this.fatal = fatal;
        }

        public double getRecoil() {
            return this.recoil;
        }

        public boolean isFatal() {
            return this.fatal;
        }
    }

    public static class Damage
    extends AttackEvent {
        public double damage;

        public Damage(BattleController battleController, PixelmonWrapper user, PixelmonWrapper target, double damage) {
            super(battleController, user, target);
            this.damage = damage;
        }

        public boolean willBeFatal() {
            return this.target.getHealth() < (this.damage < 1.0 && this.damage > 0.0 ? 1 : (int)this.damage);
        }
    }

    public static class CriticalHit
    extends AttackEvent {
        public double critMultiplier;

        public CriticalHit(BattleController battleController, PixelmonWrapper user, PixelmonWrapper target, double critMultiplier) {
            super(battleController, user, target);
            this.critMultiplier = critMultiplier;
        }

        public boolean isCrit() {
            return this.critMultiplier != 1.0;
        }

        public void setCrit(boolean crit) {
            this.critMultiplier = crit ? 2.0 : 1.0;
        }
    }

    public static class TypeEffectiveness
    extends AttackEvent {
        private double effectiveness = -1.0;

        public TypeEffectiveness(BattleController battleController, PixelmonWrapper user, PixelmonWrapper target, double effectiveness) {
            super(battleController, user, target);
            this.effectiveness = effectiveness;
        }

        public void setEffectiveness(Effectiveness effectiveness) {
            this.effectiveness = effectiveness.value;
        }

        public Effectiveness getEffectiveness() {
            return CollectionHelper.find(Lists.newArrayList((Object[])Effectiveness.values()), e -> (double)e.value == this.effectiveness);
        }

        public double getMultiplier() {
            return this.effectiveness;
        }
    }

    public static class Stab
    extends AttackEvent {
        public double stabMultiplier;
        private final double originalMultiplier;

        public Stab(BattleController battleController, PixelmonWrapper user, PixelmonWrapper target, double stabMultiplier) {
            super(battleController, user, target);
            this.stabMultiplier = this.originalMultiplier = stabMultiplier;
        }

        public boolean isStabbing() {
            return this.stabMultiplier != 1.0;
        }

        public void setStabbing(boolean stabbing) {
            this.stabMultiplier = stabbing ? this.user.getAbility().modifyStab(this.originalMultiplier) : 1.0;
        }
    }

    public static class Use
    extends AttackEvent {
        public final ImmutableAttack attack;
        public double accuracy;
        public boolean cantMiss;

        public Use(BattleController battleController, PixelmonWrapper user, PixelmonWrapper target, ImmutableAttack attack, double accuracy, boolean cantMiss) {
            super(battleController, user, target);
            this.attack = attack;
            this.accuracy = accuracy;
            this.cantMiss = cantMiss;
        }
    }
}

