/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class TeleportItemEvent
extends Event {
    protected ItemStack itemStack;
    protected Player player;
    protected String level;
    protected BlockPos teleportPosition;
    protected boolean consumeItemStack;
    protected boolean teleportToSpawnpoint;

    public TeleportItemEvent(ItemStack item, Player player, String level, BlockPos teleportPosition, boolean consumeItemStack, boolean teleportToSpawnpoint) {
        this.itemStack = item;
        this.player = player;
        this.level = level;
        this.teleportPosition = teleportPosition;
        this.consumeItemStack = consumeItemStack;
        this.teleportToSpawnpoint = teleportToSpawnpoint;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getLevel() {
        return this.level;
    }

    public Optional<ServerLevel> getActualLevel() {
        return DimensionHelper.getWorld(this.getLevel());
    }

    public BlockPos getTeleportPosition() {
        return this.teleportPosition;
    }

    public boolean shouldConsumeItemStack() {
        return this.consumeItemStack;
    }

    public boolean shouldTeleportToSpawnpoint() {
        return this.teleportToSpawnpoint;
    }

    public static class Post
    extends TeleportItemEvent {
        public Post(ItemStack item, Player player, String level, BlockPos teleportPosition, boolean consumeItemStack, boolean teleportToSpawnpoint) {
            super(item, player, level, teleportPosition, consumeItemStack, teleportToSpawnpoint);
        }
    }

    @Cancelable
    public static class Pre
    extends TeleportItemEvent {
        public Pre(ItemStack item, Player player, String level, BlockPos teleportPosition, boolean consumeItemStack, boolean teleportToSpawnpoint) {
            super(item, player, level, teleportPosition, consumeItemStack, teleportToSpawnpoint);
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public void setTeleportPosition(BlockPos teleportPosition) {
            this.teleportPosition = teleportPosition;
        }

        public void setConsumeItem(boolean consumeItemStack) {
            this.consumeItemStack = consumeItemStack;
        }

        public void setTeleportToSpawnpoint(boolean teleportToSpawnpoint) {
            this.teleportToSpawnpoint = teleportToSpawnpoint;
        }
    }
}

