/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class StatueEvent
extends Event {
    public final ServerPlayer player;

    public StatueEvent(ServerPlayer player) {
        this.player = player;
    }

    @Cancelable
    public static class DestroyStatue
    extends StatueEvent {
        public final StatueEntity statue;

        public DestroyStatue(ServerPlayer player, StatueEntity statue) {
            super(player);
            this.statue = statue;
        }
    }

    @Cancelable
    public static class ModifyStatue
    extends StatueEvent {
        private StatueEntity statue;
        public final EnumStatuePacketMode changeType;
        private Object value;

        public ModifyStatue(ServerPlayer player, StatueEntity statue, EnumStatuePacketMode changeType, Object value) {
            super(player);
            this.statue = statue;
            this.changeType = changeType;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            if (value != null && value.getClass() == this.value.getClass()) {
                this.value = value;
            }
        }

        public StatueEntity getStatue() {
            return this.statue;
        }

        public void setStatue(StatueEntity statue) {
            if (statue != null) {
                this.statue = statue;
            }
        }
    }

    @Cancelable
    public static class CreateStatue
    extends StatueEvent {
        public final ServerLevel world;
        public final BlockPos location;
        private StatueEntity statue;

        public CreateStatue(ServerPlayer player, ServerLevel world, BlockPos location, StatueEntity statue) {
            super(player);
            this.world = world;
            this.location = location;
            this.statue = statue;
        }

        public StatueEntity getStatue() {
            return this.statue;
        }

        public void setStatue(StatueEntity statue) {
            if (statue != null) {
                this.statue = statue;
            }
        }
    }
}

