/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Event;

public class PokemonRetrievedEvent
extends Event {
    private final LivingEntity owner;
    private final String cause;
    private final Pokemon pokemon;

    public PokemonRetrievedEvent(@Nullable LivingEntity owner, Pokemon pokemon, String cause) {
        this.owner = owner;
        this.cause = cause;
        this.pokemon = pokemon;
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.owner;
    }

    public String getCause() {
        return this.cause;
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public static class Post
    extends PokemonRetrievedEvent {
        public Post(@Nullable LivingEntity owner, Pokemon pokemon, String cause) {
            super(owner, pokemon, cause);
        }
    }

    public static class Pre
    extends PokemonRetrievedEvent {
        public Pre(@Nullable LivingEntity owner, Pokemon pokemon, String cause) {
            super(owner, pokemon, cause);
        }
    }

    public static class Constants {
        public static final String COMMAND = "Command";
        public static final String BLOCK_INTERACT = "BlockInteract";
        public static final String END_OF_BATTLE = "EndOfBattle";
        public static final String ENTITY_INTERACT = "EntityInteract";
        public static final String FAINTED = "Fainted";
        public static final String FORCED = "Forced";
        public static final String FORM_CHANGE = "FormChange";
        public static final String PLAYER_ACTIVATED = "PlayerActivated";
        public static final String POKEMON_CAUGHT = "PokemonCaught";
        public static final String POKEMON_DELETED = "PokemonDeleted";
        public static final String POKEMON_EDITOR = "PokemonEditor";
        public static final String POKEMON_RELEASED = "PokemonReleased";
        public static final String SWITCH_IN_BATTLE = "SwitchInBattle";
        public static final Set<String> GAME_CAUSES = Sets.newHashSet((Object[])new String[]{"Command", "BlockInteract", "EndOfBattle", "EntityInteract", "Fainted", "Forced", "FormChange", "PlayerActivated", "PokemonCaught", "PokemonDeleted", "PokemonEditor", "PokemonReleased", "SwitchInBattle"});
    }
}

