/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class PokemonReceivedEvent
extends Event {
    private final ServerPlayer player;
    private final String cause;
    private final Pokemon pokemon;

    public PokemonReceivedEvent(ServerPlayer player, Pokemon pokemon, String cause) {
        this.player = player;
        this.cause = cause;
        this.pokemon = pokemon;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public String getCause() {
        return this.cause;
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public boolean isInternal() {
        return Constants.GAME_CAUSES.contains(this.getCause());
    }

    public static class Constants {
        public static final String CHRISTMAS = "Christmas";
        public static final String COMMAND = "Command";
        public static final String GIFT_COMMAND = "GiftCommand";
        public static final String EVOLUTION = "Evolution";
        public static final String FOSSIL = "Fossil";
        public static final String POKE_BALL = "PokeBall";
        public static final String STARTER = "Starter";
        public static final String TRADE = "Trade";
        public static final String UNKNOWN = "Unkown";
        public static final Set<String> GAME_CAUSES = Sets.newHashSet((Object[])new String[]{"Christmas", "Command", "Evolution", "Fossil", "PokeBall", "Starter", "Trade"});
    }
}

