/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokedex.PokedexRegistrationStatus;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

@Cancelable
public class PokedexEvent
extends Event {
    protected final UUID uuid;
    protected final PokedexRegistrationStatus oldStatus;
    protected Pokemon pokemon;
    protected PokedexRegistrationStatus newStatus;
    protected String cause;

    protected PokedexEvent(UUID uuid, Pokemon pokemon, PokedexRegistrationStatus newStatus, String cause) {
        this.uuid = uuid;
        this.pokemon = pokemon;
        this.oldStatus = StorageProxy.getPartyNow((UUID)uuid).playerPokedex.get(pokemon.getSpecies().getDex());
        this.newStatus = newStatus;
        this.cause = cause;
    }

    public PokedexEvent(UUID uuid, PokedexRegistrationStatus oldStatus, Pokemon pokemon, PokedexRegistrationStatus newStatus, String cause) {
        this.uuid = uuid;
        this.oldStatus = oldStatus;
        this.pokemon = pokemon;
        this.newStatus = newStatus;
        this.cause = cause;
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public ServerPlayer getPlayer() {
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(this.uuid);
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public PlayerPokedex getPokedex() {
        return StorageProxy.getPartyNow((UUID)this.uuid).playerPokedex;
    }

    public PokedexRegistrationStatus getNewStatus() {
        return this.newStatus;
    }

    public PokedexRegistrationStatus getOldStatus() {
        return this.oldStatus;
    }

    public String getCause() {
        return this.cause;
    }

    public boolean isCausedBy(String ... causes) {
        for (String s : causes) {
            if (!this.cause.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isCausedByCapture() {
        return this.isCausedBy("capture");
    }

    public boolean isCausedByPlayerTrade() {
        return this.isCausedBy("tradePlayer");
    }

    public boolean isCausedByNPCTrade() {
        return this.isCausedBy("tradeNPC");
    }

    public boolean isCausedByEvolution() {
        return this.isCausedBy("evolution");
    }

    public boolean isCausedByEggHatching() {
        return this.isCausedBy("egg");
    }

    public boolean isCausedByStorageMovement() {
        return this.isCausedBy("storageMovement");
    }

    public boolean isBeingSeenByPokedexKey() {
        return this.isCausedBy("pokedexKey");
    }

    public boolean isCausedBySidemod() {
        return !this.isCausedBy(Constants.INTERNAL);
    }

    public boolean isInternal() {
        return this.isCausedBy(Constants.INTERNAL);
    }

    public static class Constants {
        public static final String CAPTURE = "capture";
        public static final String TRADE_PLAYER = "tradePlayer";
        public static final String TRADE_NPC = "tradeNPC";
        public static final String EVOLUTION = "evolution";
        public static final String EGG = "egg";
        public static final String STORAGE_MOVEMENT = "storageMovement";
        public static final String COMMAND_GIVEN = "commandGiven";
        public static final String POKEDEX_KEY = "pokedexKey";
        public static final String BATTLE = "battles";
        public static final String[] INTERNAL = new String[]{"capture", "egg", "tradeNPC", "tradePlayer", "evolution", "storageMovement"};
    }

    public static class Post
    extends PokedexEvent {
        public Post(UUID uuid, PokedexRegistrationStatus oldStatus, Pokemon pokemon, PokedexRegistrationStatus newStatus, String cause) {
            super(uuid, oldStatus, pokemon, newStatus, cause);
        }
    }

    @Cancelable
    public static class Pre
    extends PokedexEvent {
        public Pre(UUID uuid, Pokemon pokemon, PokedexRegistrationStatus newStatus, String cause) {
            super(uuid, pokemon, newStatus, cause);
        }

        public void setNewStatus(PokedexRegistrationStatus newStatus) {
            this.newStatus = newStatus;
        }

        public void setPokemon(Pokemon pokemon) {
            this.pokemon = pokemon;
        }

        public void setCause(String cause) {
            this.cause = cause;
        }
    }
}

