/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.events;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.items.heldItems.MegaStoneItem;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class MegaEvolutionEvent
extends Event {
    private final ServerPlayer player;
    private final Pokemon pokemon;
    private final ItemStack stone;
    private final boolean ultraBurst;

    protected MegaEvolutionEvent(ServerPlayer player, Pokemon pokemon) {
        this(player, pokemon, null, false);
    }

    protected MegaEvolutionEvent(ServerPlayer player, Pokemon pokemon, ItemStack item) {
        this(player, pokemon, item, false);
    }

    protected MegaEvolutionEvent(ServerPlayer player, Pokemon pokemon, ItemStack stone, boolean ultraBurst) {
        this.player = player;
        this.pokemon = pokemon;
        this.stone = stone;
        this.ultraBurst = ultraBurst;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public Optional<ItemStack> getStone() {
        return Optional.ofNullable(this.stone);
    }

    public Optional<MegaStoneItem> getStoneItem() {
        if (this.stone == null) {
            return Optional.empty();
        }
        Item item = this.stone.m_41720_();
        if (!(item instanceof MegaStoneItem)) {
            return Optional.empty();
        }
        return Optional.of((MegaStoneItem)item);
    }

    public boolean isUltraBurst() {
        return this.ultraBurst;
    }

    public Optional<PixelmonEntity> getEntity() {
        return this.getPokemon().getPixelmonEntity();
    }

    public static class Post
    extends MegaEvolutionEvent {
        public Post(ServerPlayer player, Pokemon pokemon, ItemStack stone, boolean ultraBurst) {
            super(player, pokemon, stone, ultraBurst);
        }
    }

    @Cancelable
    public static class Battle
    extends MegaEvolutionEvent {
        private final PixelmonWrapper pixelmonWrapper;

        public Battle(ServerPlayer player, PixelmonWrapper pixelmonWrapper, ItemStack stone, boolean ultraBurst) {
            super(player, pixelmonWrapper.pokemon, stone, ultraBurst);
            this.pixelmonWrapper = pixelmonWrapper;
        }

        public PixelmonWrapper getPixelmonWrapper() {
            return this.pixelmonWrapper;
        }
    }

    @Cancelable
    public static class MoveSkill
    extends MegaEvolutionEvent {
        public MoveSkill(ServerPlayer player, Pokemon pokemon) {
            super(player, pokemon);
        }

        public MoveSkill(ServerPlayer player, Pokemon pokemon, ItemStack item) {
            super(player, pokemon, item);
        }
    }

    @Cancelable
    public static class Pre
    extends MegaEvolutionEvent {
        public Pre(ServerPlayer player, Pokemon pokemon) {
            super(player, pokemon);
        }
    }
}

